/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.tabs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.Serializable;
import java.util.Enumeration;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.xml.bind.JAXBException;
import phex.gui.actions.FWAction;
import phex.gui.common.FWTable;
import phex.gui.common.FWToolBar;
import phex.gui.common.GUIRegistry;
import phex.gui.common.GUIUtils;
import phex.gui.dialogs.SecurityRuleConfigDialog;
import phex.gui.models.FWSortedTableModel;
import phex.gui.models.FWTableColumnModel;
import phex.gui.models.SecurityTableModel;
import phex.gui.renderer.SecurityRuleRowRenderer;
import phex.gui.tabs.FWTab;
import phex.security.IPAccessRule;
import phex.security.PhexSecurityManager;
import phex.security.SecurityRule;
import phex.utils.Localizer;
import phex.xml.ObjectFactory;
import phex.xml.XJBGUISettings;
import phex.xml.XJBGUITable;
import phex.xml.XJBGUITableColumnList;

public class SecurityTab
extends FWTab {
    private static final String SECURITY_TABLE_IDENTIFIER = "SecurityTable";
    private static final SecurityRule[] EMPTY_SECURITYRULE_ARRAY = new SecurityRule[0];
    private JPopupMenu securityPopup;
    private SecurityTableModel securityModel;
    private FWTableColumnModel securityColumnModel;
    private FWTable securityTable;
    private JScrollPane securityTableScrollPane;
    private PhexSecurityManager securityMgr = PhexSecurityManager.getInstance();
    private static final String EDIT_SECURITY_RULE_ACTION_KEY = "EditSecurityRuleAction";

    public SecurityTab() {
        super(1005, Localizer.getString("Security"), GUIRegistry.getInstance().getIconFactory().getIcon("Security"), Localizer.getString("TTTSecurity"), Localizer.getChar("SecurityMnemonic"), KeyStroke.getKeyStroke(Localizer.getString("SecurityAccelerator")), 5);
    }

    public void initComponent(XJBGUISettings xJBGUISettings) {
        Serializable serializable;
        MouseHandler mouseHandler = new MouseHandler();
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(this.getBackground().darker()), Localizer.getString("Security")));
        this.securityModel = new SecurityTableModel();
        XJBGUITable xJBGUITable = GUIUtils.getXJBGUITableByIdentifier(xJBGUISettings, SECURITY_TABLE_IDENTIFIER);
        this.buildSecurityTableColumnModel(xJBGUITable);
        this.securityTable = new FWTable((TableModel)new FWSortedTableModel(this.securityModel), this.securityColumnModel);
        SecurityRuleRowRenderer securityRuleRowRenderer = new SecurityRuleRowRenderer();
        Enumeration<TableColumn> enumeration = this.securityColumnModel.getColumns();
        while (enumeration.hasMoreElements()) {
            serializable = enumeration.nextElement();
            ((TableColumn)serializable).setCellRenderer(securityRuleRowRenderer);
        }
        this.securityTable.getSelectionModel().addListSelectionListener(new SelectionHandler());
        this.securityTable.activateAllHeaderActions();
        this.securityTable.setAutoResizeMode(0);
        this.securityTable.addMouseListener(mouseHandler);
        this.securityTableScrollPane = FWTable.createFWTableScrollPane(this.securityTable);
        this.securityTableScrollPane.addMouseListener(mouseHandler);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        jPanel.add((Component)this.securityTableScrollPane, gridBagConstraints);
        serializable = new JPanel(new GridBagLayout());
        ((JComponent)serializable).setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 4, 0, 4), BorderFactory.createEtchedBorder()));
        FWToolBar fWToolBar = new FWToolBar(0);
        fWToolBar.setBorderPainted(false);
        fWToolBar.setFloatable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.anchor = 18;
        ((Container)serializable).add(fWToolBar, gridBagConstraints);
        this.securityPopup = new JPopupMenu();
        FWAction fWAction = new NewSecurityRuleAction();
        this.addTabAction(fWAction);
        fWToolBar.addAction(fWAction);
        this.securityPopup.add(fWAction);
        fWAction = new EditSecurityRuleAction();
        this.addTabAction(EDIT_SECURITY_RULE_ACTION_KEY, fWAction);
        fWToolBar.addAction(fWAction);
        this.securityPopup.add(fWAction);
        fWAction = new RemoveSecurityRuleAction();
        this.addTabAction(fWAction);
        fWToolBar.addAction(fWAction);
        this.securityPopup.add(fWAction);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)serializable, gridBagConstraints);
        this.add("Center", jPanel);
    }

    public void updateUI() {
        super.updateUI();
        if (this.securityTableScrollPane != null) {
            FWTable.updateFWTableScrollPane(this.securityTableScrollPane);
        }
    }

    private SecurityRule[] getSelectedSecurityRules() {
        if (this.securityTable.getSelectedRowCount() == 0) {
            return EMPTY_SECURITYRULE_ARRAY;
        }
        int[] nArray = this.securityTable.getSelectedRows();
        int[] nArray2 = this.securityTable.convertRowIndicesToModel(nArray);
        SecurityRule[] securityRuleArray = this.securityMgr.getIPAccessRulesAt(nArray2);
        return securityRuleArray;
    }

    private void buildSecurityTableColumnModel(XJBGUITable xJBGUITable) {
        int[] nArray = SecurityTableModel.getColumnIdArray();
        XJBGUITableColumnList xJBGUITableColumnList = null;
        if (xJBGUITable != null) {
            xJBGUITableColumnList = xJBGUITable.getTableColumnList();
        }
        this.securityColumnModel = new FWTableColumnModel(this.securityModel, nArray, xJBGUITableColumnList);
    }

    public void appendXJBGUISettings(XJBGUISettings xJBGUISettings) throws JAXBException {
        super.appendXJBGUISettings(xJBGUISettings);
        XJBGUITableColumnList xJBGUITableColumnList = this.securityColumnModel.createXJBGUITableColumnList();
        XJBGUITable xJBGUITable = ObjectFactory.createXJBGUITable();
        xJBGUITable.setTableColumnList(xJBGUITableColumnList);
        xJBGUITable.setTableIdentifier(SECURITY_TABLE_IDENTIFIER);
        xJBGUISettings.getTableList().getTableList().add(xJBGUITable);
    }

    public class RemoveSecurityRuleAction
    extends FWAction {
        public RemoveSecurityRuleAction() {
            super(Localizer.getString("RemoveSecurityRule"), GUIRegistry.getInstance().getIconFactory().getIcon("Close"), Localizer.getString("TTTRemoveSecurityRule"));
            this.refreshActionState();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (SecurityTab.this.securityTable.getSelectedRow() < 0) {
                this.setEnabled(false);
                return;
            }
            SecurityRule[] securityRuleArray = SecurityTab.this.getSelectedSecurityRules();
            int n = 0;
            while (n < securityRuleArray.length) {
                if (securityRuleArray[n] != null && !securityRuleArray[n].isSystemRule()) {
                    PhexSecurityManager.getInstance().removeSecurityRule(securityRuleArray[n]);
                }
                ++n;
            }
        }

        public void refreshActionState() {
            int n = SecurityTab.this.securityTable.getSelectedRow();
            if (n < 0) {
                this.setEnabled(false);
                return;
            }
            SecurityRule[] securityRuleArray = SecurityTab.this.getSelectedSecurityRules();
            int n2 = 0;
            while (n2 < securityRuleArray.length) {
                if (!securityRuleArray[n2].isSystemRule()) {
                    this.setEnabled(true);
                    return;
                }
                ++n2;
            }
            this.setEnabled(false);
        }
    }

    public class EditSecurityRuleAction
    extends FWAction {
        public EditSecurityRuleAction() {
            super(Localizer.getString("EditSecurityRule"), GUIRegistry.getInstance().getIconFactory().getIcon("Edit"), Localizer.getString("TTTEditSecurityRule"));
            this.refreshActionState();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (SecurityTab.this.securityTable.getSelectedRowCount() != 1) {
                return;
            }
            int n = SecurityTab.this.securityTable.getSelectedRow();
            int n2 = SecurityTab.this.securityTable.convertRowIndexToModel(n);
            IPAccessRule iPAccessRule = SecurityTab.this.securityMgr.getIPAccessRule(n2);
            if (iPAccessRule == null || iPAccessRule.isSystemRule()) {
                return;
            }
            SecurityRuleConfigDialog securityRuleConfigDialog = new SecurityRuleConfigDialog(iPAccessRule);
            securityRuleConfigDialog.show();
        }

        public void refreshActionState() {
            if (SecurityTab.this.securityTable.getSelectedRowCount() == 1) {
                int n = SecurityTab.this.securityTable.getSelectedRow();
                int n2 = SecurityTab.this.securityTable.convertRowIndexToModel(n);
                IPAccessRule iPAccessRule = SecurityTab.this.securityMgr.getIPAccessRule(n2);
                if (iPAccessRule.isSystemRule()) {
                    this.setEnabled(false);
                } else {
                    this.setEnabled(true);
                }
            } else {
                this.setEnabled(false);
            }
        }
    }

    public class NewSecurityRuleAction
    extends FWAction {
        public NewSecurityRuleAction() {
            super(Localizer.getString("NewSecurityRule"), GUIRegistry.getInstance().getIconFactory().getIcon("New"), Localizer.getString("TTTNewSecurityRule"));
            this.setEnabled(true);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SecurityRuleConfigDialog securityRuleConfigDialog = new SecurityRuleConfigDialog();
            securityRuleConfigDialog.show();
        }

        public void refreshActionState() {
        }
    }

    private class MouseHandler
    extends MouseAdapter
    implements MouseListener {
        private MouseHandler() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() == 2 && mouseEvent.getSource() == SecurityTab.this.securityTable) {
                SecurityTab.this.getTabAction(SecurityTab.EDIT_SECURITY_RULE_ACTION_KEY).actionPerformed(null);
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this.popupMenu((Component)mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY());
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            Component component;
            if (SwingUtilities.isRightMouseButton(mouseEvent) && (component = (Component)mouseEvent.getSource()) == SecurityTab.this.securityTable) {
                Point point = mouseEvent.getPoint();
                int n = SecurityTab.this.securityTable.rowAtPoint(point);
                int n2 = SecurityTab.this.securityTable.columnAtPoint(point);
                SecurityTab.this.securityTable.changeSelection(n, n2, false, false);
            }
        }

        private void popupMenu(Component component, int n, int n2) {
            if (component == SecurityTab.this.securityTable || component == SecurityTab.this.securityTableScrollPane) {
                SecurityTab.this.securityPopup.show(component, n, n2);
            }
        }
    }

    private class SelectionHandler
    implements ListSelectionListener {
        private SelectionHandler() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            SecurityTab.this.refreshTabActions();
        }
    }
}

