/*
 * Decompiled with CFR 0.152.
 */
package phex.host;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import phex.common.QueryRoutingTable;
import phex.common.ServiceManager;
import phex.common.ThreadPool;
import phex.common.bandwidth.BandwidthController;
import phex.connection.ConnectionClosedException;
import phex.connection.MessageQueue;
import phex.connection.NetworkManager;
import phex.host.HostAddress;
import phex.host.HostManager;
import phex.msg.Message;
import phex.statistic.MessageCountStatistic;
import phex.utils.FlexBuf;
import phex.utils.GnutellaInputStream;
import phex.utils.Logger;

public class Host {
    private static final Long ZERO_LONG = new Long(0L);
    private long QUERY_ROUTING_UPDATE_TIME = 300000L;
    private static final int STABLE_CONNECTION_TIME = 75000;
    public static final int DISCONNECT_POLICY_THRESHOLD = 10000;
    public static final int STATUS_HOST_NOT_CONNECTED = 0;
    public static final int STATUS_HOST_ERROR = 1;
    public static final int STATUS_HOST_CONNECTING = 2;
    public static final int STATUS_HOST_ACCEPTING = 3;
    public static final int STATUS_HOST_CONNECTED = 4;
    public static final int STATUS_HOST_DISCONNECTED = 5;
    public static final Short TYPE_OUTGOING = new Short(1);
    public static final Short TYPE_INCOMING = new Short(2);
    public static final Short TYPE_PUSH = new Short(3);
    public static final Short TYPE_LOCAL = new Short(4);
    public static final byte CONNECTION_NORMAL = 0;
    public static final byte CONNECTION_LEAF_UP = 1;
    public static final byte CONNECTION_UP_UP = 2;
    public static final byte CONNECTION_UP_LEAF = 3;
    private HostManager hostMgr;
    private BandwidthController bandwidthController;
    private HostAddress hostAddress;
    private Socket socket = null;
    private GnutellaInputStream inputStream = null;
    private OutputStream outputStream = null;
    private int status = 0;
    private String mLastStatusMsg = "";
    private long mStatusTime = 0L;
    private Short type;
    private boolean mHasWorker = false;
    private int mReceivedCount = 0;
    private int mSentCount = 0;
    private int mDropCount = 0;
    private int fileCount = -1;
    private int shareSize = -1;
    private String vendor;
    private boolean vendorChecked = false;
    private boolean isConnectionStable = false;
    private boolean isQueryRoutingSupported = false;
    private boolean isUPQueryRoutingSupported;
    private long lastQRTableSentTime;
    private QueryRoutingTable lastSentQRTable;
    private QueryRoutingTable lastReceivedQRTable;
    private byte connectionType = 0;
    private MessageQueue messageQueue;
    private long bytesSend;
    private FlexBuf flexBuffer = new FlexBuf();
    public static LocalHost LOCAL_HOST = new LocalHost();

    public Host() {
        this.hostMgr = HostManager.getInstance();
        this.bandwidthController = ServiceManager.getInstance().getNetworkBandwidthController();
        this.type = TYPE_OUTGOING;
    }

    public Host(HostAddress hostAddress) {
        this();
        this.hostAddress = hostAddress;
    }

    public Host(HostAddress hostAddress, Socket socket, GnutellaInputStream gnutellaInputStream) {
        this();
        this.hostAddress = hostAddress;
        this.socket = socket;
        this.inputStream = gnutellaInputStream;
        this.inputStream.setBandwidthController(this.bandwidthController);
    }

    public HostAddress getHostAddress() {
        return this.hostAddress;
    }

    public Socket getSocket() {
        return this.socket;
    }

    public void setSocket(Socket socket) {
        this.socket = socket;
        this.mReceivedCount = 0;
        this.mSentCount = 0;
        this.mDropCount = 0;
    }

    public GnutellaInputStream getInputStream() throws IOException {
        if (this.inputStream == null) {
            if (this.socket == null) {
                throw new ConnectionClosedException("Connection already closed");
            }
            this.inputStream = new GnutellaInputStream(this.socket.getInputStream(), this.bandwidthController);
        }
        return this.inputStream;
    }

    public OutputStream getOutputStream() throws IOException {
        if (this.outputStream == null) {
            if (this.socket == null) {
                throw new ConnectionClosedException("Connection already closed");
            }
            this.outputStream = new BufferedOutputStream(this.socket.getOutputStream());
        }
        return this.outputStream;
    }

    public void setVendor(String string) {
        this.vendor = string;
    }

    public String getVendor() {
        return this.vendor;
    }

    public int getStatus() {
        return this.status;
    }

    public String getStatusName() {
        switch (this.status) {
            case 0: {
                return "(Not connected)";
            }
            case 1: {
                return "Error.  " + this.mLastStatusMsg;
            }
            case 2: {
                if (this.mLastStatusMsg != null) {
                    return "Connecting...  " + this.mLastStatusMsg;
                }
                return "Connecting...  ";
            }
            case 3: {
                return "Accepting...  " + this.mLastStatusMsg;
            }
            case 4: {
                if (this.isSendQueueInRed()) {
                    return "Connected (deprecated, no broadcast forwarded)";
                }
                return "Connected";
            }
            case 5: {
                return "Disconnect";
            }
        }
        return "Unknown";
    }

    public void setStatus(int n) {
        this.setStatus(n, null, System.currentTimeMillis());
    }

    public void setStatus(int n, long l) {
        this.setStatus(n, null, l);
    }

    public void setStatus(int n, String string) {
        this.setStatus(n, string, System.currentTimeMillis());
    }

    public void setStatus(int n, String string, long l) {
        if (this.status == n && this.mLastStatusMsg != null && this.mLastStatusMsg.equals(string)) {
            return;
        }
        this.status = n;
        this.mLastStatusMsg = string;
        this.mStatusTime = l;
        this.hostMgr.fireNetworkHostChanged(this);
    }

    public void checkForStableConnection(long l) {
        if (this.isConnectionStable) {
            return;
        }
        if (this.status == 4 && this.getConnectionUpTime(l) > 75000L) {
            this.isConnectionStable = true;
            this.hostMgr.fireNetworkHostChanged(this);
        }
    }

    public boolean isConnectionStable() {
        return this.isConnectionStable;
    }

    public long getConnectionUpTime(long l) {
        if (this.status == 4) {
            return l - this.mStatusTime;
        }
        return 0L;
    }

    public Long getConnectionUpTimeObject(long l) {
        if (this.status == 4) {
            return new Long(l - this.mStatusTime);
        }
        return ZERO_LONG;
    }

    public boolean isErrorStatusExpired(long l) {
        return (this.status == 1 || this.status == 5) && l - this.mStatusTime > (long)ServiceManager.sCfg.hostErrorDisplayTime;
    }

    public Short getType() {
        return this.type;
    }

    public void setType(Short s) {
        this.type = s;
    }

    public boolean isIncomming() {
        return this.type.equals(TYPE_INCOMING);
    }

    public void incReceivedCount() {
        ++this.mReceivedCount;
    }

    public int getReceivedCount() {
        return this.mReceivedCount;
    }

    public void incSentCount() {
        ++this.mSentCount;
    }

    public int getSentCount() {
        return this.mSentCount;
    }

    public void incDropCount() {
        ++this.mDropCount;
    }

    public int getDropCount() {
        return this.mDropCount;
    }

    public int getFileCount() {
        return this.fileCount;
    }

    public void setFileCount(int n) {
        this.fileCount = n;
    }

    public int getTotalSize() {
        return this.shareSize;
    }

    public void setTotalFileSize(int n) {
        this.shareSize = n;
    }

    public boolean tooManyDropPackets() {
        if (this.mReceivedCount < 50 && this.getConnectionUpTime(System.currentTimeMillis()) < 60000L) {
            return false;
        }
        return this.mDropCount * 100 / (this.mReceivedCount + 1) > ServiceManager.sCfg.mDisconnectDropRatio;
    }

    public boolean dropPacketsInRed() {
        return this.mDropCount * 100 / (this.mReceivedCount + 1) > ServiceManager.sCfg.mDisconnectDropRatio * 3 / 4;
    }

    public boolean isConnected() {
        return this.socket != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        if (this.socket != null && this.status != 1) {
            this.setStatus(5);
        }
        if (this.inputStream != null) {
            try {
                this.inputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.inputStream = null;
        }
        if (this.outputStream != null) {
            try {
                this.outputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.outputStream = null;
        }
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.socket = null;
        }
        if (this.messageQueue != null) {
            MessageQueue messageQueue = this.messageQueue;
            synchronized (messageQueue) {
                this.messageQueue.notify();
            }
        }
    }

    public synchronized boolean isAcquiredByWorker() {
        if (this.mHasWorker) {
            return false;
        }
        this.mHasWorker = true;
        return true;
    }

    public synchronized void releaseFromWorker() {
        this.mHasWorker = false;
    }

    public int getSendQueueLength() {
        if (this.messageQueue == null) {
            return 0;
        }
        return this.messageQueue.getQueuedMessageCount();
    }

    public int getSendDropCount() {
        if (this.messageQueue == null) {
            return 0;
        }
        return this.messageQueue.getDropCount();
    }

    public boolean isSendQueueTooLong() {
        if (this.messageQueue == null) {
            return false;
        }
        return this.messageQueue.getQueuedMessageCount() >= ServiceManager.sCfg.mNetMaxSendQueue - 1;
    }

    public boolean isSendQueueInRed() {
        if (this.messageQueue == null) {
            return false;
        }
        return this.messageQueue.getQueuedMessageCount() >= ServiceManager.sCfg.mNetMaxSendQueue * 3 / 4;
    }

    public boolean isNoVendorDisconnectApplying() {
        if (!ServiceManager.sCfg.mDisconnectApplyPolicy || !ServiceManager.sCfg.isNoVendorNodeDisconnected) {
            return false;
        }
        if (this.vendorChecked) {
            return false;
        }
        if (this.status != 4) {
            return false;
        }
        String string = this.vendor;
        string = string == null ? "" : string.trim();
        if (string.length() == 0) {
            return true;
        }
        this.vendorChecked = true;
        return false;
    }

    public boolean isFreeloader(long l) {
        if (this.isUltrapeer()) {
            return false;
        }
        long l2 = this.getConnectionUpTime(l);
        if (l2 >= 10000L) {
            if (ServiceManager.sCfg.freeloaderFiles > 0 && this.fileCount < ServiceManager.sCfg.freeloaderFiles) {
                return true;
            }
            if (ServiceManager.sCfg.freeloaderShareSize > 0 && this.shareSize / 1024 < ServiceManager.sCfg.freeloaderShareSize) {
                return true;
            }
        }
        return false;
    }

    public boolean isLeafUltrapeerConnection() {
        return this.connectionType == 1;
    }

    public boolean isUltrapeer() {
        return this.connectionType == 1 || this.connectionType == 2;
    }

    public boolean isUltrapeerLeafConnection() {
        return this.connectionType == 3;
    }

    public void setConnectionType(byte by) {
        this.connectionType = by;
    }

    public void log(Logger.LogLevel logLevel, String string) {
        Logger.logMessage(logLevel, (short)16, "Host " + this.hostAddress.getHostName() + ":" + this.hostAddress.getPort() + " Vendor: " + this.vendor + " Message: " + string);
    }

    public String toString() {
        return '[' + this.hostAddress.getHostName() + ":" + this.hostAddress.getPort() + "; status:" + this.status + ']';
    }

    public void sendMessage(Message message) throws IOException {
        OutputStream outputStream = this.getOutputStream();
        int n = message.getSize();
        byte[] byArray = this.flexBuffer.getBuf(n);
        message.serialize(byArray, 0);
        int n2 = 0;
        int n3 = 0;
        while (n2 < n) {
            n3 = n - n2;
            if (n3 > 1024) {
                n3 = 1024;
            }
            outputStream.write(byArray, n2, n3);
            n2 += n3;
            this.bytesSend += (long)n3;
            this.bandwidthController.controlBandwidth(n3);
        }
        switch (message.getHeader().getPayload()) {
            case 0: {
                MessageCountStatistic.pingMsgOutCounter.increment(1);
                break;
            }
            case 1: {
                MessageCountStatistic.pongMsgOutCounter.increment(1);
                break;
            }
            case 64: {
                MessageCountStatistic.pushMsgOutCounter.increment(1);
                break;
            }
            case -128: {
                MessageCountStatistic.queryMsgOutCounter.increment(1);
                break;
            }
            case -127: {
                MessageCountStatistic.queryHitMsgOutCounter.increment(1);
                break;
            }
            default: {
                MessageCountStatistic.totalOutMsgCounter.increment(1);
            }
        }
    }

    public void flushOutputStream() throws IOException {
        this.getOutputStream().flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queueMessageToSend(Message message) {
        this.initMessageQueue();
        this.incSentCount();
        MessageQueue messageQueue = this.messageQueue;
        synchronized (messageQueue) {
            this.messageQueue.addMessage(message);
            this.messageQueue.notify();
        }
    }

    private void initMessageQueue() {
        if (this.messageQueue != null) {
            return;
        }
        this.messageQueue = new MessageQueue(this);
        SendEngine sendEngine = new SendEngine();
        ThreadPool.getInstance().addJob(sendEngine, "SendEngine-" + Integer.toHexString(sendEngine.hashCode()));
    }

    public boolean isQRTableUpdateRequired() {
        return System.currentTimeMillis() > this.lastQRTableSentTime + this.QUERY_ROUTING_UPDATE_TIME;
    }

    public QueryRoutingTable getLastSentRoutingTable() {
        return this.lastSentQRTable;
    }

    public void setLastSentRoutingTable(QueryRoutingTable queryRoutingTable) {
        this.lastSentQRTable = queryRoutingTable;
        this.lastQRTableSentTime = System.currentTimeMillis();
    }

    public QueryRoutingTable getLastReceivedRoutingTable() {
        return this.lastReceivedQRTable;
    }

    public void setLastReceivedRoutingTable(QueryRoutingTable queryRoutingTable) {
        this.lastReceivedQRTable = queryRoutingTable;
    }

    public boolean isQueryRoutingSupported() {
        return this.isQueryRoutingSupported;
    }

    public void setQueryRoutingSupported(boolean bl) {
        this.isQueryRoutingSupported = bl;
    }

    public boolean isUPQueryRoutingSupported() {
        return this.isUPQueryRoutingSupported;
    }

    public void setUPQueryRoutingSupported(boolean bl) {
        this.isUPQueryRoutingSupported = bl;
    }

    public static class LocalHost
    extends Host {
        LocalHost() {
            super(NetworkManager.getInstance().getLocalAddress());
        }

        public boolean isConnected() {
            return true;
        }

        public Short getType() {
            return TYPE_LOCAL;
        }
    }

    private class SendEngine
    implements Runnable {
        private SendEngine() {
        }

        public void run() {
            while (Host.this.isConnected()) {
                try {
                    this.waitForMessageQueueNotify();
                    Host.this.messageQueue.sendQueuedMessages();
                }
                catch (ConnectionClosedException connectionClosedException) {
                    return;
                }
                catch (IOException iOException) {
                    Host.this.setStatus(1, iOException.getMessage());
                    Host.this.hostMgr.disconnectHost(Host.this);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        private void waitForMessageQueueNotify() throws ConnectionClosedException {
            MessageQueue messageQueue = Host.this.messageQueue;
            // MONITORENTER : messageQueue
            while (Host.this.isConnected() && Host.this.messageQueue.getQueuedMessageCount() == 0) {
                try {
                    Host.this.messageQueue.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            // MONITOREXIT : messageQueue
            if (Host.this.isConnected()) return;
            throw new ConnectionClosedException("Connection already closed.");
        }
    }
}

