/*
 * Decompiled with CFR 0.152.
 */
package phex.http;

import phex.http.GnutellaRequest;
import phex.http.HTTPHeader;
import phex.http.HTTPHeaders;

public class HTTPRequest {
    public static final String GET_REQUEST = "GET";
    public static final String HTTP_11 = "HTTP/1.1";
    protected static final String CRLF = "\r\n";
    private static final char SP = ' ';
    private String requestMethod;
    private String requestURI;
    private String httpVersion;
    private GnutellaRequest gnutellaRequest;
    private boolean isGnutellaRequestParsed;
    private int contentLength;
    private String hostName;
    private int hostPort;
    private HTTPHeaders httpHeaders;

    public HTTPRequest(String string, String string2, boolean bl) {
        this(string, string2, HTTP_11, bl);
    }

    public HTTPRequest(String string, String string2, String string3, boolean bl) {
        this.requestMethod = string;
        this.requestURI = string2;
        this.httpVersion = string3;
        this.httpHeaders = bl ? HTTPHeaders.createDefaultRequestHeaders() : new HTTPHeaders(true);
        this.isGnutellaRequestParsed = false;
    }

    public void setContentLength(int n, boolean bl) {
        this.contentLength = n;
        if (bl) {
            this.httpHeaders.addHeader(new HTTPHeader("Content-Length", String.valueOf(n)));
        }
    }

    public void setHost(String string, int n, boolean bl) {
        this.hostName = string;
        this.hostPort = n;
        if (bl) {
            StringBuffer stringBuffer = new StringBuffer(this.hostName.length() + 5);
            stringBuffer.append(this.hostName);
            if (this.hostPort > 0) {
                stringBuffer.append(':');
                stringBuffer.append(String.valueOf(this.hostPort));
            }
            this.httpHeaders.addHeader(new HTTPHeader("Host", stringBuffer.toString()));
        }
    }

    public void addHeader(HTTPHeader hTTPHeader) {
        this.httpHeaders.addHeader(hTTPHeader);
    }

    public void addHeaders(HTTPHeader[] hTTPHeaderArray) {
        this.httpHeaders.addHeaders(hTTPHeaderArray);
    }

    public HTTPHeader getHeader(String string) {
        return this.httpHeaders.getHeader(string);
    }

    public HTTPHeader[] getHeaders(String string) {
        return this.httpHeaders.getHeaders(string);
    }

    public String getRequestMethod() {
        return this.requestMethod;
    }

    public String getRequestURI() {
        return this.requestURI;
    }

    public String getHTTPVersion() {
        return this.httpVersion;
    }

    public GnutellaRequest getGnutellaRequest() {
        if (!this.isGnutellaRequestParsed) {
            this.gnutellaRequest = GnutellaRequest.parseGnutellaRequest(this.requestURI);
            this.isGnutellaRequestParsed = true;
        }
        return this.gnutellaRequest;
    }

    public boolean isGnutellaRequest() {
        if (!this.isGnutellaRequestParsed) {
            this.gnutellaRequest = GnutellaRequest.parseGnutellaRequest(this.requestURI);
            this.isGnutellaRequestParsed = true;
        }
        return this.gnutellaRequest != null;
    }

    public String buildHTTPRequestString() {
        return this.requestMethod + ' ' + this.requestURI + ' ' + this.httpVersion + CRLF + this.httpHeaders.buildHTTPHeaderString() + CRLF;
    }
}

