/*
 * Decompiled with CFR 0.152.
 */
package phex.msg;

import java.io.IOException;
import phex.msg.Message;
import phex.msg.MsgHeader;
import phex.utils.HexConverter;
import phex.utils.Logger;

public class MsgPing
extends Message {
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private MsgHeader header;
    private byte[] body;

    public MsgPing() {
        this.header = new MsgHeader();
        this.header.setPayloadType((byte)0);
        this.header.setDataLen(0);
        this.body = EMPTY_BYTE_ARRAY;
    }

    public MsgPing(MsgHeader msgHeader, byte[] byArray) {
        this.header = msgHeader;
        this.header.setPayloadType((byte)0);
        this.body = byArray;
        this.header.setDataLen(this.body.length);
    }

    public MsgHeader getHeader() {
        return this.header;
    }

    public int getSize() {
        return this.header.getSize() + this.header.getDataLen();
    }

    public int serialize(byte[] byArray, int n) throws IOException {
        n = this.header.serialize(byArray, n);
        try {
            System.arraycopy(this.body, 0, byArray, n, this.header.getDataLen());
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            Logger.logError((short)16, this.body.length + "  " + n + "  " + this.header.getDataLen() + "  " + "\n" + new String(this.body) + "\n" + new String(byArray) + "\n----");
            Logger.logError(arrayIndexOutOfBoundsException);
        }
        return n;
    }

    public String toString() {
        return "[" + this.header + new String(this.body) + HexConverter.toHexString(this.body) + "]";
    }

    public String getDebugString() {
        return "Ping[ HEX=[" + HexConverter.toHexString(this.body) + "] ]";
    }
}

