/*
 * Decompiled with CFR 0.152.
 */
package phex.msg;

import java.io.IOException;
import phex.host.HostAddress;
import phex.msg.GUID;
import phex.msg.Message;
import phex.msg.MsgHeader;
import phex.utils.IOUtil;
import phex.utils.Logger;

public class MsgPushRequest
extends Message {
    private byte[] body;
    private MsgHeader header;
    private GUID clientGUID;
    private long fileIndex;
    private HostAddress requestAddress;

    public MsgPushRequest(MsgHeader msgHeader, byte[] byArray) {
        this.header = msgHeader;
        this.header.setPayloadType((byte)64);
        this.body = byArray;
        this.header.setDataLen(this.body.length);
        this.parseBody();
    }

    public MsgPushRequest(GUID gUID, long l, HostAddress hostAddress) throws IOException {
        this.header = new MsgHeader();
        this.header.setPayloadType((byte)64);
        this.clientGUID = gUID;
        this.fileIndex = l;
        this.requestAddress = hostAddress;
        this.buildBody();
        this.header.setDataLen(this.body.length);
    }

    public MsgHeader getHeader() {
        return this.header;
    }

    public GUID getClientGUID() {
        return this.clientGUID;
    }

    public long getFileIndex() {
        return this.fileIndex;
    }

    public HostAddress getRequestAddress() {
        return this.requestAddress;
    }

    public int getSize() {
        return this.header.getSize() + this.header.getDataLen();
    }

    public int serialize(byte[] byArray, int n) throws IOException {
        n = this.header.serialize(byArray, n);
        try {
            System.arraycopy(this.body, 0, byArray, n, this.header.getDataLen());
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            Logger.logError((short)16, this.body.length + "  " + n + "  " + this.header.getDataLen() + "  " + "\n" + new String(this.body) + "\n" + new String(byArray) + "\n----");
            Logger.logError(arrayIndexOutOfBoundsException);
        }
        return n + this.header.getDataLen();
    }

    public String toString() {
        return "[" + this.header + " " + "ClientGUID=" + this.clientGUID + ", " + "FileIndex=" + this.fileIndex + ", " + "RequestAddress=" + this.requestAddress + ", " + "]";
    }

    private void buildBody() throws IOException {
        this.body = new byte[26];
        this.clientGUID.serialize(this.body, 0);
        IOUtil.serializeIntLE((int)this.fileIndex, this.body, 16);
        System.arraycopy(this.requestAddress.getHostIP(), 0, this.body, 20, 4);
        IOUtil.serializeShortLE((short)this.requestAddress.getPort(), this.body, 24);
    }

    private void parseBody() {
        if (this.clientGUID == null) {
            this.clientGUID = new GUID();
        }
        this.clientGUID.deserialize(this.body, 0);
        this.fileIndex = IOUtil.unsignedInt2Long(IOUtil.deserializeIntLE(this.body, 16));
        byte[] byArray = new byte[]{this.body[20], this.body[21], this.body[22], this.body[23]};
        short s = IOUtil.deserializeShortLE(this.body, 24);
        if (this.requestAddress == null) {
            this.requestAddress = new HostAddress(byArray, (int)s);
        } else {
            this.requestAddress.updateAddress(byArray, (int)s);
        }
    }
}

