/*
 * Decompiled with CFR 0.152.
 */
package phex.msg;

import phex.msg.MsgHeader;
import phex.msg.RouteTableUpdateMsg;
import phex.utils.IOUtil;

public class QRResetTableMsg
extends RouteTableUpdateMsg {
    private static final int MESSAGE_LENGTH = 6;
    private int tableSize;
    private byte infinityByte;

    public QRResetTableMsg(int n, byte by) {
        super((byte)0, 6);
        this.tableSize = n;
        this.infinityByte = by;
    }

    public QRResetTableMsg(MsgHeader msgHeader, byte[] byArray) {
        super((byte)0, msgHeader);
        msgHeader.setDataLen(byArray.length);
        this.tableSize = IOUtil.deserializeIntLE(byArray, 1);
        this.infinityByte = byArray[5];
    }

    public int getTableSize() {
        return this.tableSize;
    }

    public int serialize(byte[] byArray, int n) {
        n = super.serialize(byArray, n);
        n = IOUtil.serializeIntLE(this.tableSize, byArray, n);
        byArray[n++] = this.infinityByte;
        return n;
    }
}

