/*
 * Decompiled with CFR 0.152.
 */
package phex.query;

import phex.common.Manager;
import phex.query.BackgroundSearchContainer;
import phex.query.QueryHistoryMonitor;
import phex.query.ResearchService;
import phex.query.ResearchServiceConfig;
import phex.query.SearchContainer;
import phex.query.SearchFilterContainer;

public class QueryManager
implements Manager {
    private QueryHistoryMonitor queryMonitor;
    private SearchContainer searchContainer;
    private BackgroundSearchContainer backgroundSearchContainer;
    private ResearchService researchService;
    private SearchFilterContainer searchFilterContainer;
    private static QueryManager instance;

    public static QueryManager getInstance() {
        if (instance == null) {
            instance = new QueryManager();
        }
        return instance;
    }

    public boolean initialize() {
        this.queryMonitor = new QueryHistoryMonitor();
        this.searchContainer = new SearchContainer();
        this.backgroundSearchContainer = new BackgroundSearchContainer();
        this.researchService = new ResearchService(new ResearchServiceConfig());
        this.searchFilterContainer = new SearchFilterContainer();
        return true;
    }

    public boolean onPostInitialization() {
        return true;
    }

    public void shutdown() {
        this.queryMonitor.shutdown();
    }

    public QueryHistoryMonitor getQueryHistoryMonitor() {
        return this.queryMonitor;
    }

    public SearchContainer getSearchContainer() {
        return this.searchContainer;
    }

    public BackgroundSearchContainer getBackgroundSearchContainer() {
        return this.backgroundSearchContainer;
    }

    public ResearchService getResearchService() {
        return this.researchService;
    }

    public void stopExpiredSearches() {
        long l = System.currentTimeMillis();
        this.searchContainer.stopExpiredSearches(l);
        this.backgroundSearchContainer.stopExpiredSearches(l);
    }

    public SearchFilterContainer getSearchFilterContainer() {
        return this.searchFilterContainer;
    }
}

