/*
 * Decompiled with CFR 0.152.
 */
package phex.security;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.xml.bind.JAXBException;
import phex.common.Environment;
import phex.common.ExpiryDate;
import phex.common.Manager;
import phex.common.ServiceManager;
import phex.event.AsynchronousDispatcher;
import phex.event.SecurityRulesChangeListener;
import phex.host.HostAddress;
import phex.security.IPAccessRule;
import phex.security.SecurityRule;
import phex.utils.Localizer;
import phex.utils.Logger;
import phex.utils.VersionUtils;
import phex.xml.ObjectFactory;
import phex.xml.PhexElement;
import phex.xml.XJBIPAccessRule;
import phex.xml.XJBPhex;
import phex.xml.XJBSecurity;
import phex.xml.XJBSecurityRule;
import phex.xml.XMLBuilder;

public class PhexSecurityManager
implements Manager {
    public static final byte ACCESS_GRANTED = 1;
    public static final byte ACCESS_DENIED = 2;
    public static final byte ACCESS_STRONGLY_DENIED = 3;
    private static PhexSecurityManager instance;
    private ArrayList ipAccessRuleList;
    private ArrayList listenerList = new ArrayList(2);

    public PhexSecurityManager() {
        this.ipAccessRuleList = new ArrayList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getIPAccessRuleCount() {
        ArrayList arrayList = this.ipAccessRuleList;
        synchronized (arrayList) {
            return this.ipAccessRuleList.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IPAccessRule getIPAccessRule(int n) {
        ArrayList arrayList = this.ipAccessRuleList;
        synchronized (arrayList) {
            if (n < 0 || n >= this.ipAccessRuleList.size()) {
                return null;
            }
            return (IPAccessRule)this.ipAccessRuleList.get(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IPAccessRule[] getIPAccessRulesAt(int[] nArray) {
        ArrayList arrayList = this.ipAccessRuleList;
        synchronized (arrayList) {
            int n = nArray.length;
            IPAccessRule[] iPAccessRuleArray = new IPAccessRule[n];
            int n2 = this.ipAccessRuleList.size();
            int n3 = 0;
            while (n3 < n) {
                iPAccessRuleArray[n3] = nArray[n3] < 0 || nArray[n3] >= n2 ? null : (IPAccessRule)this.ipAccessRuleList.get(nArray[n3]);
                ++n3;
            }
            return iPAccessRuleArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IPAccessRule createIPAccessRule(String string, boolean bl, byte by, byte[] byArray, byte[] byArray2, boolean bl2, ExpiryDate expiryDate, boolean bl3) {
        IPAccessRule iPAccessRule = new IPAccessRule(string, bl, by, byArray, byArray2);
        iPAccessRule.setDisabled(bl2);
        iPAccessRule.setExpiryDate(expiryDate);
        iPAccessRule.setDeleteOnExpiry(bl3);
        ArrayList arrayList = this.ipAccessRuleList;
        synchronized (arrayList) {
            int n = this.ipAccessRuleList.size();
            this.ipAccessRuleList.add(n, iPAccessRule);
            this.fireSecurityRuleAdded(n);
        }
        return iPAccessRule;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSecurityRule(SecurityRule securityRule) {
        ArrayList arrayList = this.ipAccessRuleList;
        synchronized (arrayList) {
            int n = this.ipAccessRuleList.indexOf(securityRule);
            if (n != -1) {
                this.ipAccessRuleList.remove(n);
                this.fireSecurityRuleRemoved(n);
            }
        }
    }

    public byte controlHostAddressAccess(HostAddress hostAddress) throws UnknownHostException {
        byte[] byArray = hostAddress.getHostIP();
        return this.controlHostIPAccess(byArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte controlHostIPAccess(byte[] byArray) {
        ArrayList arrayList = this.ipAccessRuleList;
        synchronized (arrayList) {
            Iterator iterator = this.ipAccessRuleList.iterator();
            while (iterator.hasNext()) {
                IPAccessRule iPAccessRule = (IPAccessRule)iterator.next();
                if (iPAccessRule.isDisabled() || iPAccessRule.isHostIPAllowed(byArray)) continue;
                if (iPAccessRule.isStrongFilter()) {
                    return 3;
                }
                return 2;
            }
        }
        return 1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void loadHostileHostList(XJBSecurity xJBSecurity) {
        try {
            Logger.logMessage(Logger.FINE, (short)16, "Load hostile hosts file.");
            InputStream inputStream = ClassLoader.getSystemResourceAsStream("phex/resources/hostilehosts.cfg");
            if (inputStream == null) {
                Logger.logMessage(Logger.FINE, (short)16, "Hostile hosts file not found.");
                return;
            }
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            while (true) {
                Object object;
                int n;
                byte[] byArray;
                byte[] byArray2;
                String string;
                if ((string = bufferedReader.readLine()) == null) {
                    bufferedReader.close();
                    return;
                }
                if (string.startsWith("#")) continue;
                int n2 = string.indexOf(47);
                if (n2 == -1) {
                    byArray2 = HostAddress.parseIP(string);
                    byArray = null;
                    n = 1;
                } else {
                    object = string.substring(0, n2).trim();
                    String string2 = string.substring(n2 + 1).trim();
                    byArray2 = HostAddress.parseIP((String)object);
                    byArray = HostAddress.parseIP(string2);
                    n = 2;
                }
                IPAccessRule iPAccessRule = new IPAccessRule("System rule.", true, (byte)n, byArray2, byArray);
                iPAccessRule.setSystemRule(true);
                iPAccessRule.setStrongFilter(true);
                iPAccessRule.setDisabled(false);
                object = this.findSystemXJBRule(xJBSecurity, byArray2, byArray);
                if (object != null) {
                    iPAccessRule.setTriggerCount(object.getTriggerCount());
                }
                this.ipAccessRuleList.add(iPAccessRule);
            }
        }
        catch (IOException iOException) {
            Logger.logWarning(iOException);
            return;
        }
    }

    private XJBSecurityRule findSystemXJBRule(XJBSecurity xJBSecurity, byte[] byArray, byte[] byArray2) {
        List list = xJBSecurity.getIpAccessRuleList();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            XJBIPAccessRule xJBIPAccessRule = (XJBIPAccessRule)iterator.next();
            if (!xJBIPAccessRule.isSystemRule() || !Arrays.equals(xJBIPAccessRule.getIp(), byArray) || byArray2 == null || !Arrays.equals(xJBIPAccessRule.getCompareIP(), byArray2)) continue;
            return xJBIPAccessRule;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadSecurityRuleList() {
        Logger.logMessage(Logger.CONFIG, (short)2, "Loading security rule list...");
        File file = Environment.getInstance().getPhexConfigFile("security.xml");
        try {
            XJBSecurity xJBSecurity;
            XJBPhex xJBPhex = XMLBuilder.loadXJBPhexFromFile(file);
            if (xJBPhex == null) {
                Logger.logMessage(Logger.SEVERE, (short)255, "Error loading security rule list.");
                xJBPhex = ObjectFactory.createXJBPhex();
            }
            if ((xJBSecurity = xJBPhex.getSecurity()) == null) {
                Logger.logMessage(Logger.FINE, (short)255, "No security definition found.");
                xJBSecurity = ObjectFactory.createXJBSecurity();
            }
            List list = xJBSecurity.getIpAccessRuleList();
            ArrayList arrayList = this.ipAccessRuleList;
            synchronized (arrayList) {
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    XJBIPAccessRule xJBIPAccessRule = (XJBIPAccessRule)iterator.next();
                    if (xJBIPAccessRule.isSystemRule()) continue;
                    IPAccessRule iPAccessRule = new IPAccessRule(xJBIPAccessRule);
                    this.ipAccessRuleList.add(iPAccessRule);
                }
                this.loadHostileHostList(xJBSecurity);
            }
        }
        catch (JAXBException jAXBException) {
            Logger.logError(jAXBException);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveSecurityRuleList() {
        Logger.logMessage(Logger.CONFIG, (short)255, "Saving security rule list...");
        try {
            Object object;
            PhexElement phexElement = ObjectFactory.createPhexElement();
            XJBSecurity xJBSecurity = ObjectFactory.createXJBSecurity();
            phexElement.setSecurity(xJBSecurity);
            phexElement.setPhexVersion(VersionUtils.getProgramVersion());
            List list = xJBSecurity.getIpAccessRuleList();
            ArrayList arrayList = this.ipAccessRuleList;
            synchronized (arrayList) {
                object = this.ipAccessRuleList.iterator();
                while (object.hasNext()) {
                    IPAccessRule iPAccessRule = (IPAccessRule)object.next();
                    if (iPAccessRule.getExpiryDate().isExpiringEndOfSession() && iPAccessRule.isDeletedOnExpiry() && !iPAccessRule.isSystemRule()) continue;
                    XJBSecurityRule xJBSecurityRule = iPAccessRule.createXJBSecurityRule();
                    list.add(xJBSecurityRule);
                }
            }
            object = Environment.getInstance().getPhexConfigFile("security.xml");
            XMLBuilder.saveToFile((File)object, phexElement);
        }
        catch (JAXBException jAXBException) {
            Logger.logError(jAXBException);
        }
    }

    private void updateOldIpFilters() {
        int n = 0;
        Vector vector = ServiceManager.sCfg.mNetInvalidHosts;
        n += vector.size();
        Iterator iterator = vector.iterator();
        this.updateOldIpFilterIterator(iterator, "Invalid Host");
        ServiceManager.sCfg.mNetInvalidHosts.clear();
        ArrayList arrayList = ServiceManager.sCfg.mNetIgnoredHosts;
        n += arrayList.size();
        iterator = arrayList.iterator();
        this.updateOldIpFilterIterator(iterator, "Ignored Host");
        ServiceManager.sCfg.mNetIgnoredHosts.clear();
        vector = ServiceManager.sCfg.mFilteredSearchHosts;
        iterator = vector.iterator();
        this.updateOldIpFilterIterator(iterator, "Filtered Host");
        ServiceManager.sCfg.mFilteredSearchHosts.clear();
        if ((n += vector.size()) > 0) {
            this.saveSecurityRuleList();
            ServiceManager.sCfg.save();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateOldIpFilterIterator(Iterator iterator, String string) {
        while (iterator.hasNext()) {
            int n;
            boolean bl = false;
            String[] stringArray = (String[])iterator.next();
            byte[] byArray = new byte[4];
            byte[] byArray2 = null;
            int n2 = 0;
            while (n2 < 4) {
                if (stringArray[n2].equals("*")) {
                    if (!bl) {
                        byArray2 = new byte[4];
                        n = 0;
                        while (n < n2) {
                            byArray2[n] = byArray[n];
                            ++n;
                        }
                        bl = true;
                    }
                    byArray[n2] = 0;
                    byArray2[n2] = -1;
                } else {
                    byArray[n2] = (byte)Integer.parseInt(stringArray[n2]);
                    if (bl) {
                        byArray2[n2] = byArray[n2];
                    }
                }
                ++n2;
            }
            n = bl ? 3 : 1;
            String string2 = Localizer.getFormatedString("ConvertedRule", new String[]{string});
            IPAccessRule iPAccessRule = new IPAccessRule(string2, true, (byte)n, byArray, byArray2);
            ArrayList arrayList = this.ipAccessRuleList;
            synchronized (arrayList) {
                this.ipAccessRuleList.add(iPAccessRule);
            }
        }
    }

    public static PhexSecurityManager getInstance() {
        if (instance == null) {
            instance = new PhexSecurityManager();
        }
        return instance;
    }

    public boolean initialize() {
        return true;
    }

    public boolean onPostInitialization() {
        this.loadSecurityRuleList();
        this.updateOldIpFilters();
        return true;
    }

    public void shutdown() {
        this.saveSecurityRuleList();
    }

    public void addUploadFilesChangeListener(SecurityRulesChangeListener securityRulesChangeListener) {
        this.listenerList.add(securityRulesChangeListener);
    }

    public void removeUploadFilesChangeListener(SecurityRulesChangeListener securityRulesChangeListener) {
        this.listenerList.remove(securityRulesChangeListener);
    }

    private void fireSecurityRuleChanged(final int n) {
        AsynchronousDispatcher.invokeLater(new Runnable(){

            public void run() {
                Object[] objectArray = PhexSecurityManager.this.listenerList.toArray();
                int n2 = objectArray.length - 1;
                while (n2 >= 0) {
                    SecurityRulesChangeListener securityRulesChangeListener = (SecurityRulesChangeListener)objectArray[n2];
                    securityRulesChangeListener.securityRuleChanged(n);
                    --n2;
                }
            }
        });
    }

    private void fireSecurityRuleAdded(final int n) {
        AsynchronousDispatcher.invokeLater(new Runnable(){

            public void run() {
                Object[] objectArray = PhexSecurityManager.this.listenerList.toArray();
                int n2 = objectArray.length - 1;
                while (n2 >= 0) {
                    SecurityRulesChangeListener securityRulesChangeListener = (SecurityRulesChangeListener)objectArray[n2];
                    securityRulesChangeListener.securityRuleAdded(n);
                    --n2;
                }
            }
        });
    }

    private void fireSecurityRuleRemoved(final int n) {
        AsynchronousDispatcher.invokeLater(new Runnable(){

            public void run() {
                Object[] objectArray = PhexSecurityManager.this.listenerList.toArray();
                int n2 = objectArray.length - 1;
                while (n2 >= 0) {
                    SecurityRulesChangeListener securityRulesChangeListener = (SecurityRulesChangeListener)objectArray[n2];
                    securityRulesChangeListener.securityRuleRemoved(n);
                    --n2;
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireSecurityRuleChanged(SecurityRule securityRule) {
        ArrayList arrayList = this.ipAccessRuleList;
        synchronized (arrayList) {
            int n = this.ipAccessRuleList.indexOf(securityRule);
            if (n >= 0) {
                this.fireSecurityRuleChanged(n);
            }
        }
    }
}

