/*
 * Decompiled with CFR 0.152.
 */
package phex.utils;

import java.io.IOException;
import java.io.InputStream;
import phex.common.bandwidth.BandwidthController;

public class GnutellaInputStream
extends InputStream {
    private static final char CR = '\r';
    private static final char LF = '\n';
    private int READ_BUFFER_LENGTH = 2048;
    private int LINE_BUFFER_LENGTH = 64;
    private byte[] buffer;
    private int position;
    private int count;
    private InputStream inStream;
    private BandwidthController bandwidthController;

    public GnutellaInputStream(InputStream inputStream) {
        this(inputStream, null);
    }

    public GnutellaInputStream(InputStream inputStream, BandwidthController bandwidthController) {
        this.inStream = inputStream;
        this.bandwidthController = bandwidthController;
        this.buffer = new byte[this.READ_BUFFER_LENGTH];
    }

    public void setBandwidthController(BandwidthController bandwidthController) {
        this.bandwidthController = bandwidthController;
    }

    public String readLine() throws IOException {
        if (this.inStream == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(this.LINE_BUFFER_LENGTH);
        int n = 0;
        while (true) {
            int n2 = this.read();
            ++n;
            if (n2 < 0) {
                if (stringBuffer.length() != 0) break;
                return null;
            }
            if (n2 == 13) continue;
            if (n2 == 10) break;
            stringBuffer.append((char)n2);
        }
        if (this.bandwidthController != null) {
            this.bandwidthController.controlBandwidth(n);
        }
        return stringBuffer.toString();
    }

    /*
     * Unable to fully structure code
     */
    public int read(byte[] var1_1, int var2_2, int var3_3) throws IOException {
        if (this.inStream == null) {
            return -1;
        }
        if ((var2_2 | var3_3 | var2_2 + var3_3 | var1_1.length - (var2_2 + var3_3)) < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (var3_3 == 0) {
            return 0;
        }
        var4_4 = this.readInternal(var1_1, var2_2, var3_3);
        if (var4_4 > 0) ** GOTO lbl12
        return var4_4;
        while ((var5_5 = this.readInternal(var1_1, var2_2 + var4_4, var3_3 - var4_4)) > 0) {
            var4_4 += var5_5;
lbl12:
            // 2 sources

            if (var4_4 < var3_3 && this.inStream.available() > 0) continue;
        }
        if (this.bandwidthController != null) {
            this.bandwidthController.controlBandwidth(var4_4);
        }
        return var4_4;
    }

    private int readInternal(byte[] byArray, int n, int n2) throws IOException {
        int n3 = this.count - this.position;
        if (n3 <= 0) {
            if (n2 >= this.buffer.length) {
                return this.inStream.read(byArray, n, n2);
            }
            this.fill();
            n3 = this.count - this.position;
            if (n3 <= 0) {
                return -1;
            }
        }
        int n4 = n3 < n2 ? n3 : n2;
        System.arraycopy(this.buffer, this.position, byArray, n, n4);
        this.position += n4;
        return n4;
    }

    public int peek() throws IOException {
        if (this.position >= this.count) {
            this.fill();
            if (this.position >= this.count) {
                return -1;
            }
        }
        return this.buffer[this.position] & 0xFF;
    }

    public int read() throws IOException {
        if (this.position >= this.count) {
            this.fill();
            if (this.position >= this.count) {
                return -1;
            }
        }
        return this.buffer[this.position++] & 0xFF;
    }

    public synchronized int available() throws IOException {
        return this.count - this.position + this.inStream.available();
    }

    public void close() {
        if (this.inStream == null) {
            return;
        }
        try {
            this.inStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.inStream = null;
        this.buffer = null;
    }

    protected void fill() throws IOException {
        this.position = 0;
        this.count = 0;
        int n = this.inStream.read(this.buffer, 0, this.buffer.length);
        if (n > 0) {
            this.count = n;
        }
    }
}

