/*
 * Decompiled with CFR 0.152.
 */
package redlight.client;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JPopupMenu;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.plaf.basic.BasicArrowButton;
import redlight.client.BookmarkInterface;
import redlight.client.BookmarkMenuItem;
import redlight.client.ConnectionInterface;
import redlight.client.Error;
import redlight.client.Machine;
import redlight.client.Main;
import redlight.client.Parent;
import redlight.hotline.HLBookmarkFile;
import redlight.utils.FilenameUtils;

public class ConnectInterface
implements ActionListener,
WindowListener {
    Parent parent;
    Machine rlm;
    Container contentPane;
    JTextField server;
    JTextField port;
    JTextField login;
    JTextField password;
    JButton connect;
    JButton save;
    JFrame f;
    boolean destroy_on_close;
    String serverName;
    JPopupMenu popupMenu;
    BasicArrowButton arrowButton;

    public ConnectInterface(Parent p) {
        this(p, "", "5500", "guest", "", false);
    }

    public ConnectInterface(Parent prnt, String the_server, String the_port, String the_login, String the_password, boolean destroy) {
        this(prnt, the_server, the_port, the_login, the_password, null, destroy);
    }

    public ConnectInterface(Parent prnt, String the_server, String the_port, String the_login, String the_password, String the_servername, boolean destroy) {
        this.parent = prnt;
        this.destroy_on_close = destroy;
        this.serverName = the_servername;
        Font guiFont = (Font)Main.rlo.getProperty("Font.gui");
        this.f = new JFrame("Connect to " + (this.serverName == null ? "..." : this.serverName));
        this.contentPane = this.f.getContentPane();
        JPanel p = new JPanel();
        JPanel buttons = new JPanel();
        this.popupMenu = new JPopupMenu();
        this.login = new JTextField(the_login);
        this.password = new JPasswordField(the_password);
        this.port = new JTextField(the_port);
        this.server = new JTextField(the_server);
        this.connect = new JButton("Connect");
        this.save = new JButton("Save ...");
        JTextArea helpText = new JTextArea("Enter the name of the server that you want to connect to, and optionally the port and user credentials:", 3, 20);
        JLabel l1 = new JLabel("Server:");
        JLabel l2 = new JLabel("Port:");
        JLabel l3 = new JLabel("Login:");
        JLabel l4 = new JLabel("Password:");
        this.arrowButton = new BasicArrowButton(5);
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        this.connect.addActionListener(this);
        this.save.addActionListener(this);
        this.arrowButton.addActionListener(this);
        TitledBorder lineBorder = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "New connection");
        EmptyBorder emptyBorder = new EmptyBorder((Insets)Main.rlo.getProperty("BorderInsets"));
        CompoundBorder compound1 = BorderFactory.createCompoundBorder(lineBorder, emptyBorder);
        p.setBorder(compound1);
        p.setLayout(new GridBagLayout());
        buttons.setLayout(new FlowLayout(2));
        this.contentPane.setLayout(new GridBagLayout());
        helpText.setForeground(Color.black);
        helpText.setWrapStyleWord(true);
        helpText.setLineWrap(true);
        helpText.setOpaque(false);
        helpText.setEditable(false);
        this.arrowButton.setActionCommand("ShowBookmarks");
        this.arrowButton.setMnemonic('B');
        this.arrowButton.setToolTipText("Show bookmarks");
        this.save.setMnemonic('S');
        this.save.setToolTipText("Save bookmark as ...");
        this.connect.setMnemonic('C');
        this.connect.setToolTipText("Open a connection.");
        gbc.fill = 2;
        gbc.anchor = 12;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.gridy = 0;
        gbc.gridx = 0;
        gbc.gridwidth = 2;
        Insets oldInsets = gbc.insets;
        gbc.insets = new Insets(0, 0, 8, 0);
        p.add((Component)helpText, gbc);
        gbc.insets = oldInsets;
        gbc.gridwidth = 1;
        ++gbc.gridy;
        gbc.ipadx = 4;
        gbc.ipady = 4;
        p.add((Component)l1, gbc);
        ++gbc.gridy;
        p.add((Component)l2, gbc);
        ++gbc.gridy;
        p.add((Component)l3, gbc);
        ++gbc.gridy;
        p.add((Component)l4, gbc);
        gbc.weightx = 0.8;
        gbc.gridx = 1;
        gbc.gridy = 1;
        p.add((Component)this.server, gbc);
        ++gbc.gridy;
        p.add((Component)this.port, gbc);
        ++gbc.gridy;
        p.add((Component)this.login, gbc);
        ++gbc.gridy;
        p.add((Component)this.password, gbc);
        gbc.ipadx = 0;
        gbc.ipady = 0;
        gbc.gridx = 2;
        gbc.gridy = 1;
        gbc.weightx = 0.0;
        p.add((Component)this.arrowButton, gbc);
        buttons.add(this.save);
        buttons.add(this.connect);
        gbc.weightx = 1.0;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 2;
        gbc.weighty = 0.0;
        gbc.insets = (Insets)Main.rlo.getProperty("BorderInsets");
        this.contentPane.add((Component)p, gbc);
        gbc.weighty = 1.0;
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.anchor = 16;
        gbc.insets = new Insets(0, 0, 0, 8);
        this.contentPane.add((Component)buttons, gbc);
        p.registerKeyboardAction(this, "Cancel", KeyStroke.getKeyStroke(27, 0), 2);
        SwingUtilities.getRootPane(this.f).setDefaultButton(this.connect);
        this.f.pack();
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension w = this.f.getSize();
        this.f.setLocation(d.width / 2 - w.width / 2, d.height / 2 - w.height / 2);
        this.f.addWindowListener(this);
        this.show(false);
    }

    public void doConnect() {
        this.f.setVisible(false);
        if (this.destroy_on_close) {
            this.f.dispose();
        }
        new ConnectionInterface(this.server.getText(), new Integer(this.port.getText()), this.login.getText(), this.password.getText(), this.serverName);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("Connect")) {
            this.doConnect();
        } else if (e.getActionCommand().equals("Cancel")) {
            if (this.popupMenu.isVisible()) {
                this.popupMenu.setVisible(false);
                this.popupMenu.removeAll();
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        ConnectInterface.this.server.requestFocus();
                    }
                });
            } else {
                this.windowClosing(null);
            }
        } else if (e.getActionCommand().equals("ShowBookmarks")) {
            if (!this.popupMenu.isVisible()) {
                this.popupMenu.removeAll();
                BookmarkInterface.populateContainerWithBookmarks(this.popupMenu, this);
                this.popupMenu.show(this.contentPane, this.arrowButton.getX() + this.arrowButton.getWidth(), this.arrowButton.getY() + this.arrowButton.getHeight());
                this.arrowButton.grabFocus();
            } else {
                this.popupMenu.setVisible(false);
                this.server.requestFocus();
            }
        } else if (e.getActionCommand().equals("ActivateBookmark")) {
            HLBookmarkFile bmf = ((BookmarkMenuItem)e.getSource()).getBookmarkFile();
            String address = bmf.get("address");
            int p = 5500;
            if (address.indexOf(":") != -1) {
                p = new Integer(address.substring(address.indexOf(":") + 1));
                address = address.substring(0, address.indexOf(":"));
            }
            this.server.setText(address);
            this.port.setText(new Integer(p).toString());
            this.login.setText(bmf.get("login"));
            this.password.setText(bmf.get("password"));
            this.server.requestFocus();
        } else if (e.getActionCommand().equals("Save ...")) {
            File bmPath = (File)Main.rlo.getProperty("Path.Bookmarks");
            if (!bmPath.exists()) {
                bmPath.mkdirs();
                if (!bmPath.exists()) {
                    new Error("Could not create bookmark path! Set bookmark path in Options->Paths...");
                    return;
                }
            }
            FileDialog fd = new FileDialog((Frame)this.f, "Save Bookmark", 1);
            fd.setDirectory(bmPath.toString());
            if (this.serverName != null) {
                fd.setFile(this.serverName);
            } else {
                fd.setFile(FilenameUtils.qualify(this.server.getText() + ":" + this.port.getText()));
            }
            fd.show();
            String save_file = fd.getFile();
            if (save_file != null) {
                this.serverName = save_file;
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        ConnectInterface.this.f.setTitle("Connect to " + ConnectInterface.this.serverName);
                    }
                });
                try {
                    HLBookmarkFile bmf = new HLBookmarkFile(new File((File)Main.rlo.getProperty("Path.Bookmarks"), save_file));
                    String address = this.server.getText();
                    if (!this.port.getText().equals("")) {
                        address = address + ":" + this.port.getText();
                    }
                    bmf.put("address", address);
                    bmf.put("login", this.login.getText());
                    bmf.put("password", this.password.getText());
                    bmf.store();
                    this.parent.displayPropertyChanged("bookmarkentries", "");
                }
                catch (IOException ex) {
                    new Error("Cannot save bookmark " + save_file + ": " + ex.getMessage());
                }
            }
        }
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowClosing(WindowEvent e) {
        this.f.setVisible(false);
        if (this.destroy_on_close) {
            this.f.dispose();
        }
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }

    public void show(boolean initServerName) {
        if (initServerName) {
            this.serverName = null;
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ConnectInterface.this.f.show();
                ConnectInterface.this.f.setTitle("Connect to " + (ConnectInterface.this.serverName == null ? "..." : ConnectInterface.this.serverName));
                SwingUtilities.invokeLater(new Runnable(this){
                    private final /* synthetic */ 3 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        3.access$000(this.this$1).server.requestFocus();
                    }
                });
            }

            static /* synthetic */ ConnectInterface access$000(3 x0) {
                return x0.ConnectInterface.this;
            }
        });
    }
}

