/*
 * Decompiled with CFR 0.152.
 */
package redlight.client;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.IOException;
import java.util.Stack;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import redlight.client.Child;
import redlight.client.DepthFirstFileSearch;
import redlight.client.DirOpener;
import redlight.client.DownloadInterface;
import redlight.client.FileNameTableCellRenderer;
import redlight.client.FileSearchAction;
import redlight.client.FileSizeTableCellRenderer;
import redlight.client.FileTCTableCellRenderer;
import redlight.client.Machine;
import redlight.client.Main;
import redlight.graphics.Spinner;
import redlight.hotline.HLException;
import redlight.hotline.HLProtocol;
import redlight.utils.BytesFormat;
import redlight.utils.DebuggerOutput;

public class FileSeeker
extends AbstractTableModel
implements Runnable,
ActionListener,
WindowListener,
Child,
MouseListener {
    Machine rlm;
    Container contentPane;
    Vector results;
    JLabel info;
    JTable list;
    JTextField find;
    JButton stop;
    JFrame f;
    Spinner spinner;
    String path;
    String search;
    Thread seeker;
    Stack visitedPaths;
    DepthFirstFileSearch fileSearch;
    static /* synthetic */ Class class$redlight$hotline$HLProtocol$FileListComponent;
    static /* synthetic */ Class class$java$lang$String;

    public FileSeeker(Machine machine, String pa) {
        this.rlm = machine;
        this.path = pa;
        this.results = new Vector();
        Font guiFont = (Font)Main.rlo.getProperty("Font.gui");
        this.f = new JFrame("Search (" + this.rlm.getServerName() + ")");
        this.contentPane = this.f.getContentPane();
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        JPanel p = new JPanel();
        JLabel l1 = new JLabel("Search for:");
        JLabel l2 = new JLabel("in " + this.path);
        this.find = new JTextField("", 12);
        this.stop = new JButton("", new ImageIcon(Main.rlo.getImageSet("FunctionIcons")[4]));
        JPanel spinnerPanel = new JPanel();
        this.list = new JTable(this);
        FileTCTableCellRenderer ftcTableCellRenderer = new FileTCTableCellRenderer();
        this.info = new JLabel("Idle.");
        this.spinner = new Spinner(Main.rlo.getImageSet("Spinner"), 100, 16, 16);
        this.contentPane.setLayout(gbl);
        p.setLayout(new FlowLayout(0));
        spinnerPanel.setLayout(new FlowLayout(2));
        this.stop.setEnabled(false);
        this.stop.setActionCommand("Stop");
        this.info.setFont((Font)Main.rlo.getProperty("Font.info"));
        this.list.setFont((Font)Main.rlo.getProperty("Font.list"));
        this.list.getColumnModel().getColumn(0).setPreferredWidth(600);
        this.list.getColumnModel().getColumn(1).setPreferredWidth(150);
        this.list.getColumnModel().getColumn(2).setPreferredWidth(300);
        this.list.getColumn("Size").setCellRenderer(new FileSizeTableCellRenderer());
        this.list.getColumn("Name").setCellRenderer(new FileNameTableCellRenderer());
        this.list.setBackground(this.rlm.getSchemeColor("background"));
        this.list.setForeground(this.rlm.getSchemeColor("foreground"));
        this.list.setShowVerticalLines(false);
        this.list.setShowHorizontalLines(false);
        this.list.setShowGrid(false);
        this.list.setRowHeight(18);
        this.list.setIntercellSpacing(new Dimension(0, 0));
        this.find.setCaretPosition(0);
        l1.setFont(guiFont);
        l2.setFont(guiFont);
        this.stop.setFont(guiFont);
        this.list.addMouseListener(this);
        this.stop.addActionListener(this);
        this.find.addActionListener(this);
        this.f.addWindowListener(this);
        p.add(this.stop);
        p.add(l1);
        p.add(this.find);
        if (!this.path.equals("")) {
            p.add(l2);
        }
        gbc.weightx = 1.0;
        gbc.fill = 2;
        this.contentPane.add((Component)p, gbc);
        spinnerPanel.add(this.spinner);
        gbc.gridx = 1;
        gbc.weightx = 0.0;
        gbc.fill = 0;
        this.contentPane.add((Component)spinnerPanel, gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.insets = (Insets)Main.rlo.getProperty("BorderInsets");
        gbc.fill = 1;
        JScrollPane scrollPane = new JScrollPane(this.list);
        this.contentPane.add((Component)scrollPane, gbc);
        scrollPane.getViewport().setBackground(this.list.getBackground());
        gbc.gridy = 2;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.fill = 2;
        this.contentPane.add((Component)this.info, gbc);
        this.f.pack();
        this.f.setSize(440, 340);
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension w = this.f.getSize();
        this.f.setLocation(d.width / 2 - w.width / 2, d.height / 2 - w.height / 2);
        this.find.requestFocus();
        this.f.show();
        this.rlm.getInterface().registerChild(this);
    }

    void itemActivated() {
        int index = this.list.getSelectedRow();
        if (index != -1) {
            HLProtocol.FileListComponent file = ((Item)this.results.elementAt((int)index)).file;
            String path = ((Item)this.results.elementAt((int)index)).path;
            String fullname = path + ':' + file.fileName;
            DebuggerOutput.debug("FileSeeker: opening " + fullname);
            if (file.fileType.equals("fldr")) {
                DirOpener.open(this.rlm, fullname);
            } else {
                new DownloadInterface(this.rlm, fullname, file);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        final String findString = this.search.toUpperCase();
        final FileSeeker seek = this;
        this.results.removeAllElements();
        this.stop.setEnabled(true);
        try {
            try {
                this.visitedPaths = new Stack();
                this.spinner.start();
                FileSearchAction finder = new FileSearchAction(){

                    public void fileFound(String path, HLProtocol.FileListComponent file) {
                        FileSeeker.this.info.setText(path);
                        if (file.fileName.toUpperCase().indexOf(findString) != -1) {
                            FileSeeker.this.results.addElement(new Item(path, file));
                            SwingUtilities.invokeLater(new UpdateList(new TableModelEvent(seek)));
                        }
                    }
                };
                this.fileSearch = new DepthFirstFileSearch();
                this.fileSearch.descend(this.rlm.getHLC(), this.path, 0, 0, finder);
            }
            catch (InterruptedException e) {
                Object var7_6 = null;
                this.spinner.stop();
                this.stop.setEnabled(false);
                this.info.setText("Idle" + (this.results.size() > 0 ? " (" + this.results.size() + " items found)." : "."));
                return;
            }
            catch (IOException e) {
                Object var7_7 = null;
                this.spinner.stop();
                this.stop.setEnabled(false);
                this.info.setText("Idle" + (this.results.size() > 0 ? " (" + this.results.size() + " items found)." : "."));
                return;
            }
            catch (HLException e) {
                Object var7_8 = null;
                this.spinner.stop();
                this.stop.setEnabled(false);
                this.info.setText("Idle" + (this.results.size() > 0 ? " (" + this.results.size() + " items found)." : "."));
                return;
            }
            Object var7_5 = null;
            this.spinner.stop();
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            this.spinner.stop();
            this.stop.setEnabled(false);
            this.info.setText("Idle" + (this.results.size() > 0 ? " (" + this.results.size() + " items found)." : "."));
            throw throwable;
        }
        this.stop.setEnabled(false);
        this.info.setText("Idle" + (this.results.size() > 0 ? " (" + this.results.size() + " items found)." : "."));
    }

    public int getColumnCount() {
        return 3;
    }

    public int getRowCount() {
        return this.results.size();
    }

    public Object getValueAt(int row, int col) {
        Item i = (Item)this.results.elementAt(row);
        switch (col) {
            case 0: {
                return i.file;
            }
            case 1: {
                return i.file.fileType.equals("fldr") ? "(" + i.file.fileSize + ")" : " " + BytesFormat.format(i.file.fileSize);
            }
            case 2: {
                return i.path;
            }
        }
        return null;
    }

    public Class getColumnClass(int col) {
        switch (col) {
            case 0: {
                return class$redlight$hotline$HLProtocol$FileListComponent == null ? (class$redlight$hotline$HLProtocol$FileListComponent = FileSeeker.class$("redlight.hotline.HLProtocol$FileListComponent")) : class$redlight$hotline$HLProtocol$FileListComponent;
            }
        }
        return class$java$lang$String == null ? (class$java$lang$String = FileSeeker.class$("java.lang.String")) : class$java$lang$String;
    }

    public String getColumnName(int col) {
        if (col == 0) {
            return "Name";
        }
        if (col == 1) {
            return "Size";
        }
        if (col == 2) {
            return "Where";
        }
        return "error: col = " + col;
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.find) {
            this.search = this.find.getText().trim();
            if (this.seeker != null && this.seeker.isAlive()) {
                this.fileSearch.interrupt();
                try {
                    this.seeker.join();
                }
                catch (InterruptedException ex) {
                    // empty catch block
                }
            }
            if (!this.search.trim().equals("")) {
                if (this.fileSearch != null) {
                    this.fileSearch.interrupt();
                }
                this.seeker = new Thread(this);
                this.seeker.start();
            }
        } else if (e.getActionCommand().equals("Stop") && this.seeker.isAlive()) {
            if (this.fileSearch != null) {
                this.fileSearch.interrupt();
            }
            try {
                this.seeker.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.seeker = null;
        }
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowClosing(WindowEvent e) {
        this.rlm.getInterface().unregisterChild(this);
        this.close();
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() == 2) {
            this.itemActivated();
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void displayPropertyChanged(String what, final Object property) {
        if (what.equals("listfont")) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    FileSeeker.this.list.setFont((Font)property);
                }
            });
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    FileSeeker.this.list.setBackground(FileSeeker.this.rlm.getSchemeColor("background"));
                    FileSeeker.this.list.setForeground(FileSeeker.this.rlm.getSchemeColor("foreground"));
                }
            });
        }
    }

    public void close() {
        if (this.seeker != null && this.fileSearch != null) {
            this.fileSearch.interrupt();
        }
        this.f.dispose();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class UpdateList
    implements Runnable {
        TableModelEvent tev;

        UpdateList(TableModelEvent t) {
            this.tev = t;
        }

        public void run() {
            FileSeeker.this.list.tableChanged(this.tev);
            FileSeeker.this.list.repaint();
        }
    }

    class Item {
        protected String path;
        protected HLProtocol.FileListComponent file;

        Item(String p, HLProtocol.FileListComponent f) {
            this.path = p;
            this.file = f;
        }
    }
}

