/*
 * Decompiled with CFR 0.152.
 */
package redlight.client;

import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.DefaultListModel;
import javax.swing.SwingUtilities;
import redlight.client.AdminMessageInterface;
import redlight.client.AgreementInterface;
import redlight.client.ChatWindow;
import redlight.client.ColorScheme;
import redlight.client.Interface;
import redlight.client.Main;
import redlight.client.MessageReceive;
import redlight.client.PrivChatInterface;
import redlight.client.PrivChatInviteInterface;
import redlight.client.StateObject;
import redlight.client.TransferInterface;
import redlight.client.User;
import redlight.client.UserListModel;
import redlight.hotline.AgreementRejectedException;
import redlight.hotline.FailedLoginException;
import redlight.hotline.HLClient;
import redlight.hotline.HLClientAdapter;
import redlight.hotline.HLClientListener;
import redlight.hotline.HLProtocol;
import redlight.hotline.HLTaskErrorException;
import redlight.script.ScriptBroker;
import redlight.script.ScriptObject;
import redlight.script.ScriptResult;
import redlight.script.Scriptable;
import redlight.script.UnknownMessageException;
import redlight.utils.AppAudioClip;
import redlight.utils.DebuggerOutput;
import redlight.utils.FilenameUtils;
import redlight.utils.Logger;
import redlight.utils.QueueThread;

public class Machine
extends HLClientAdapter
implements Scriptable {
    boolean audioMute = false;
    boolean connected = false;
    int port;
    Interface rli;
    ColorScheme colorScheme;
    Color fgColor;
    Color bgColor;
    HLClient hlc = null;
    ScriptBroker scriptBroker;
    Hashtable chatWindows;
    Hashtable listModels;
    Hashtable userDomains;
    Hashtable domainStates;
    Hashtable domainLogWriters;
    Hashtable taskListeners;
    String server;
    String login;
    String password;
    String serverName;
    QueueThread transferQueue;
    KillThread killThread;

    public Machine(Interface rli) {
        this.rli = rli;
        this.server = "redlight.wox.org";
        this.login = "guest";
        this.password = "";
        this.port = 5500;
        this.scriptBroker = new ScriptBroker();
        this.taskListeners = new Hashtable();
        this.userDomains = new Hashtable();
        this.listModels = new Hashtable();
        this.chatWindows = new Hashtable();
        this.domainStates = new Hashtable();
        this.domainLogWriters = new Hashtable();
        this.transferQueue = new QueueThread();
        this.transferQueue.sleepTime = 5000;
        this.killThread = new KillThread(this);
        this.killThread.start();
    }

    public void create() throws IOException {
        this.scriptBroker.addTarget(this);
        this.createDomain("Public");
        Main.addMachine(this);
        this.hlc = new HLClient(this.server, this.port, this.login, this.password, Main.rlo.getStringProperty("User.Nick"), (short)Main.rlo.getIntegerProperty("User.IconNumber"));
    }

    public void disconnect() {
        this.killThread.disconnect();
    }

    public synchronized void connect() {
        block20: {
            try {
                try {
                    this.hlc.addHLClientListener(this);
                    DebuggerOutput.debug("Machine.connect: connecting ...");
                    this.hlc.connect();
                    DebuggerOutput.debug("Machine.connect: logging in ...");
                    this.hlc.login();
                    DebuggerOutput.debug("Machine.connect: getting user list ...");
                    HLProtocol.UserListComponent[] uc = this.hlc.getUserList();
                    Hashtable hashtable = this.userDomains;
                    synchronized (hashtable) {
                        this.addUsersToDomain(uc);
                    }
                    this.rli.connectSuccess();
                    this.connected = true;
                }
                catch (UnknownHostException e) {
                    this.rli.error("Could not locate the server " + this.getServerName());
                    Object var9_7 = null;
                    if (!this.connected) {
                        this.disconnect();
                    }
                    break block20;
                }
                catch (SocketException e) {
                    DebuggerOutput.stackTrace(e);
                    this.rli.error("The connnection to " + this.getServerName() + " was refused.");
                    Object var9_8 = null;
                    if (!this.connected) {
                        this.disconnect();
                    }
                    break block20;
                }
                catch (AgreementRejectedException e) {
                    Object var9_9 = null;
                    if (!this.connected) {
                        this.disconnect();
                    }
                    break block20;
                }
                catch (FailedLoginException e) {
                    this.rli.error(e.getMessage());
                    Object var9_10 = null;
                    if (!this.connected) {
                        this.disconnect();
                    }
                    break block20;
                }
                catch (HLTaskErrorException e) {
                    Object var9_11 = null;
                    if (!this.connected) {
                        this.disconnect();
                    }
                    break block20;
                }
                catch (Exception e) {
                    DebuggerOutput.stackTrace(e);
                    this.rli.error("An unknown error occurred while trying to connect to " + this.getServerName() + ".");
                    Object var9_12 = null;
                    if (!this.connected) {
                        this.disconnect();
                    }
                }
                Object var9_6 = null;
                if (!this.connected) {
                    this.disconnect();
                }
            }
            catch (Throwable throwable) {
                Object var9_13 = null;
                if (!this.connected) {
                    this.disconnect();
                }
                throw throwable;
            }
        }
    }

    void randomBGColor() {
        int it = 0;
        this.bgColor = new Color((int)(Math.random() * 1.6777215E7));
        float[] hsb = Color.RGBtoHSB(this.bgColor.getRed(), this.bgColor.getBlue(), this.bgColor.getGreen(), null);
        while ((double)hsb[2] < 0.8 && (double)hsb[1] < 0.5 && it++ < 100) {
            this.bgColor = this.bgColor.brighter();
        }
    }

    public ScriptBroker getScriptBroker() {
        return this.scriptBroker;
    }

    public void addTaskListener(int id, HLClientListener h) {
        this.taskListeners.put(new Integer(id), h);
    }

    public String getServerName() {
        if (this.serverName == null) {
            return this.server + ":" + this.port;
        }
        return this.serverName;
    }

    public String getServer() {
        return this.server;
    }

    public int getPort() {
        return this.port;
    }

    public String getLogin() {
        return this.login;
    }

    public String getPassword() {
        return this.password;
    }

    public HLClient getHLC() {
        return this.hlc;
    }

    public Interface getInterface() {
        return this.rli;
    }

    public void setServerName(String s) {
        this.serverName = s;
    }

    public void setServer(String s) {
        this.server = s;
        this.readColorScheme();
    }

    public void setPort(int p) {
        this.port = p;
    }

    public void setLogin(String s) {
        this.login = s;
    }

    public void setPassword(String s) {
        this.password = s;
    }

    public void writeChat(String msg) {
        this.writeChat("Public", msg);
    }

    public void writeChat(Object domain, String msg) {
        if (this.chatWindows.containsKey(domain)) {
            ((ChatWindow)this.chatWindows.get(domain)).chat(msg);
        }
    }

    public boolean isShowJoinLeaveEnabled() {
        return this.isShowJoinLeaveEnabled("Public");
    }

    public boolean isShowJoinLeaveEnabled(Object domain) {
        return (Boolean)this.getState(domain, 2);
    }

    public boolean isLogEnabled() {
        return this.isLogEnabled("Public");
    }

    public boolean isLogEnabled(Object domain) {
        return (Boolean)this.getState(domain, 1);
    }

    public Object getState(int what) {
        return this.getState("Public", what);
    }

    public Object getState(Object domain, int what) {
        if (this.domainStates.containsKey(domain)) {
            Hashtable state = (Hashtable)this.domainStates.get(domain);
            return state.get(new Integer(what));
        }
        return null;
    }

    public void setState(int what, Object state) {
        this.setState("Public", what, state);
    }

    public void setState(Object domain, int w, Object s) {
        StateObject state = new StateObject(domain, w, s);
        try {
            this.getScriptBroker().executeScript(new ScriptObject(16L, state));
        }
        catch (UnknownMessageException _e) {
            // empty catch block
        }
    }

    public DefaultListModel getUserListModel() {
        return this.getUserListModel("Public");
    }

    public DefaultListModel getUserListModel(Object domain) {
        DebuggerOutput.debug("Machine.getUserListModel: getting user list for domain " + domain);
        return (DefaultListModel)this.listModels.get(domain);
    }

    Hashtable getUserHashtable(Object domain) {
        return (Hashtable)this.userDomains.get(domain);
    }

    void modifyUser(int sock, String nick, int icon, int color) {
        User newuser = new User();
        newuser.sock = sock;
        newuser.nick = nick;
        newuser.icon = icon;
        newuser.color = color;
        Enumeration en = this.listModels.keys();
        while (en.hasMoreElements()) {
            Object domain = en.nextElement();
            if (!this.isKnownUser(domain, sock)) continue;
            DefaultListModel ulm = this.getUserListModel(domain);
            Hashtable uh = this.getUserHashtable(domain);
            User user = this.getUser(domain, sock);
            if (!user.nick.equals(nick)) {
                this.handleChat(domain, "\n <<< " + user.nick + " is now known as " + nick + " >>>");
            }
            int index = ulm.indexOf(user);
            ulm.setElementAt(newuser, index);
            uh.put(new Integer(sock), newuser);
        }
    }

    public User getUserOrDummy(int sock) {
        User user = this.getUser(sock);
        if (user == null) {
            user = new User(sock, -1, -1, 0, "???");
        }
        return user;
    }

    public User getUser(int sock) {
        return this.getUser("Public", sock);
    }

    public User getUser(Object domain, int sock) {
        Hashtable uh = this.getUserHashtable(domain);
        return (User)uh.get(new Integer(sock));
    }

    public boolean isKnownUser(int sock) {
        return this.isKnownUser("Public", sock);
    }

    public boolean isKnownUser(Object domain, int sock) {
        Hashtable uh = this.getUserHashtable(domain);
        return uh.containsKey(new Integer(sock));
    }

    Hashtable createDomainStates() {
        Hashtable<Integer, Boolean> s = new Hashtable<Integer, Boolean>();
        s.put(new Integer(1), new Boolean(Main.rlo.getBooleanProperty("Toggle.Log")));
        s.put(new Integer(2), new Boolean(Main.rlo.getBooleanProperty("Toggle.JoinLeave")));
        return s;
    }

    public void createDomain(Object domain) {
        DebuggerOutput.debug("Machine.createDomain: creating domain " + domain);
        this.domainStates.put(domain, this.createDomainStates());
        this.userDomains.put(domain, new Hashtable());
        this.listModels.put(domain, new UserListModel());
        this.domainLogWriters.put(domain, new Logger());
        if (this.isLogEnabled(domain)) {
            this.openLogWriter(domain);
        }
    }

    public void destroyDomain(Object domain) {
        this.closeLogWriter(domain);
        this.domainLogWriters.remove(domain);
        this.domainStates.remove(domain);
        this.userDomains.remove(domain);
        this.listModels.remove(domain);
    }

    public boolean isKnownDomain(Object domain) {
        return this.listModels.containsKey(domain);
    }

    void addUsersToDomain(HLProtocol.UserListComponent[] uh) {
        this.addUsersToDomain("Public", uh);
    }

    public void addUsersToDomain(Object domain, HLProtocol.UserListComponent[] uc) {
        int i = uc.length - 1;
        while (i >= 0) {
            if (uc[i] != null) {
                this.addUserToDomain(domain, uc[i].sock, uc[i].nick, uc[i].icon, uc[i].clr);
            }
            --i;
        }
    }

    void addUserToDomain(Object domain, int sock, String nick, int icon, int color) {
        DebuggerOutput.debug("addUserToDomain: calling handleUserChange");
        this.handleUserChange(domain, sock, nick, icon, color, true);
    }

    public User[] getUsers() {
        return this.getUsers("Public");
    }

    public User[] getUsers(Object domain) {
        DefaultListModel ulm = this.getUserListModel(domain);
        Hashtable uh = this.getUserHashtable(domain);
        User[] u = new User[ulm.getSize()];
        int i = 0;
        while (i < ulm.getSize()) {
            u[i] = (User)ulm.getElementAt(i);
            ++i;
        }
        return u;
    }

    void notifyJoinLeave(Object domain, String msg) {
        if (this.isShowJoinLeaveEnabled(domain)) {
            this.handleChat(domain, msg);
        }
    }

    boolean openLogWriter(Object domain) {
        DebuggerOutput.debug("opening logfile for " + domain);
        Logger logger = this.getLogWriter(domain);
        File logPath = new File(Main.CONFIGURATION_DIRECTORY, "Log");
        String kind = domain.equals("Public") ? "" : "-privchat-" + Integer.toHexString(Math.abs((Integer)domain));
        String logFile = FilenameUtils.qualify(this.getServerName() + kind);
        if (!logger.openLog(new File(logPath, logFile), "Server: " + this.getServerName() + " [" + this.getServer() + ":" + this.getPort() + "]", true)) {
            this.getInterface().error("Error opening logfile: " + logger.getError().getMessage());
            this.setState(domain, 1, new Boolean(false));
            return false;
        }
        return true;
    }

    void closeLogWriter(Object domain) {
        if (this.isLogEnabled(domain)) {
            DebuggerOutput.debug("closing logfile for " + domain);
            this.getLogWriter(domain).closeLog();
        }
    }

    Logger getLogWriter(Object domain) {
        return (Logger)this.domainLogWriters.get(domain);
    }

    public boolean isAudioSupported() {
        return AppAudioClip.isAudioSupported();
    }

    public void playAudio(String s) {
        if (Main.rlo != null && !this.audioMute) {
            Main.rlo.playAudioClip(s);
        }
    }

    public void muteAudio(boolean t) {
        this.audioMute = t;
    }

    public void registerChat(ChatWindow c) {
        this.registerChat("Public", c);
    }

    public void unregisterChat(ChatWindow c) {
        this.unregisterChat("Public", c);
    }

    public void registerChat(Object domain, ChatWindow c) {
        this.chatWindows.put(domain, c);
    }

    public void unregisterChat(Object domain, ChatWindow c) {
        this.chatWindows.remove(domain);
    }

    ScriptResult processStateChange(StateObject state) {
        int status = ScriptResult.RESULT_NO_ERROR;
        if (this.domainStates.containsKey(state.domain)) {
            Hashtable states = (Hashtable)this.domainStates.get(state.domain);
            states.put(new Integer(state.what), state.state);
            switch (state.what) {
                case 1: {
                    boolean open = (Boolean)state.state;
                    if (open) {
                        status = this.openLogWriter(state.domain) ? ScriptResult.RESULT_NO_ERROR : ScriptResult.RESULT_ERROR;
                        break;
                    }
                    this.closeLogWriter(state.domain);
                }
            }
        }
        return new ScriptResult((Scriptable)this, status);
    }

    void readColorScheme() {
        if (Main.rlo != null) {
            this.colorScheme = Main.rlo.getColorScheme(this.getServer() + "-" + this.getPort());
            if (this.colorScheme != null) {
                this.fgColor = this.colorScheme.getSchemeColor("foreground");
                if (this.fgColor == null) {
                    this.fgColor = new Color(0);
                }
                this.bgColor = this.colorScheme.getSchemeColor("background");
                if (this.bgColor == null) {
                    this.randomBGColor();
                }
                return;
            }
        }
        this.fgColor = new Color(0);
        if (Main.rlo != null && !Main.rlo.getBooleanProperty("Toggle.Color")) {
            this.bgColor = new Color(0xFFFFFF);
            return;
        }
        this.randomBGColor();
    }

    public ColorScheme getColorScheme() {
        if (this.colorScheme != null) {
            return this.colorScheme;
        }
        ColorScheme cs = new ColorScheme();
        cs.setSchemeColor("foreground", this.fgColor);
        cs.setSchemeColor("background", this.bgColor);
        return cs;
    }

    public Color getSchemeColor(String part) {
        if (this.colorScheme != null) {
            return this.colorScheme.getSchemeColor(part);
        }
        if (part.equals("foreground")) {
            return this.fgColor;
        }
        if (part.equals("background") && Main.rlo.getBooleanProperty("Toggle.Color")) {
            return this.bgColor;
        }
        if (part.equals("background") && !Main.rlo.getBooleanProperty("Toggle.Color")) {
            return new Color(0xFFFFFF);
        }
        return new Color(0xFFFFFF);
    }

    public void setSchemeColor(String part, Color color) {
        if (this.colorScheme == null) {
            this.colorScheme = new ColorScheme();
            this.colorScheme.setSchemeColor("foreground", this.fgColor);
            this.colorScheme.setSchemeColor("background", this.bgColor);
        }
        this.colorScheme.setSchemeColor(part, color);
        Main.rlo.setColorScheme(this.getServer() + "-" + this.getPort(), this.colorScheme);
    }

    private String filter(String msg) {
        byte[] b = msg.getBytes();
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < b.length) {
            if (!Character.isISOControl((char)b[i])) {
                sb.append((char)b[i]);
            }
            ++i;
        }
        return sb.toString();
    }

    public String toString() {
        return this.getServer() + ":" + this.getPort() + " [" + this.getLogin() + "/" + this.getPassword() + "]";
    }

    public boolean addTransfer(TransferInterface ti) {
        return this.transferQueue.add(ti);
    }

    public void removeTransfer(TransferInterface ti) {
        this.transferQueue.remove(ti);
    }

    public void gotTarget(ScriptBroker sb) {
    }

    public void lostTarget(ScriptBroker sb) {
    }

    public long getKnownMessages() {
        return 16L;
    }

    public ScriptResult executeScript(ScriptObject s) throws UnknownMessageException {
        int value = (int)s.getType();
        switch (value) {
            case 16: {
                StateObject state = (StateObject)s.getUserObject();
                return this.processStateChange(state);
            }
        }
        throw new UnknownMessageException();
    }

    public void handleDisconnect(String msg) {
        DebuggerOutput.debug("Machine.handleDisconnect: error = " + msg);
        this.rli.error("The connection with the server has unexpectedly closed.");
        DebuggerOutput.debug("Machine.handleDisconnect: disconnecting ...");
        this.disconnect();
        DebuggerOutput.debug("Machine.handleDisconnect: finished");
    }

    public void handleTransferQueuePosition(int ref, int position) {
        Enumeration en = this.taskListeners.keys();
        while (en.hasMoreElements()) {
            ((HLClientListener)this.taskListeners.get(en.nextElement())).handleTransferQueuePosition(ref, position);
        }
    }

    public void handleTaskComplete(int id) {
        DebuggerOutput.debug("Machine.handleTaskComplete: id = " + id);
        Integer k = new Integer(id);
        if (this.taskListeners.containsKey(k)) {
            HLClientListener h = (HLClientListener)this.taskListeners.get(k);
            this.taskListeners.remove(k);
            h.handleTaskComplete(id);
        }
    }

    public void handleTaskError(int id, String err) {
        DebuggerOutput.debug("Machine.handleTaskError: id = " + id + ", err = " + err);
        Integer k = new Integer(id);
        if (this.taskListeners.containsKey(k)) {
            HLClientListener h = (HLClientListener)this.taskListeners.get(k);
            this.taskListeners.remove(k);
            h.handleTaskError(id, err);
        } else {
            this.rli.error(err);
        }
    }

    public void handleUserChange(int sock, String nick, int icon, int color) {
        this.handleUserChange(sock, nick, icon, color, false);
    }

    public void handleUserChange(int sock, String nick, int icon, int color, boolean init) {
        this.handleUserChange("Public", sock, nick, icon, color, init);
    }

    public void handleUserChange(Object domain, int sock, String nick, int icon, int color, boolean init) {
        Hashtable hashtable = this.userDomains;
        synchronized (hashtable) {
            DefaultListModel ulm = this.getUserListModel(domain);
            Hashtable uh = this.getUserHashtable(domain);
            if (this.isKnownUser(domain, sock)) {
                DebuggerOutput.debug("Machine.handleUserChange[" + sock + "]: user change");
                this.modifyUser(sock, nick, icon, color);
            } else {
                DebuggerOutput.debug("Machine.handleUserChange[" + sock + "]: user join");
                User user = new User();
                user.sock = sock;
                user.icon = icon;
                user.color = color;
                user.nick = nick;
                if (init) {
                    ulm.insertElementAt(user, 0);
                } else {
                    ulm.addElement(user);
                }
                uh.put(new Integer(sock), user);
                if (!init) {
                    this.playAudio("userjoin");
                }
                this.notifyJoinLeave(domain, "\n <<< " + nick + " joins >>>");
            }
        }
    }

    public void handleUserLeave(int sock) {
        this.handleUserLeave("Public", sock);
    }

    public void handleUserLeave(Object domain, int sock) {
        DefaultListModel ulm = this.getUserListModel(domain);
        Hashtable uh = this.getUserHashtable(domain);
        User user = (User)uh.get(new Integer(sock));
        if (user != null) {
            ulm.removeElement(user);
            uh.remove(new Integer(sock));
            this.playAudio("userleave");
            this.notifyJoinLeave(domain, "\n <<< " + user.nick + " leaves >>>");
        }
    }

    public void handlePrivateChatCreate(final int pcref, final int sock, final String nick, final int icon, final int color) {
        DebuggerOutput.debug("handlePrivateChatCreate: calling addUserToDomain");
        final Machine machine = this;
        this.createDomain(new Integer(pcref));
        this.addUserToDomain(new Integer(pcref), sock, nick, icon, color);
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    new PrivChatInterface(machine, pcref, sock, nick, icon, color);
                }
            });
        }
        catch (InterruptedException e) {
        }
        catch (InvocationTargetException e) {
            // empty catch block
        }
    }

    public void handlePrivateChatUserChange(int pcref, int sock, String nick, int icon, int color) {
        if (this.isKnownDomain(new Integer(pcref))) {
            this.handleUserChange(new Integer(pcref), sock, nick, icon, color, false);
        }
    }

    public void handlePrivateChatUserLeave(int pcref, int sock) {
        if (this.isKnownDomain(new Integer(pcref))) {
            this.handleUserLeave(new Integer(pcref), sock);
        }
    }

    public void handlePrivateChat(int ref, String msg) {
        this.handleChat(new Integer(ref), msg);
    }

    public void handleChat(String msg) {
        this.handleChat("Public", msg);
    }

    public void handleChat(Object domain, String msg) {
        Logger logger;
        this.writeChat(domain, msg.replace('\r', '\n'));
        if (this.isLogEnabled(domain) && !(logger = this.getLogWriter(domain)).writeLog(msg.trim())) {
            this.getInterface().error("Error writing to logfile: " + logger.getError().getMessage());
            this.setState(domain, 1, new Boolean(false));
        }
        this.playAudio("receivechat");
    }

    public void handlePrivateChatInvite(int pcref, int sock, String nick) {
        new PrivChatInviteInterface(this, pcref, sock, nick);
    }

    public void handleMessage(int sock, String nick, String message) {
        User user = this.getUser(sock);
        if (user == null) {
            user = new User(sock, -1, -1, 0, nick);
        }
        new MessageReceive(this, user, message);
    }

    public boolean handleAgreement(String agreement) {
        if (this.connected) {
            return AgreementInterface.handleAgreement(this, agreement);
        }
        return true;
    }

    public void handleAdministratorMessage(final String msg) {
        final Machine rlm = this;
        if (this.connected) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    AdminMessageInterface.handleAdministratorMessage(rlm, msg);
                }
            });
        }
    }

    class KillThread
    extends Thread {
        Machine rlm;
        Integer lock = new Integer(0);
        boolean running = false;

        KillThread(Machine rlm) {
            this.rlm = rlm;
        }

        public void disconnect() {
            Integer n = this.lock;
            synchronized (n) {
                if (this.running) {
                    return;
                }
            }
            this.synchronizedDisconnect();
        }

        private synchronized void synchronizedDisconnect() {
            DebuggerOutput.debug("KillThread.disconnect: notifying kill thread");
            this.notify();
        }

        public synchronized void run() {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            Integer n = this.lock;
            synchronized (n) {
                this.running = true;
            }
            DebuggerOutput.debug("KillThread.run: kill thread woken up.");
            if (this.rlm.hlc != null) {
                this.rlm.hlc.removeHLClientListener(this.rlm);
            }
            DebuggerOutput.debug("KillThread.run: calling disconnectSuccess on interface");
            this.rlm.rli.disconnectSuccess();
            try {
                if (this.rlm.hlc != null) {
                    DebuggerOutput.debug("KillThread.run: closing HLClient");
                    this.rlm.hlc.close();
                }
            }
            catch (IOException e) {
                DebuggerOutput.debug("KillThread.run: IOException: " + e);
            }
            this.rlm.scriptBroker.removeTarget(this.rlm);
            Main.removeMachine(this.rlm);
            this.rlm.destroyDomain("Public");
            this.rlm.transferQueue.stop();
            this.rlm.taskListeners.clear();
            DebuggerOutput.debug("KillThread.run: finished");
        }
    }
}

