/*
 * Decompiled with CFR 0.152.
 */
package redlight.client;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import redlight.client.Child;
import redlight.client.Machine;
import redlight.client.Main;

public abstract class SimpleDialog
implements Child,
ActionListener,
WindowListener {
    Machine rlm;
    Container contentPane;
    Font guiFont;
    JLabel caption;
    JTextField textfield;
    JButton[] buttons;
    JPanel buttonPanel;
    JFrame f;

    public SimpleDialog(Machine machine, String title) {
        this.rlm = machine;
        this.guiFont = (Font)Main.rlo.getProperty("Font.gui");
        this.f = new JFrame(title + " (" + this.rlm.getServerName() + ")");
        this.contentPane = this.f.getContentPane();
        GridBagConstraints gbc = new GridBagConstraints();
        this.caption = new JLabel();
        this.textfield = new JTextField("", 31);
        this.buttonPanel = new JPanel();
        this.contentPane.setLayout(new GridBagLayout());
        this.textfield.setFont(this.guiFont);
        this.caption.setFont(this.guiFont);
        this.f.addWindowListener(this);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.anchor = 17;
        gbc.insets = (Insets)Main.rlo.getProperty("BorderInsets");
        this.contentPane.add((Component)this.caption, gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.anchor = 10;
        this.contentPane.add((Component)this.textfield, gbc);
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.fill = 0;
        this.contentPane.add((Component)this.buttonPanel, gbc);
        this.textfield.requestFocus();
        this.rlm.getInterface().registerChild(this);
    }

    public void show() {
        this.f.pack();
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension w = this.f.getSize();
        this.f.setLocation(d.width / 2 - w.width / 2, d.height / 2 - w.height / 2);
        this.f.show();
    }

    public void addButtons(String[] b) {
        this.buttons = new JButton[b.length];
        int i = 0;
        while (i < b.length) {
            this.buttons[i] = new JButton(b[i]);
            this.buttons[i].setFont(this.guiFont);
            this.buttons[i].addActionListener(this);
            this.buttonPanel.add(this.buttons[i]);
            ++i;
        }
    }

    public void close() {
        this.f.dispose();
    }

    public void displayPropertyChanged(String what, Object property) {
    }

    public abstract void actionPerformed(ActionEvent var1);

    public void windowActivated(WindowEvent e) {
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowClosing(WindowEvent e) {
        this.rlm.getInterface().unregisterChild(this);
        this.close();
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }
}

