/*
 * Decompiled with CFR 0.152.
 */
package redlight.client;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.PipedInputStream;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import redlight.client.AbstractViewInterface;
import redlight.client.Machine;
import redlight.client.Main;
import redlight.client.TransferInterface;
import redlight.utils.DebuggerOutput;

public class ViewTextInterface
extends AbstractViewInterface
implements Runnable {
    JScrollPane scrollPane;
    JTextArea text = new JTextArea("", 20, 60);

    public ViewTextInterface(Machine machine, TransferInterface transferInterface, String filename, long total, PipedInputStream inputPipe) {
        super(machine, transferInterface, "text", filename, total, inputPipe);
        this.scrollPane = new JScrollPane(this.text);
        this.text.setBackground(machine.getSchemeColor("background"));
        this.text.setForeground(machine.getSchemeColor("foreground"));
        this.text.setFont((Font)Main.rlo.getProperty("Font.text"));
        this.text.setEditable(false);
        this.text.setFont((Font)Main.rlo.getProperty("Font.text"));
        this.text.setWrapStyleWord(false);
        this.text.setLineWrap(false);
        this.scrollPane.setHorizontalScrollBarPolicy(30);
        this.contentPane.setLayout(new BorderLayout());
        this.contentPane.add((Component)this.scrollPane, "Center");
        this.f.pack();
        this.show();
        new Thread(this).start();
    }

    public void run() {
        LineNumberReader lineReader = new LineNumberReader(new InputStreamReader(this.inputPipe));
        StringBuffer content = new StringBuffer();
        try {
            try {
                this.text.setText("");
                this.text.setCaretPosition(0);
                String line = lineReader.readLine();
                while (line != null) {
                    content.append(line + "\n");
                    if (lineReader.getLineNumber() % 100 == 0) {
                        this.text.append(content.toString());
                        content.setLength(0);
                    }
                    line = lineReader.readLine();
                }
            }
            catch (IOException e) {
                DebuggerOutput.stackTrace(e);
                Object var5_6 = null;
                this.text.append(content.toString());
                content.setLength(0);
            }
            Object var5_5 = null;
            this.text.append(content.toString());
            content.setLength(0);
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            this.text.append(content.toString());
            content.setLength(0);
            throw throwable;
        }
        DebuggerOutput.debug("ViewTextInterface.slurper: exiting");
    }
}

