/*
 * Decompiled with CFR 0.152.
 */
package redlight.hotline;

import java.io.File;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Random;
import java.util.Vector;
import redlight.hotline.HLProtocol;
import redlight.hotline.HLServerAccountsTable;
import redlight.hotline.HLServerAgreement;
import redlight.hotline.HLServerBanTable;
import redlight.hotline.HLServerDispatcher;
import redlight.hotline.HLServerFlatnews;
import redlight.hotline.HLServerListener;
import redlight.hotline.HLServerMonitor;
import redlight.hotline.HLServerPolicy;
import redlight.hotline.HLServerTrackerTable;
import redlight.hotline.HLTransferServer;
import redlight.hotline.InvalidRealmException;
import redlight.hotline.OutOfSocketIDsException;
import redlight.hotline.TooManyTransfersException;
import redlight.hotline.TransferThread;
import redlight.macfiles.MacFile;
import redlight.utils.BytesFormat;
import redlight.utils.DebuggerOutput;
import redlight.utils.QuickSort;
import redlight.utils.TextUtils;
import redlight.utils.TimeFormat;
import redlight.utils.ToArrayConverters;

public class HLServer {
    int port = 5500;
    int backlog = 10;
    int maximumUsers = 1000;
    int maximumProtocolErrors = 10;
    int maximumConcurrentDownloads = 10;
    int maximumConcurrentUploads = 10;
    int maximumDownloadSpots;
    long banSeconds = 600L;
    InetAddress address = null;
    HLServerAgreement agreement;
    HLServerAccountsTable accountsTable;
    HLServerBanTable banTable;
    HLServerTrackerTable trackerTable;
    HLServerFlatnews flatnews;
    HLServerMonitor hsm;
    String serverName = "Red Light";
    String serverDescription = "Red Light advanced server.";
    String administratorPassword = null;
    File homeDirectory;
    File trashDirectory;
    int maximumDownloadsPerUser = 1;
    int maximumUploadsPerUser = 2;
    int maximumDownloads = 10;
    int maximumUploads = 20;
    int maximumDownloadQueueSpots = 25;
    int maximumUploadQueueSpots = 50;
    ServerSocket socket = null;
    ServerSocket transferSocket = null;
    Vector clients = new Vector();
    boolean serverIsRunning = false;
    short[] socketInUse = null;
    short socketCounter = 1;
    public int downloadsInProgress = 0;
    public int uploadsInProgress = 0;
    public int downloadsInQueue = 0;
    public int uploadsInQueue = 0;
    public int downloadCounter = 0;
    public int uploadCounter = 0;
    public int connectionCounter = 0;
    public int connectionPeak = 0;
    public long uptime = 0L;
    static HLProtocol hlp = new HLProtocol();
    HLServerListener hsl = new HLServerListener();
    HLServerPolicy hsp = new HLServerPolicy(this);
    boolean hslSet = false;
    boolean hspSet = false;
    HLTransferServer transferServer = null;
    Random randomGenerator;
    RealmTable realmTable;
    TransferQueue transferQueue;

    public HLServer() {
        this.agreement = new HLServerAgreement(this);
        this.accountsTable = new HLServerAccountsTable(this);
        this.banTable = new HLServerBanTable(this);
        this.trackerTable = new HLServerTrackerTable(this);
        this.flatnews = new HLServerFlatnews(this);
        this.realmTable = new RealmTable(this);
        this.transferQueue = new TransferQueue(this);
        this.homeDirectory = new File(System.getProperty("user.dir"));
        this.trashDirectory = new File(System.getProperty("java.io.tmpdir"));
        this.randomGenerator = new Random(System.currentTimeMillis());
    }

    public void setServerName(String newName) {
        if (newName == null) {
            throw new IllegalArgumentException("newName == null");
        }
        this.serverName = newName;
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerDescription(String newDescription) {
        if (newDescription == null) {
            throw new IllegalArgumentException("newDescription == null");
        }
        this.serverDescription = newDescription;
    }

    public String getServerDescription() {
        return this.serverDescription;
    }

    public void setHomeDirectory(File newRoot) {
        if (newRoot == null) {
            throw new IllegalArgumentException("newRoot == null");
        }
        if (!newRoot.exists()) {
            throw new IllegalArgumentException(newRoot + " does not exist");
        }
        if (!newRoot.isDirectory()) {
            throw new IllegalArgumentException(newRoot + " is not a directory");
        }
        this.homeDirectory = newRoot;
    }

    public File getHomeDirectory() {
        return this.homeDirectory;
    }

    public void setTrashDirectory(File newRoot) {
        if (newRoot == null) {
            throw new IllegalArgumentException("newRoot == null");
        }
        if (!newRoot.exists()) {
            throw new IllegalArgumentException(newRoot + " does not exist");
        }
        if (!newRoot.isDirectory()) {
            throw new IllegalArgumentException(newRoot + " is not a directory");
        }
        this.trashDirectory = newRoot;
    }

    public File getTrashDirectory() {
        return this.trashDirectory;
    }

    public void postFlatnews(String newPost) {
        if (newPost == null) {
            throw new IllegalArgumentException("newPost == null");
        }
        String oldNews = this.flatnews.get();
        this.flatnews.set(newPost + oldNews);
        HLProtocol.DataComponent[] dataComponents = new HLProtocol.DataComponent[]{hlp.new HLProtocol.DataComponent(101, newPost.getBytes())};
        this.realmTable.broadcastPacket(hlp.new HLProtocol.Packet(102, 0, dataComponents));
    }

    public void setFlatnews(HLServerFlatnews newFlatnews) {
        if (newFlatnews == null) {
            throw new IllegalArgumentException("newFlatnews == null");
        }
        this.flatnews = newFlatnews;
    }

    public HLServerFlatnews getFlatnews() {
        return this.flatnews;
    }

    public void setAccountsTable(HLServerAccountsTable newAccounts) {
        if (newAccounts == null) {
            throw new IllegalArgumentException("newAccounts == null");
        }
        this.accountsTable = newAccounts;
    }

    public HLServerAccountsTable getAccountsTable() {
        return this.accountsTable;
    }

    public HLServerBanTable getBanTable() {
        return this.banTable;
    }

    public void setBanTable(HLServerBanTable newBanTable) {
        if (newBanTable == null) {
            throw new IllegalArgumentException("newBanTable == null");
        }
        this.banTable = newBanTable;
    }

    public HLServerTrackerTable getTrackerTable() {
        return this.trackerTable;
    }

    public void setTrackerTable(HLServerTrackerTable newTrackerTable) {
        if (newTrackerTable == null) {
            throw new IllegalArgumentException("newTrackerTable == null");
        }
        this.trackerTable = newTrackerTable;
    }

    public void setHLServerPolicy(HLServerPolicy p) {
        if (this.hspSet) {
            throw new RuntimeException("attempt to call setHLServerPolicy twice");
        }
        if (p == null) {
            throw new IllegalArgumentException("p == null");
        }
        this.hspSet = true;
        this.hsp = p;
    }

    public HLServerPolicy getHLServerPolicy() {
        return this.hsp;
    }

    public void setHLServerListener(HLServerListener l) {
        if (this.hslSet) {
            throw new RuntimeException("attempt to call setHLServerListener twice");
        }
        if (l == null) {
            throw new IllegalArgumentException("l == null");
        }
        this.hslSet = true;
        this.hsl = l;
    }

    public void setAdministratorPassword(String pw) {
        this.administratorPassword = pw;
    }

    String getAdministratorPassword() {
        return this.administratorPassword;
    }

    public void setMaximumProtocolErrors(int newMaximumProtocolErrors) {
        this.maximumProtocolErrors = newMaximumProtocolErrors;
    }

    public int getMaximumProtocolErrors() {
        return this.maximumProtocolErrors;
    }

    public void setMaximumUsers(int newMaximumUsers) {
        if (newMaximumUsers <= 0 || newMaximumUsers >= 32000) {
            throw new IllegalArgumentException("maximum users must be 0 ... 32000 exclusive");
        }
        if (this.socketInUse != null && newMaximumUsers > this.socketInUse.length) {
            throw new IllegalArgumentException("sorry, cannot increase maximum users beyond initial setting");
        }
        this.maximumUsers = newMaximumUsers;
    }

    public int getMaximumUsers() {
        return this.maximumUsers;
    }

    public void setMaximumDownloads(int newMaximumDownloads) {
        this.maximumDownloads = newMaximumDownloads;
    }

    public int getMaximumDownloads() {
        return this.maximumDownloads;
    }

    public void setMaximumDownloadsPerUser(int newMaxDownloadsPerUser) {
        this.maximumDownloadsPerUser = newMaxDownloadsPerUser;
    }

    public int getMaximumDownloadsPerUser() {
        return this.maximumDownloadsPerUser;
    }

    public void setMaximumDownloadQueueSpots(int newDLQSpots) {
        this.maximumDownloadQueueSpots = newDLQSpots;
    }

    public int getMaximumDownloadQueueSpots() {
        return this.maximumDownloadQueueSpots;
    }

    public void setMaximumUploads(int newMaximumUploads) {
        this.maximumUploads = newMaximumUploads;
    }

    public int getMaximumUploads() {
        return this.maximumUploads;
    }

    public void setMaximumUploadsPerUser(int newMaxUploadsPerUser) {
        this.maximumUploadsPerUser = newMaxUploadsPerUser;
    }

    public int getMaximumUploadsPerUser() {
        return this.maximumUploadsPerUser;
    }

    public void setMaximumUploadQueueSpots(int newULQSpots) {
        this.maximumUploadQueueSpots = newULQSpots;
    }

    public int getUploadQueueSpots() {
        return this.maximumUploadQueueSpots;
    }

    public long getBanSeconds() {
        return this.banSeconds;
    }

    public void setBanSeconds(long seconds) {
        this.banSeconds = seconds;
    }

    public void setPort(int newPort) {
        if (newPort < 0) {
            throw new IllegalArgumentException("port must be positive");
        }
        this.port = newPort;
    }

    public int getPort() {
        return this.port;
    }

    public void setAddress(InetAddress newAddress) {
        this.address = newAddress;
    }

    public InetAddress getAddress() {
        return this.address;
    }

    public void setAgreement(HLServerAgreement newAgreement) {
        this.agreement = newAgreement;
    }

    public HLServerAgreement getAgreement() {
        return this.agreement;
    }

    public void shutdown(String message) {
        this.log("Server shutting down" + (message == null ? "" : ": " + message));
        if (message != null) {
            HLProtocol.DataComponent[] dataComponents = new HLProtocol.DataComponent[]{hlp.new HLProtocol.DataComponent(101, message.getBytes())};
            this.getRealmTable().broadcastPacket(hlp.new HLProtocol.Packet(104, 0, dataComponents));
            try {
                Thread.currentThread();
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        this.serverIsRunning = false;
        try {
            if (this.socket != null) {
                this.socket.close();
                this.socket = null;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (this.transferSocket != null) {
                this.transferSocket.close();
                this.transferSocket = null;
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            if (this.hsm != null) {
                this.hsm.interrupt();
                this.hsm.join();
                this.hsm = null;
            }
        }
        catch (InterruptedException e) {
            DebuggerOutput.stackTrace(e);
        }
        try {
            this.transferServer.interrupt();
            DebuggerOutput.debug("joining transfer server");
            this.transferServer.join();
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        HLServerDispatcher[] clients = this.getClients();
        int i = 0;
        while (i < clients.length) {
            HLServerDispatcher hsd = clients[i];
            DebuggerOutput.debug("SHUTDOWN: Killing dispatcher " + hsd);
            hsd.disconnect();
            try {
                DebuggerOutput.debug("SHUTDOWN: Waiting for dispatcher to die ... " + hsd);
                hsd.join();
            }
            catch (InterruptedException _e) {
                // empty catch block
            }
            ++i;
        }
        this.log("Server shut down complete.");
    }

    public void listen() throws Exception {
        block15: {
            this.uptime = System.currentTimeMillis();
            this.connectionCounter = 0;
            this.connectionPeak = 0;
            this.uploadCounter = 0;
            this.downloadCounter = 0;
            try {
                this.socketInUse = new short[this.maximumUsers];
                int i = 0;
                while (i < this.socketInUse.length) {
                    this.socketInUse[i] = -1;
                    ++i;
                }
                if (!this.serverIsRunning) {
                    this.socket = new ServerSocket(this.port, this.backlog, this.address);
                    this.transferSocket = new ServerSocket(this.port + 1, this.backlog, this.address);
                    this.serverIsRunning = true;
                    this.log("Server listening on " + (this.address == null ? "all interfaces" : this.address.toString()) + ", port " + this.port + " (+2), " + this.maximumUsers + " maximum users.");
                    this.log("Home directory " + this.homeDirectory);
                    this.log("Max.          uploads /          downloads: " + TextUtils.prepadCharacter(new Integer(this.maximumUploads).toString(), 3, ' ') + " / " + TextUtils.prepadCharacter(new Integer(this.maximumDownloads).toString(), 3, ' '));
                    this.log("Max. uploads per user / downloads per user: " + TextUtils.prepadCharacter(new Integer(this.maximumUploadsPerUser).toString(), 3, ' ') + " / " + TextUtils.prepadCharacter(new Integer(this.maximumDownloadsPerUser).toString(), 3, ' '));
                    this.log("Max.     upload queue /     download queue: " + TextUtils.prepadCharacter(new Integer(this.maximumUploadQueueSpots).toString(), 3, ' ') + " / " + TextUtils.prepadCharacter(new Integer(this.maximumDownloadQueueSpots).toString(), 3, ' '));
                    this.transferServer = new HLTransferServer(this, this.transferSocket);
                    this.hsm = new HLServerMonitor(this);
                    this.hsl.serverReady();
                    while (this.serverIsRunning) {
                        try {
                            this.socket.setSoTimeout(5000);
                            Socket client = this.socket.accept();
                            client.setSoTimeout(2500);
                            client.setSoLinger(true, 5);
                            if (this.serverIsRunning) {
                                this.banTable.expire();
                                if (this.banTable.contains(client.getInetAddress())) {
                                    this.log("Client " + client.getInetAddress().toString() + " is on bantable, disconnecting.");
                                    try {
                                        client.close();
                                    }
                                    catch (IOException _e) {}
                                    continue;
                                }
                                HLServerDispatcher hsd = new HLServerDispatcher(this, client);
                                Vector vector = this.clients;
                                synchronized (vector) {
                                    ++this.connectionCounter;
                                    this.clients.addElement(hsd);
                                    if (this.clients.size() > this.connectionPeak) {
                                        this.connectionPeak = this.clients.size();
                                    }
                                }
                                hsd.start();
                                continue;
                            }
                            client.close();
                        }
                        catch (InterruptedIOException interruptedIOException) {
                            // empty catch block
                        }
                    }
                    break block15;
                }
                throw new RuntimeException("listen() called twice without calling shutdown() in between");
            }
            catch (Exception e) {
                DebuggerOutput.stackTrace(e);
                throw e;
            }
        }
    }

    public HLServerDispatcher[] getClients() {
        Object[] clientArray;
        Vector vector = this.clients;
        synchronized (vector) {
            clientArray = new HLServerDispatcher[this.clients.size()];
            this.clients.copyInto(clientArray);
        }
        return clientArray;
    }

    protected void removeClient(HLServerDispatcher client) {
        Vector vector = this.clients;
        synchronized (vector) {
            this.clients.removeElement(client);
        }
        this.transferQueue.stopTransfersForClient(client);
        HLProtocol.UserListComponent user = client.getUser();
        if (user.sock != -1) {
            this.releaseSocketID(user.sock);
            this.hsl.userLeft(client);
        }
    }

    protected synchronized short allocateSocketID() throws OutOfSocketIDsException {
        int availableSocket = -1;
        Vector vector = this.clients;
        synchronized (vector) {
            if (this.clients.size() > this.maximumUsers) {
                throw new OutOfSocketIDsException("too many connected users");
            }
        }
        DebuggerOutput.debug("HLServer.allocateSocketID: starting ...");
        DebuggerOutput.debug("HLServer.allocateSocketID: sorting ...");
        QuickSort.sort(this.socketInUse, 0, this.socketInUse.length - 1);
        DebuggerOutput.debug("HLServer.allocateSocketID: sorted.");
        if (this.socketInUse[0] == -1) {
            int i = 0;
            i = 0;
            while (i < this.socketInUse.length) {
                if (this.socketInUse[i] != -1) break;
                ++i;
            }
            if (i == this.socketInUse.length) {
                this.socketInUse[0] = this.socketCounter;
            } else {
                do {
                    int n_position = -1;
                    int n = i;
                    while (this.socketInUse.length < n && this.socketInUse[n] <= this.socketCounter) {
                        if (this.socketInUse[n] <= this.socketCounter) {
                            n_position = n;
                        }
                        ++n;
                    }
                    if (n_position == -1) {
                        this.socketInUse[0] = this.socketCounter;
                        continue;
                    }
                    int m_position = -1;
                    int m = this.socketInUse.length - 1;
                    while (m >= i && this.socketCounter <= this.socketInUse[m]) {
                        if (this.socketCounter <= this.socketInUse[m]) {
                            m_position = m;
                        }
                        --m;
                    }
                    if (m_position == i - 1) {
                        this.socketInUse[0] = this.socketCounter;
                        continue;
                    }
                    if ((short)(this.socketInUse[n_position] + 1) >= this.socketInUse[m_position]) continue;
                    this.socketInUse[0] = this.socketCounter = (short)(this.socketInUse[n_position] + 1);
                } while (this.socketInUse[0] == -1);
            }
            this.socketCounter = (short)(this.socketCounter + 1);
            if (this.socketCounter >= 32000) {
                this.socketCounter = 1;
            }
            this.realmTable.addUser("Public", this.socketInUse[0]);
            return this.socketInUse[0];
        }
        throw new OutOfSocketIDsException("maximum number of sockets already in use: " + this.maximumUsers);
    }

    protected synchronized void releaseSocketID(int sock) {
        if (sock < 1 || sock >= 32000) {
            throw new IllegalArgumentException("socket ID " + sock + " is out of range");
        }
        int i = 0;
        while (i < this.socketInUse.length) {
            if (this.socketInUse[i] == sock) {
                this.realmTable.removeUser(sock);
                this.socketInUse[i] = -1;
                return;
            }
            ++i;
        }
    }

    HLServerDispatcher resolveSocketID(int sock) {
        if (sock < 1 || sock >= 32000) {
            throw new IllegalArgumentException("socket ID " + sock + " is out of range");
        }
        Vector vector = this.clients;
        synchronized (vector) {
            Enumeration en = this.clients.elements();
            while (en.hasMoreElements()) {
                HLServerDispatcher client = (HLServerDispatcher)en.nextElement();
                if (client.sock != sock) continue;
                HLServerDispatcher hLServerDispatcher = client;
                return hLServerDispatcher;
            }
        }
        return null;
    }

    public void changeUserExcept(HLServerDispatcher client, short sock, String nick, short icon, short color) {
        try {
            this.changeUser(client, sock, nick, icon, color, "Public", 301, sock);
        }
        catch (InvalidRealmException e) {
            // empty catch block
        }
    }

    public void changeUser(HLServerDispatcher client, short sock, String nick, short icon, short color) {
        try {
            this.changeUser(client, sock, nick, icon, color, "Public", 301, -1);
        }
        catch (InvalidRealmException e) {
            // empty catch block
        }
    }

    public void changeUser(HLServerDispatcher client, short sock, String nick, short icon, short color, Object refObject, int type, int exceptSock) throws InvalidRealmException {
        HLProtocol.DataComponent[] dataComponents;
        if (client == null || nick == null) {
            throw new IllegalArgumentException("null argument");
        }
        Integer n = client.userStateLock;
        synchronized (n) {
            client.color = color;
            client.sock = sock;
            client.icon = icon;
            client.nick = nick;
            dataComponents = new HLProtocol.DataComponent[refObject.toString().equals("Public") ? 4 : 5];
            dataComponents[0] = hlp.new HLProtocol.DataComponent(103, ToArrayConverters.intToByteArray(sock));
            dataComponents[1] = hlp.new HLProtocol.DataComponent(104, ToArrayConverters.intToByteArray(icon));
            dataComponents[2] = hlp.new HLProtocol.DataComponent(102, nick.getBytes());
            dataComponents[3] = hlp.new HLProtocol.DataComponent(112, ToArrayConverters.intToByteArray(color));
            if (!refObject.toString().equals("Public")) {
                dataComponents[4] = hlp.new HLProtocol.DataComponent(114, ToArrayConverters.intToByteArray((Integer)refObject));
            }
        }
        this.realmTable.broadcastPacketExcept(refObject, hlp.new HLProtocol.Packet(type, 0, dataComponents), exceptSock);
        this.log(client.client.getInetAddress(), "now known as " + nick);
    }

    public String getUserInfo(int sock) {
        String info;
        HLServerDispatcher client = this.resolveSocketID(sock);
        if (client == null) {
            return null;
        }
        String lSep = System.getProperty("line.separator");
        Integer n = client.userStateLock;
        synchronized (n) {
            info = "Nick:    " + client.nick + lSep + "Login:   " + client.login + lSep + "From:    " + client.client.getInetAddress().getHostAddress() + lSep + "Since:   " + new Date(client.firstTransmissionTime) + lSep + "Elapsed: " + TimeFormat.format((System.currentTimeMillis() - client.firstTransmissionTime) / 1000L) + lSep + lSep;
        }
        String uploadsInProgress = "";
        String downloadsInProgress = "";
        String uploadsInQueue = "";
        String downloadsInQueue = "";
        Enumeration en = this.getTransferRequests();
        while (en.hasMoreElements()) {
            TransferRequest tr = (TransferRequest)en.nextElement();
            if (tr.client.sock != sock) continue;
            if (tr.queuePosition == 0) {
                String inProgress;
                if (!tr.lock) {
                    inProgress = " waiting ...     ";
                } else {
                    inProgress = TextUtils.prepad(BytesFormat.format(tr.totalSize), 7) + " (";
                    inProgress = tr.progressDone > 0L ? inProgress + TextUtils.prepad("" + (int)(100.0 * ((double)tr.progressDone / (double)tr.totalSize)), 2) : inProgress + "  0";
                    inProgress = inProgress + "%)  ";
                }
                inProgress = inProgress + tr.local.getFile().getName() + lSep;
                if (tr.type == 1) {
                    uploadsInProgress = uploadsInProgress + inProgress;
                    continue;
                }
                downloadsInProgress = downloadsInProgress + inProgress;
                continue;
            }
            String inQueue = "#" + TextUtils.prepadCharacter(new Integer(tr.queuePosition).toString(), 2, '0') + "  " + tr.local.getFile().getName() + lSep;
            if (tr.type == 1) {
                uploadsInQueue = uploadsInQueue + inQueue;
                continue;
            }
            downloadsInQueue = downloadsInQueue + inQueue;
        }
        info = info + "--- Downloads in progress" + lSep + lSep + downloadsInProgress + lSep;
        info = info + "--- Uploads in progress" + lSep + lSep + uploadsInProgress + lSep;
        info = info + "--- Downloads in queue" + lSep + lSep + downloadsInQueue + lSep;
        info = info + "--- Uploads in queue" + lSep + lSep + uploadsInQueue;
        return info;
    }

    public boolean kickUser(int sock, boolean ban) {
        if (sock < 1 || sock >= 32000) {
            throw new IllegalArgumentException("socket ID " + sock + " is out of range");
        }
        HLServerDispatcher[] clients = this.getClients();
        int i = 0;
        while (i < clients.length) {
            if (clients[i].getUser().sock == sock) {
                if ((clients[i].privileges & 0x10000L) != 65536L) {
                    if (ban) {
                        if (this.banSeconds == 0L) {
                            this.banTable.put(clients[i].client.getInetAddress(), 0L);
                        } else {
                            this.banTable.put(clients[i].client.getInetAddress(), this.banSeconds + System.currentTimeMillis() / 1000L);
                        }
                    }
                    clients[i].disconnect();
                    return true;
                }
                return false;
            }
            ++i;
        }
        return false;
    }

    public boolean sendPrivateMessage(HLServerDispatcher source, int sock, String msg) {
        if (msg == null || source == null || sock <= 0) {
            throw new IllegalArgumentException("incorrect parameter");
        }
        HLServerDispatcher client = this.resolveSocketID(sock);
        if (client != null) {
            HLProtocol.UserListComponent sender = source.getUser();
            HLProtocol.DataComponent[] dataComponents = new HLProtocol.DataComponent[]{hlp.new HLProtocol.DataComponent(101, msg.getBytes()), hlp.new HLProtocol.DataComponent(103, ToArrayConverters.intToByteArray(sender.sock)), hlp.new HLProtocol.DataComponent(102, sender.nick.getBytes())};
            client.send(hlp.new HLProtocol.Packet(104, 0, dataComponents));
            return true;
        }
        return false;
    }

    RealmTable getRealmTable() {
        return this.realmTable;
    }

    public TransferQueue getTransferQueue() {
        return this.transferQueue;
    }

    public Enumeration getTransferRequests() {
        return this.transferQueue.getTransferRequests();
    }

    public void broadcastAdministratorMessage(String msg) {
        HLProtocol.DataComponent[] dataComponents = new HLProtocol.DataComponent[]{hlp.new HLProtocol.DataComponent(101, msg.getBytes())};
        this.getRealmTable().broadcastPacket(hlp.new HLProtocol.Packet(104, 0, dataComponents));
    }

    public void log(InetAddress address, String msg) {
        this.log("[" + TextUtils.prepad(address.getHostAddress(), 14) + "] " + msg);
    }

    public void log(String msg) {
        this.hsl.logLine(msg);
    }

    class RealmTable {
        HLServer hls;
        Hashtable realms;

        RealmTable(HLServer h) {
            this.hls = h;
            this.realms = new Hashtable();
            this.realms.put("Public", new Realm("Public", "No subject."));
        }

        /*
         * Unable to fully structure code
         */
        synchronized Object createRealm(short sock) {
            refObject = null;
            unique = false;
            if (sock >= 1 && sock < 32000) ** GOTO lbl7
            throw new IllegalArgumentException("socket ID " + sock + " is out of range");
lbl-1000:
            // 1 sources

            {
                refObject = new Integer(HLServer.this.randomGenerator.nextInt());
                v0 = unique = this.realms.containsKey(refObject) == false;
lbl7:
                // 2 sources

                ** while (!unique)
            }
lbl8:
            // 1 sources

            this.realms.put(refObject, new Realm(refObject, "No subject."));
            this.addUser(refObject, sock);
            return refObject;
        }

        synchronized boolean addUser(Object refObject, int sock) {
            if (!this.realms.containsKey(refObject)) {
                return false;
            }
            ((Realm)this.realms.get(refObject)).addUser(sock);
            return true;
        }

        synchronized HLProtocol.UserListComponent[] getUsers(Object refObject) throws InvalidRealmException {
            if (!this.realms.containsKey(refObject)) {
                throw new InvalidRealmException("no such realm: " + refObject);
            }
            Realm realm = (Realm)this.realms.get(refObject);
            HLProtocol.UserListComponent[] userList = new HLProtocol.UserListComponent[realm.users.size()];
            int i = 0;
            while (i < userList.length) {
                userList[i] = this.hls.resolveSocketID((Integer)realm.users.elementAt(i)).getUser();
                ++i;
            }
            return userList;
        }

        synchronized boolean removeUser(Object refObject, int sock) {
            if (!this.realms.containsKey(refObject)) {
                return false;
            }
            Realm realm = (Realm)this.realms.get(refObject);
            realm.removeUser(sock);
            if (refObject.toString().equals("Public")) {
                HLProtocol.DataComponent[] dataComponents = new HLProtocol.DataComponent[]{hlp.new HLProtocol.DataComponent(103, ToArrayConverters.intToByteArray(sock))};
                this.broadcastPacket(hlp.new HLProtocol.Packet(302, 0, dataComponents));
            } else {
                try {
                    if (realm.users.size() == 0) {
                        this.destroyRealm(refObject);
                        realm.refObject = null;
                    } else {
                        HLProtocol.DataComponent[] dataComponents = new HLProtocol.DataComponent[]{hlp.new HLProtocol.DataComponent(114, ToArrayConverters.intToByteArray((Integer)refObject)), hlp.new HLProtocol.DataComponent(103, ToArrayConverters.intToByteArray(sock))};
                        this.broadcastPacket(refObject, hlp.new HLProtocol.Packet(118, 0, dataComponents));
                    }
                }
                catch (InvalidRealmException e) {
                    // empty catch block
                }
            }
            return true;
        }

        synchronized void removeUser(int sock) {
            Integer socketID = new Integer(sock);
            Enumeration en = this.realms.elements();
            while (en.hasMoreElements()) {
                Realm realm = (Realm)en.nextElement();
                if (!realm.users.contains(socketID)) continue;
                this.removeUser(realm.refObject, sock);
            }
        }

        private synchronized void destroyRealm(Object refObject) {
            if (!this.realms.containsKey(refObject)) {
                throw new IllegalArgumentException("no such realm: " + refObject);
            }
            Realm realm = (Realm)this.realms.get(refObject);
            if (realm.users.size() > 0) {
                throw new IllegalArgumentException("realm " + refObject + " cannot be destroyed because it still contains users.");
            }
            this.realms.remove(refObject);
        }

        synchronized void broadcastPacket(Object refObject, HLProtocol.Packet packet) throws InvalidRealmException {
            this._broadcastPacket(refObject, packet, -1);
        }

        synchronized void broadcastPacketExcept(Object refObject, HLProtocol.Packet packet, int exceptSock) throws InvalidRealmException {
            this._broadcastPacket(refObject, packet, exceptSock);
        }

        void broadcastPacket(HLProtocol.Packet packet) {
            try {
                this._broadcastPacket("Public", packet, -1);
            }
            catch (InvalidRealmException invalidRealmException) {
                // empty catch block
            }
        }

        void broadcastPacketExcept(HLProtocol.Packet packet, int exceptSock) {
            try {
                this._broadcastPacket("Public", packet, exceptSock);
            }
            catch (InvalidRealmException invalidRealmException) {
                // empty catch block
            }
        }

        private void _broadcastPacket(Object refObject, HLProtocol.Packet packet, int exceptSock) throws InvalidRealmException {
            if (!this.realms.containsKey(refObject)) {
                throw new InvalidRealmException("no such realm: " + refObject);
            }
            Realm realm = (Realm)this.realms.get(refObject);
            Enumeration en = realm.users.elements();
            while (en.hasMoreElements()) {
                HLServerDispatcher client = HLServer.this.resolveSocketID((Integer)en.nextElement());
                if (client == null || client.sock == exceptSock) continue;
                packet.header.trans = client.nextTrans();
                client.send(packet);
            }
        }

        class Realm {
            Object refObject;
            Vector users;
            String subject;

            private Realm(Object refObject, String subject) {
                this.refObject = refObject;
                this.subject = subject;
                this.users = new Vector();
            }

            public void addUser(int sock) {
                if (sock < 1 || sock >= 32000) {
                    throw new IllegalArgumentException("socket ID " + sock + " is out of range");
                }
                if (this.users.contains(new Integer(sock))) {
                    throw new IllegalArgumentException("socket ID " + sock + " already in realm " + this.refObject);
                }
                this.users.addElement(new Integer(sock));
            }

            public void removeUser(int sock) {
                if (sock < 1 || sock >= 32000) {
                    throw new IllegalArgumentException("socket ID " + sock + " is out of range");
                }
                if (!this.users.contains(new Integer(sock))) {
                    throw new IllegalArgumentException("socket ID " + sock + " is not a member of this realm");
                }
                this.users.removeElement(new Integer(sock));
            }
        }
    }

    public class TransferRequest {
        public static final byte FILE_UPLOAD = 1;
        public static final byte FILE_DOWNLOAD = 2;
        public HLServerDispatcher client;
        public byte type;
        public int ref;
        public MacFile local;
        public boolean lock = false;
        public long totalSize;
        public long progressDone;
        public int queuePosition = 0;
        public boolean cancelled = false;
        TransferThread transferThread;
        long when = System.currentTimeMillis();
        boolean transferThreadNotified;
        HLProtocol.ResumeTransferComponent rflt;
        int forkOrFile;

        TransferRequest() {
        }

        public void cancel() {
            this.cancelled = true;
            if (this.transferThread != null) {
                this.transferThread.disconnect();
            }
        }

        public String toString() {
            return "TransferRequest[ref = " + this.ref + ", local = " + this.local + ", queuePos = " + this.queuePosition + ", type = " + this.type + ", lock = " + this.lock + ", total = " + this.totalSize + ", done = " + this.progressDone + ", cancelled = " + this.cancelled + "]";
        }
    }

    public class TransferQueue {
        Vector requests;
        Vector downloadQueueSpots;
        Vector uploadQueueSpots;
        HLServer hls;

        TransferQueue(HLServer h) {
            this.hls = h;
            this.requests = new Vector();
            this.downloadQueueSpots = new Vector();
            this.uploadQueueSpots = new Vector();
        }

        protected TransferRequest createUpload(HLServerDispatcher client, MacFile local) throws TooManyTransfersException {
            return this.create(client, (byte)1, local, null, 0);
        }

        protected TransferRequest createDownload(HLServerDispatcher client, MacFile local, HLProtocol.ResumeTransferComponent rflt, int forkOrFile) throws TooManyTransfersException {
            return this.create(client, (byte)2, local, rflt, forkOrFile);
        }

        private synchronized TransferRequest create(HLServerDispatcher client, byte type, MacFile local, HLProtocol.ResumeTransferComponent rflt, int forkOrFile) throws TooManyTransfersException {
            String what;
            int maximumQueueSpots;
            Vector queueSpots;
            int maximumPerUser;
            int inQueueForUser;
            int inProgressForUser;
            int maximum;
            int inQueue;
            int inProgress;
            if (local == null || type != 1 && type != 2) {
                throw new IllegalArgumentException("incorrect parameter");
            }
            if (type == 1) {
                inProgress = this.hls.uploadsInProgress;
                inQueue = this.hls.uploadsInQueue;
                maximum = this.hls.maximumUploads;
                inProgressForUser = client.uploadsInProgress;
                inQueueForUser = client.uploadsInQueue;
                maximumPerUser = this.hls.maximumUploadsPerUser;
                queueSpots = this.uploadQueueSpots;
                maximumQueueSpots = this.hls.maximumUploadQueueSpots;
                what = "upload";
            } else {
                inProgress = this.hls.downloadsInProgress;
                inQueue = this.hls.downloadsInQueue;
                maximum = this.hls.maximumDownloads;
                inProgressForUser = client.downloadsInProgress;
                inQueueForUser = client.downloadsInQueue;
                maximumPerUser = this.hls.maximumDownloadsPerUser;
                queueSpots = this.downloadQueueSpots;
                maximumQueueSpots = this.hls.maximumDownloadQueueSpots;
                what = "download";
            }
            TransferRequest transferRequest = new TransferRequest();
            if (inProgress >= maximum || inProgressForUser >= maximumPerUser) {
                Vector vector = queueSpots;
                synchronized (vector) {
                    if (queueSpots.size() >= maximumQueueSpots) {
                        throw new TooManyTransfersException("The maximum number of " + what + "s for this server has been reached, and the queue is full. Try again later.");
                    }
                    queueSpots.addElement(transferRequest);
                    transferRequest.queuePosition = queueSpots.size();
                }
            }
            int id = HLServer.this.randomGenerator.nextInt();
            boolean notUnique = true;
            block3: while (notUnique) {
                notUnique = false;
                Enumeration en = this.requests.elements();
                while (en.hasMoreElements()) {
                    TransferRequest tr = (TransferRequest)en.nextElement();
                    if (tr.ref != id) continue;
                    notUnique = true;
                    continue block3;
                }
            }
            if (type == 1) {
                ++HLServer.this.uploadCounter;
                if (transferRequest.queuePosition == 0) {
                    ++this.hls.uploadsInProgress;
                    ++client.uploadsInProgress;
                } else {
                    ++this.hls.uploadsInQueue;
                    ++client.uploadsInQueue;
                    this.hls.hsl.transferQueueStart(transferRequest);
                }
            } else {
                ++HLServer.this.downloadCounter;
                if (transferRequest.queuePosition == 0) {
                    ++this.hls.downloadsInProgress;
                    ++client.downloadsInProgress;
                } else {
                    ++this.hls.downloadsInQueue;
                    ++client.downloadsInQueue;
                }
            }
            transferRequest.transferThread = null;
            transferRequest.transferThreadNotified = false;
            transferRequest.client = client;
            transferRequest.local = local;
            transferRequest.rflt = rflt;
            transferRequest.forkOrFile = forkOrFile;
            transferRequest.ref = id;
            transferRequest.type = type;
            this.requests.addElement(transferRequest);
            if (transferRequest.queuePosition == 0) {
                this.hls.hsl.transferProgressStart(transferRequest);
            } else {
                this.hls.hsl.transferQueueStart(transferRequest);
            }
            return transferRequest;
        }

        protected synchronized TransferRequest get(int ref) {
            Enumeration en = this.requests.elements();
            while (en.hasMoreElements()) {
                TransferRequest tr = (TransferRequest)en.nextElement();
                if (tr.ref != ref) continue;
                if (tr.lock) {
                    throw new IllegalArgumentException("cannot process transfer ID " + ref + " because it is already being processed");
                }
                tr.lock = true;
                return tr;
            }
            throw new IllegalArgumentException(ref + " is not a valid transfer ID");
        }

        public synchronized void destroy(int ref) {
            Enumeration en = this.requests.elements();
            while (en.hasMoreElements()) {
                Vector queueSpots;
                TransferRequest tr = (TransferRequest)en.nextElement();
                DebuggerOutput.debug("TransferQueue.destroy: looking for " + ref + " in " + tr);
                if (tr.ref != ref) continue;
                DebuggerOutput.debug("TransferQueue.destroy: destroying " + tr.local.toString());
                if (tr.type == 1) {
                    queueSpots = this.uploadQueueSpots;
                    if (tr.queuePosition == 0) {
                        --this.hls.uploadsInProgress;
                        --tr.client.uploadsInProgress;
                        this.hls.hsl.transferProgressStop(tr);
                    } else {
                        --this.hls.uploadsInQueue;
                        --tr.client.uploadsInQueue;
                        this.hls.hsl.transferQueueStop(tr);
                    }
                } else {
                    queueSpots = this.downloadQueueSpots;
                    if (tr.queuePosition == 0) {
                        --this.hls.downloadsInProgress;
                        --tr.client.downloadsInProgress;
                        this.hls.hsl.transferProgressStop(tr);
                    } else {
                        --this.hls.downloadsInQueue;
                        --tr.client.downloadsInQueue;
                        this.hls.hsl.transferQueueStop(tr);
                    }
                }
                if (tr.queuePosition != 0) {
                    queueSpots.removeElement(tr);
                }
                if (queueSpots.size() > 0) {
                    int maximumPerUser;
                    int inProgressForUser;
                    int maximum;
                    int inProgress;
                    DebuggerOutput.debug("TransferQueue.destroy: reordering queue (size = " + queueSpots.size() + ")");
                    int i = 0;
                    while (i < queueSpots.size()) {
                        TransferRequest queueRequest = (TransferRequest)queueSpots.elementAt(i);
                        queueRequest.queuePosition = i + 1;
                        queueRequest.client.sendQueuePosition(queueRequest.ref, queueRequest.queuePosition);
                        ++i;
                    }
                    TransferRequest eligibleRequest = (TransferRequest)queueSpots.elementAt(0);
                    if (eligibleRequest.type == 1) {
                        inProgress = this.hls.uploadsInProgress;
                        maximum = this.hls.maximumUploads;
                        inProgressForUser = eligibleRequest.client.uploadsInProgress;
                        maximumPerUser = this.hls.maximumUploadsPerUser;
                    } else {
                        inProgress = this.hls.downloadsInProgress;
                        maximum = this.hls.maximumDownloads;
                        inProgressForUser = eligibleRequest.client.downloadsInProgress;
                        maximumPerUser = this.hls.maximumDownloadsPerUser;
                    }
                    if (inProgress < maximum && inProgressForUser < maximumPerUser) {
                        DebuggerOutput.debug("TransferQueue.destroy: eligible request is " + eligibleRequest.local.toString() + ", removing from queue");
                        queueSpots.removeElementAt(0);
                        int i2 = 0;
                        while (i2 < queueSpots.size()) {
                            TransferRequest queueRequest = (TransferRequest)queueSpots.elementAt(i2);
                            queueRequest.queuePosition = i2 + 1;
                            queueRequest.client.sendQueuePosition(queueRequest.ref, queueRequest.queuePosition);
                            ++i2;
                        }
                        if (!eligibleRequest.cancelled) {
                            eligibleRequest.queuePosition = 0;
                            if (eligibleRequest.type == 1) {
                                --this.hls.uploadsInQueue;
                                ++this.hls.uploadsInProgress;
                                --eligibleRequest.client.uploadsInQueue;
                                ++eligibleRequest.client.uploadsInProgress;
                                this.hls.hsl.transferQueueStop(eligibleRequest);
                                this.hls.hsl.transferProgressStart(eligibleRequest);
                            } else {
                                --this.hls.downloadsInQueue;
                                ++this.hls.downloadsInProgress;
                                --eligibleRequest.client.downloadsInQueue;
                                ++eligibleRequest.client.downloadsInProgress;
                                this.hls.hsl.transferQueueStop(eligibleRequest);
                                this.hls.hsl.transferProgressStart(eligibleRequest);
                            }
                            if (eligibleRequest.transferThread != null) {
                                eligibleRequest.transferThread.nextInLine();
                            }
                        }
                    }
                }
                try {
                    if (tr.local != null) {
                        tr.local.cleanup();
                        tr.local.close();
                    }
                }
                catch (IOException _e) {
                    // empty catch block
                }
                DebuggerOutput.debug("TransferQueue.destroy: removing " + tr + " from transfer list.");
                tr.client = null;
                tr.transferThread = null;
                tr.cancel();
                this.requests.removeElement(tr);
                return;
            }
            DebuggerOutput.debug("TransferQueue.destroy: " + ref + " is not a valid transfer ID");
        }

        public Enumeration getTransferRequests() {
            return this.requests.elements();
        }

        protected synchronized void expire() {
            Enumeration en = this.requests.elements();
            while (en.hasMoreElements()) {
                TransferRequest tr = (TransferRequest)en.nextElement();
                if (!tr.cancelled && (tr.lock || System.currentTimeMillis() - tr.when <= 60000L)) continue;
                HLServer.this.log("Expired transfer request " + tr);
                this.destroy(tr.ref);
            }
        }

        protected synchronized void stopTransfersForClient(HLServerDispatcher client) {
            Vector<Integer> v = new Vector<Integer>();
            Enumeration en = this.requests.elements();
            while (en.hasMoreElements()) {
                TransferRequest tr = (TransferRequest)en.nextElement();
                if (tr.client != client) continue;
                v.addElement(new Integer(tr.ref));
            }
            Enumeration en2 = v.elements();
            while (en2.hasMoreElements()) {
                this.destroy((Integer)en2.nextElement());
            }
            v.removeAllElements();
        }
    }
}

