/*
 * Decompiled with CFR 0.152.
 */
package redlight.hotline;

import java.io.File;
import java.io.IOException;
import redlight.crypto.UnixCrypt;
import redlight.hotline.DefaultPolicyObject;
import redlight.hotline.HLProtocol;
import redlight.hotline.HLServer;
import redlight.hotline.HLServerAccountsTable;
import redlight.hotline.HLServerDispatcher;
import redlight.macfiles.MacFile;
import redlight.macfiles.SplitMacFile;
import redlight.utils.DebuggerOutput;
import redlight.utils.QuickSort;
import redlight.utils.Sortable;
import redlight.utils.TextUtils;
import redlight.utils.TimeFormat;

public class HLServerPolicy {
    HLServer hls;

    public HLServerPolicy(HLServer h) {
        if (h == null) {
            throw new IllegalArgumentException("h == null");
        }
        this.hls = h;
    }

    public static Object createPolicyObject() {
        return new DefaultPolicyObject();
    }

    public boolean isAuthenticated(HLServerDispatcher client) {
        return ((DefaultPolicyObject)client.policyObject).isAuthenticated;
    }

    public String approvePacket(HLServerDispatcher client, HLProtocol.Packet packet) {
        if (!this.isAuthenticated(client) && packet.header.id != 107) {
            return "Disconnecting client because an action of type 0x" + Integer.toHexString(packet.header.id) + " was attempted before login.";
        }
        if (((DefaultPolicyObject)client.policyObject).isNicknameThief && packet.header.id != 304) {
            return "Disconnecting client for nickname stealing.";
        }
        return null;
    }

    public String approveLogin(HLServerDispatcher client) {
        if (((DefaultPolicyObject)client.policyObject).isAuthenticated) {
            return "Disconnecting client because login request received while already logged in.";
        }
        return this.authenticate(client);
    }

    public String approveUserChange(HLServerDispatcher client, HLProtocol.UserListComponent state) {
        HLServerDispatcher[] clients = this.hls.getClients();
        int i = 0;
        while (i < clients.length) {
            Integer n = clients[i].userStateLock;
            synchronized (n) {
                if (client != clients[i] && clients[i].nick.equals(state.nick)) {
                    ((DefaultPolicyObject)client.policyObject).isNicknameThief = true;
                    String string = "You cannot change your nickname to look like someone else's nickname. Change your nickname NOW.";
                    return string;
                }
            }
            ++i;
        }
        return null;
    }

    public String approveUserKick(HLServerDispatcher client, int sock, boolean ban) {
        if ((client.privileges & 0x20000L) == 131072L) {
            return null;
        }
        return "You are not allowed to disconnect users.";
    }

    public String approveChat(HLServerDispatcher client, String chat, boolean isAction) {
        if ((client.privileges & 0x2000L) == 8192L) {
            return null;
        }
        return "You are not allowed to send chat.";
    }

    public String approveMessage(HLServerDispatcher sender, int sock, String message) {
        return null;
    }

    public String approveFlatnewsGet(HLServerDispatcher client) {
        if ((client.privileges & 0x80000L) == 524288L) {
            return null;
        }
        return "You are not allowed to read news.";
    }

    public String approveFlatnewsPost(HLServerDispatcher client, String newPost) {
        if ((client.privileges & 0x40000L) == 262144L) {
            return null;
        }
        return "You are not allowed to post news.";
    }

    public String approveAccountRead(HLServerDispatcher client, String login) {
        if ((client.privileges & 0x800000L) == 0x800000L) {
            return null;
        }
        return "You are not allowed to read accounts.";
    }

    public String approveAccountCreate(HLServerDispatcher client, HLProtocol.AccountInfo account) {
        if ((client.privileges & 0x200L) == 512L) {
            if (((client.privileges ^ 0xFFFFFFFFFFFFFFFFL) & account.privileges) == 0L) {
                return this.approveAccountCreate(account);
            }
            return "Cannot create an account to have more rights than you have.";
        }
        return "You are not allowed to create accounts.";
    }

    public String approveAccountCreate(HLProtocol.AccountInfo account) {
        return null;
    }

    public String approveAccountModify(HLServerDispatcher client, HLProtocol.AccountInfo oldAccount, HLProtocol.AccountInfo newAccount) {
        if ((client.privileges & 0x400000L) == 0x400000L) {
            if (((client.privileges ^ 0xFFFFFFFFFFFFFFFFL) & oldAccount.privileges) != 0L) {
                return "You cannot modify an account that is more powerful than yours.";
            }
            if (((client.privileges ^ 0xFFFFFFFFFFFFFFFFL) & newAccount.privileges) != 0L) {
                return "You cannot grant privileges that you do not have.";
            }
            return this.approveAccountModify(newAccount);
        }
        return "You are not allowed to modify accounts.";
    }

    public String approveAccountModify(HLProtocol.AccountInfo account) {
        return null;
    }

    public String approveAccountDelete(HLServerDispatcher client, HLProtocol.AccountInfo account) {
        if (((client.privileges ^ 0xFFFFFFFFFFFFFFFFL) & account.privileges) != 0L) {
            return "You cannot delete an account that is more powerful than yours.";
        }
        if ((client.privileges & 0x100L) == 256L) {
            return this.approveAccountDelete(account);
        }
        return "You are not allowed to delete accounts.";
    }

    public String approveAccountDelete(HLProtocol.AccountInfo account) {
        return null;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String approveDirectoryListing(HLServerDispatcher client, String path) {
        block15: {
            block17: {
                block16: {
                    block14: {
                        hostPath = null;
                        try {
                            try {
                                hostPath = this.resolvePath(client, path);
                                if (!hostPath.exists() || !hostPath.isDirectory()) {
                                    var4_4 = "There is no directory " + path;
                                    var8_6 = null;
                                    break block14;
                                }
                                if (path.toLowerCase().indexOf("drop box") == -1) break block15;
                                if ((client.privileges & 0x2000000L) == 0x2000000L) {
                                    var5_18 = null;
                                    break block16;
                                }
                                var6_20 = "You are not allowed to view drop boxes.";
                                break block17;
                            }
                            catch (IOException e) {
                                var5_19 = e.toString();
                                var8_10 = null;
                                try {
                                    if (hostPath == null) return var5_19;
                                    hostPath.close();
                                    return var5_19;
                                }
                                catch (IOException e) {
                                    // empty catch block
                                }
                                return var5_19;
                            }
                        }
                        catch (Throwable var7_21) {
                            var8_11 = null;
                            ** try [egrp 2[TRYBLOCK] [2 : 128->139)] { 
lbl33:
                            // 1 sources

                            if (hostPath == null) throw var7_21;
                            hostPath.close();
                            throw var7_21;
lbl36:
                            // 1 sources

                            catch (IOException e) {
                                // empty catch block
                            }
                            throw var7_21;
                        }
                    }
                    ** try [egrp 2[TRYBLOCK] [2 : 128->139)] { 
lbl41:
                    // 1 sources

                    if (hostPath == null) return var4_4;
                    hostPath.close();
                    return var4_4;
lbl44:
                    // 1 sources

                    catch (IOException e) {
                        // empty catch block
                    }
                    return var4_4;
                }
                var8_7 = null;
                ** try [egrp 2[TRYBLOCK] [2 : 128->139)] { 
lbl50:
                // 1 sources

                if (hostPath == null) return var5_18;
                hostPath.close();
                return var5_18;
lbl53:
                // 1 sources

                catch (IOException e) {
                    // empty catch block
                }
                return var5_18;
            }
            var8_8 = null;
            ** try [egrp 2[TRYBLOCK] [2 : 128->139)] { 
lbl59:
            // 1 sources

            if (hostPath == null) return var6_20;
            hostPath.close();
            return var6_20;
lbl62:
            // 1 sources

            catch (IOException e) {
                // empty catch block
            }
            return var6_20;
        }
        var8_9 = null;
        try {}
        catch (IOException e) {}
        if (hostPath == null) return null;
        hostPath.close();
        return null;
        return null;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String approveFileDownload(HLServerDispatcher client, String path, String file) {
        block15: {
            block14: {
                block13: {
                    if ((client.privileges & 32L) != 32L) {
                        return "You are not allowed to download files.";
                    }
                    hostPath = null;
                    try {
                        try {
                            hostPath = this.resolvePathOrPartial(client, path + file);
                            if (!hostPath.exists()) {
                                var5_5 = "You cannot download " + file + " because it is missing or temporarily unavailable.";
                                var9_7 = null;
                                break block13;
                            }
                            if (hostPath.isDirectory()) {
                                var6_17 = "You cannot download directories.";
                                break block14;
                            }
                            var7_19 = null;
                            break block15;
                        }
                        catch (IOException e) {
                            var6_18 = e.toString();
                            var9_10 = null;
                            try {
                                if (hostPath == null) return var6_18;
                                hostPath.close();
                                return var6_18;
                            }
                            catch (IOException e) {
                                // empty catch block
                            }
                            return var6_18;
                        }
                    }
                    catch (Throwable var8_20) {
                        var9_11 = null;
                        try {}
                        catch (IOException e) {
                            throw var8_20;
                        }
                        if (hostPath == null) throw var8_20;
                        hostPath.close();
                        throw var8_20;
                    }
                }
                ** try [egrp 2[TRYBLOCK] [2 : 138->151)] { 
lbl41:
                // 1 sources

                if (hostPath == null) return var5_5;
                hostPath.close();
                return var5_5;
lbl44:
                // 1 sources

                catch (IOException e) {
                    // empty catch block
                }
                return var5_5;
            }
            var9_8 = null;
            ** try [egrp 2[TRYBLOCK] [2 : 138->151)] { 
lbl50:
            // 1 sources

            if (hostPath == null) return var6_17;
            hostPath.close();
            return var6_17;
lbl53:
            // 1 sources

            catch (IOException e) {
                // empty catch block
            }
            return var6_17;
        }
        var9_9 = null;
        ** try [egrp 2[TRYBLOCK] [2 : 138->151)] { 
lbl59:
        // 1 sources

        if (hostPath == null) return var7_19;
        hostPath.close();
        return var7_19;
lbl62:
        // 1 sources

        catch (IOException e) {
            // empty catch block
        }
        return var7_19;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String approveFileUpload(HLServerDispatcher client, String path, String file, boolean resume) {
        block30: {
            block29: {
                block28: {
                    block27: {
                        block25: {
                            if ((client.privileges & 64L) != 64L) {
                                return "You are not allowed to upload files.";
                            }
                            hostPath = null;
                            try {
                                try {
                                    hostPath = this.resolvePath(client, path + file, true);
                                    if (hostPath.exists() || hostPath.isDirectory()) {
                                        var6_6 = "Can't upload " + file + " because a file or directory by that name already exists.";
                                        var13_8 = null;
                                        break block25;
                                    }
                                    if (!resume) {
                                        block26: {
                                            tempFile = null;
                                            try {
                                                tempFile = this.resolvePath(client, path + file + ".hpf", true);
                                                if (!tempFile.exists() && !tempFile.isDirectory()) break block26;
                                                var8_24 = "Can't upload " + file + "; to resume a partially completed transfer, try reloading the file view, then uploading the file again.";
                                                var10_26 = null;
                                            }
                                            catch (Throwable var9_32) {
                                                var10_28 = null;
                                                try {
                                                    if (tempFile == null) throw var9_32;
                                                    tempFile.close();
                                                    throw var9_32;
                                                }
                                                catch (IOException e) {
                                                    // empty catch block
                                                }
                                                throw var9_32;
                                            }
                                            try {}
                                            catch (IOException e) {
                                                break block27;
                                            }
                                            if (tempFile != null) {
                                                tempFile.close();
                                            }
                                            break block27;
                                        }
                                        var10_27 = null;
                                        try {}
                                        catch (IOException e) {}
                                        if (tempFile != null) {
                                            tempFile.close();
                                        }
                                    }
                                    if (path.toLowerCase().indexOf("upload") == -1 && path.toLowerCase().indexOf("drop box") == -1) {
                                        if ((client.privileges & 0x40000000L) == 0x40000000L) {
                                            var7_22 = null;
                                            break block28;
                                        }
                                        var8_25 = "You are only allowed to upload to 'Uploads' folders and drop boxes.";
                                        break block29;
                                    }
                                    var7_22 = null;
                                    break block30;
                                }
                                catch (IOException e) {
                                    var7_23 = e.toString();
                                    var13_13 = null;
                                    try {
                                        if (hostPath == null) return var7_23;
                                        hostPath.close();
                                        return var7_23;
                                    }
                                    catch (IOException e) {
                                        // empty catch block
                                    }
                                    return var7_23;
                                }
                            }
                            catch (Throwable var12_33) {
                                var13_14 = null;
                                try {}
                                catch (IOException e) {
                                    throw var12_33;
                                }
                                if (hostPath == null) throw var12_33;
                                hostPath.close();
                                throw var12_33;
                            }
                        }
                        ** try [egrp 4[TRYBLOCK] [4 : 312->325)] { 
lbl79:
                        // 1 sources

                        if (hostPath == null) return var6_6;
                        hostPath.close();
                        return var6_6;
lbl82:
                        // 1 sources

                        catch (IOException e) {
                            // empty catch block
                        }
                        return var6_6;
                    }
                    var13_9 = null;
                    ** try [egrp 4[TRYBLOCK] [4 : 312->325)] { 
lbl88:
                    // 1 sources

                    if (hostPath == null) return var8_24;
                    hostPath.close();
                    return var8_24;
lbl91:
                    // 1 sources

                    catch (IOException e) {
                        // empty catch block
                    }
                    return var8_24;
                }
                var13_10 = null;
                ** try [egrp 4[TRYBLOCK] [4 : 312->325)] { 
lbl97:
                // 1 sources

                if (hostPath == null) return var7_22;
                hostPath.close();
                return var7_22;
lbl100:
                // 1 sources

                catch (IOException e) {
                    // empty catch block
                }
                return var7_22;
            }
            var13_11 = null;
            ** try [egrp 4[TRYBLOCK] [4 : 312->325)] { 
lbl106:
            // 1 sources

            if (hostPath == null) return var8_25;
            hostPath.close();
            return var8_25;
lbl109:
            // 1 sources

            catch (IOException e) {
                // empty catch block
            }
            return var8_25;
        }
        var13_12 = null;
        ** try [egrp 4[TRYBLOCK] [4 : 312->325)] { 
lbl115:
        // 1 sources

        if (hostPath == null) return var7_22;
        hostPath.close();
        return var7_22;
lbl118:
        // 1 sources

        catch (IOException e) {
            // empty catch block
        }
        return var7_22;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String approveFileDelete(HLServerDispatcher client, String path, String file) {
        block20: {
            block19: {
                block18: {
                    block17: {
                        block16: {
                            hostPath = null;
                            try {
                                try {
                                    hostPath = this.resolvePathOrPartial(client, path + ':' + file);
                                    if (hostPath.isDirectory() && (client.privileges & 2L) != 2L) {
                                        var5_5 = "You are not allowed to delete folders.";
                                        var11_7 = null;
                                        break block16;
                                    }
                                    if ((client.privileges & 128L) != 128L) {
                                        var6_21 = "You are not allowed to delete files.";
                                        break block17;
                                    }
                                    if (!hostPath.exists()) {
                                        var7_23 = "Cannot delete " + file + " because the file or directory does not exist.";
                                        break block18;
                                    }
                                    if (!this.hls.getTrashDirectory().exists()) {
                                        var8_24 = "Cannot delete " + file + " because the trash directory does not exist. Contact the server administrator.";
                                        break block19;
                                    }
                                    var9_25 = null;
                                    break block20;
                                }
                                catch (IOException e) {
                                    var6_22 = e.toString();
                                    var11_12 = null;
                                    try {
                                        if (hostPath == null) return var6_22;
                                        hostPath.close();
                                        return var6_22;
                                    }
                                    catch (IOException e) {
                                        // empty catch block
                                    }
                                    return var6_22;
                                }
                            }
                            catch (Throwable var10_26) {
                                var11_13 = null;
                                try {}
                                catch (IOException e) {
                                    throw var10_26;
                                }
                                if (hostPath == null) throw var10_26;
                                hostPath.close();
                                throw var10_26;
                            }
                        }
                        ** try [egrp 2[TRYBLOCK] [2 : 210->223)] { 
lbl47:
                        // 1 sources

                        if (hostPath == null) return var5_5;
                        hostPath.close();
                        return var5_5;
lbl50:
                        // 1 sources

                        catch (IOException e) {
                            // empty catch block
                        }
                        return var5_5;
                    }
                    var11_8 = null;
                    ** try [egrp 2[TRYBLOCK] [2 : 210->223)] { 
lbl56:
                    // 1 sources

                    if (hostPath == null) return var6_21;
                    hostPath.close();
                    return var6_21;
lbl59:
                    // 1 sources

                    catch (IOException e) {
                        // empty catch block
                    }
                    return var6_21;
                }
                var11_9 = null;
                ** try [egrp 2[TRYBLOCK] [2 : 210->223)] { 
lbl65:
                // 1 sources

                if (hostPath == null) return var7_23;
                hostPath.close();
                return var7_23;
lbl68:
                // 1 sources

                catch (IOException e) {
                    // empty catch block
                }
                return var7_23;
            }
            var11_10 = null;
            ** try [egrp 2[TRYBLOCK] [2 : 210->223)] { 
lbl74:
            // 1 sources

            if (hostPath == null) return var8_24;
            hostPath.close();
            return var8_24;
lbl77:
            // 1 sources

            catch (IOException e) {
                // empty catch block
            }
            return var8_24;
        }
        var11_11 = null;
        ** try [egrp 2[TRYBLOCK] [2 : 210->223)] { 
lbl83:
        // 1 sources

        if (hostPath == null) return var9_25;
        hostPath.close();
        return var9_25;
lbl86:
        // 1 sources

        catch (IOException e) {
            // empty catch block
        }
        return var9_25;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String approveFileMove(HLServerDispatcher client, String source, String target) {
        block48: {
            block40: {
                block47: {
                    block39: {
                        block46: {
                            block38: {
                                block45: {
                                    block37: {
                                        block44: {
                                            block36: {
                                                block43: {
                                                    block35: {
                                                        sourceFile = null;
                                                        targetFile = null;
                                                        try {
                                                            try {
                                                                sourceFile = this.resolvePathOrPartial(client, source);
                                                                targetFile = this.resolvePathOrPartial(client, target);
                                                                if (sourceFile.isDirectory() && (client.privileges & 32768L) != 32768L) {
                                                                    var6_6 = "You are not allowed to move folders.";
                                                                    var13_8 = null;
                                                                    break block35;
                                                                }
                                                                if ((client.privileges & 8L) != 8L) {
                                                                    var7_24 = "You are not allowed to move files.";
                                                                    break block36;
                                                                }
                                                                if (!sourceFile.exists()) {
                                                                    var8_26 = "Cannot move " + source + " because the file or directory does not exist.";
                                                                    break block37;
                                                                }
                                                                if (!targetFile.exists()) {
                                                                    var9_27 = "Cannot move " + source + " because the destination directory does not exist.";
                                                                    break block38;
                                                                }
                                                                if (!targetFile.isDirectory()) {
                                                                    var10_28 = "Cannot move " + source + " because the destination is not a directory.";
                                                                    break block39;
                                                                }
                                                                var11_29 = null;
                                                                break block40;
                                                            }
                                                            catch (IOException e) {
                                                                var7_25 = e.toString();
                                                                var13_14 = null;
                                                                try {
                                                                    if (sourceFile != null) {
                                                                        sourceFile.close();
                                                                    }
                                                                }
                                                                catch (IOException e) {
                                                                    // empty catch block
                                                                }
                                                                try {
                                                                    if (targetFile == null) return var7_25;
                                                                    targetFile.close();
                                                                    return var7_25;
                                                                }
                                                                catch (IOException e) {
                                                                    // empty catch block
                                                                }
                                                                return var7_25;
                                                            }
                                                        }
                                                        catch (Throwable var12_30) {
                                                            block42: {
                                                                var13_15 = null;
                                                                ** try [egrp 2[TRYBLOCK] [2 : 234->247)] { 
lbl53:
                                                                // 1 sources

                                                                if (sourceFile != null) {
                                                                    sourceFile.close();
                                                                }
                                                                break block42;
lbl56:
                                                                // 1 sources

                                                                catch (IOException e) {
                                                                    // empty catch block
                                                                }
                                                            }
                                                            try {}
                                                            catch (IOException e) {
                                                                throw var12_30;
                                                            }
                                                            if (targetFile == null) throw var12_30;
                                                            targetFile.close();
                                                            throw var12_30;
                                                        }
                                                    }
                                                    ** try [egrp 2[TRYBLOCK] [2 : 234->247)] { 
lbl67:
                                                    // 1 sources

                                                    if (sourceFile != null) {
                                                        sourceFile.close();
                                                    }
                                                    break block43;
lbl70:
                                                    // 1 sources

                                                    catch (IOException e) {
                                                        // empty catch block
                                                    }
                                                }
                                                ** try [egrp 3[TRYBLOCK] [3 : 249->262)] { 
lbl74:
                                                // 1 sources

                                                if (targetFile == null) return var6_6;
                                                targetFile.close();
                                                return var6_6;
lbl77:
                                                // 1 sources

                                                catch (IOException e) {
                                                    // empty catch block
                                                }
                                                return var6_6;
                                            }
                                            var13_9 = null;
                                            ** try [egrp 2[TRYBLOCK] [2 : 234->247)] { 
lbl83:
                                            // 1 sources

                                            if (sourceFile != null) {
                                                sourceFile.close();
                                            }
                                            break block44;
lbl86:
                                            // 1 sources

                                            catch (IOException e) {
                                                // empty catch block
                                            }
                                        }
                                        ** try [egrp 3[TRYBLOCK] [3 : 249->262)] { 
lbl90:
                                        // 1 sources

                                        if (targetFile == null) return var7_24;
                                        targetFile.close();
                                        return var7_24;
lbl93:
                                        // 1 sources

                                        catch (IOException e) {
                                            // empty catch block
                                        }
                                        return var7_24;
                                    }
                                    var13_10 = null;
                                    ** try [egrp 2[TRYBLOCK] [2 : 234->247)] { 
lbl99:
                                    // 1 sources

                                    if (sourceFile != null) {
                                        sourceFile.close();
                                    }
                                    break block45;
lbl102:
                                    // 1 sources

                                    catch (IOException e) {
                                        // empty catch block
                                    }
                                }
                                ** try [egrp 3[TRYBLOCK] [3 : 249->262)] { 
lbl106:
                                // 1 sources

                                if (targetFile == null) return var8_26;
                                targetFile.close();
                                return var8_26;
lbl109:
                                // 1 sources

                                catch (IOException e) {
                                    // empty catch block
                                }
                                return var8_26;
                            }
                            var13_11 = null;
                            ** try [egrp 2[TRYBLOCK] [2 : 234->247)] { 
lbl115:
                            // 1 sources

                            if (sourceFile != null) {
                                sourceFile.close();
                            }
                            break block46;
lbl118:
                            // 1 sources

                            catch (IOException e) {
                                // empty catch block
                            }
                        }
                        ** try [egrp 3[TRYBLOCK] [3 : 249->262)] { 
lbl122:
                        // 1 sources

                        if (targetFile == null) return var9_27;
                        targetFile.close();
                        return var9_27;
lbl125:
                        // 1 sources

                        catch (IOException e) {
                            // empty catch block
                        }
                        return var9_27;
                    }
                    var13_12 = null;
                    ** try [egrp 2[TRYBLOCK] [2 : 234->247)] { 
lbl131:
                    // 1 sources

                    if (sourceFile != null) {
                        sourceFile.close();
                    }
                    break block47;
lbl134:
                    // 1 sources

                    catch (IOException e) {
                        // empty catch block
                    }
                }
                ** try [egrp 3[TRYBLOCK] [3 : 249->262)] { 
lbl138:
                // 1 sources

                if (targetFile == null) return var10_28;
                targetFile.close();
                return var10_28;
lbl141:
                // 1 sources

                catch (IOException e) {
                    // empty catch block
                }
                return var10_28;
            }
            var13_13 = null;
            ** try [egrp 2[TRYBLOCK] [2 : 234->247)] { 
lbl147:
            // 1 sources

            if (sourceFile != null) {
                sourceFile.close();
            }
            break block48;
lbl150:
            // 1 sources

            catch (IOException e) {
                // empty catch block
            }
        }
        ** try [egrp 3[TRYBLOCK] [3 : 249->262)] { 
lbl154:
        // 1 sources

        if (targetFile == null) return var11_29;
        targetFile.close();
        return var11_29;
lbl157:
        // 1 sources

        catch (IOException e) {
            // empty catch block
        }
        return var11_29;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String approveDirectoryCreate(HLServerDispatcher client, String path, String file) {
        block14: {
            block13: {
                if ((client.privileges & 4L) != 4L) {
                    return "You are not allowed to create directories.";
                }
                if (file.equals("..") != false) return "Sorry, that name is not allowed.";
                if (file.equals(".") != false) return "Sorry, that name is not allowed.";
                if (file.endsWith(".hpf") != false) return "Sorry, that name is not allowed.";
                if (file.startsWith(".")) {
                    if (file.endsWith(".rsrc") != false) return "Sorry, that name is not allowed.";
                    if (file.endsWith(".info")) {
                        return "Sorry, that name is not allowed.";
                    }
                }
                hostPath = null;
                try {
                    try {
                        hostPath = this.resolvePath(client, path + ':' + file, true);
                        if (hostPath.exists()) {
                            var5_5 = "Cannot create directory " + path + " because a file or directory by that name already exists.";
                            var8_7 = null;
                            break block13;
                        }
                        var6_15 = null;
                        break block14;
                    }
                    catch (IOException e) {
                        var6_16 = e.toString();
                        var8_9 = null;
                        try {
                            if (hostPath == null) return var6_16;
                            hostPath.close();
                            return var6_16;
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                        return var6_16;
                    }
                }
                catch (Throwable var7_17) {
                    var8_10 = null;
                    try {}
                    catch (IOException e) {
                        throw var7_17;
                    }
                    if (hostPath == null) throw var7_17;
                    hostPath.close();
                    throw var7_17;
                }
            }
            ** try [egrp 2[TRYBLOCK] [2 : 183->196)] { 
lbl44:
            // 1 sources

            if (hostPath == null) return var5_5;
            hostPath.close();
            return var5_5;
lbl47:
            // 1 sources

            catch (IOException e) {
                // empty catch block
            }
            return var5_5;
        }
        var8_8 = null;
        ** try [egrp 2[TRYBLOCK] [2 : 183->196)] { 
lbl53:
        // 1 sources

        if (hostPath == null) return var6_15;
        hostPath.close();
        return var6_15;
lbl56:
        // 1 sources

        catch (IOException e) {
            // empty catch block
        }
        return var6_15;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String approveFileGetInfo(HLServerDispatcher client, String path, String file) {
        block11: {
            block10: {
                hostPath = null;
                try {
                    try {
                        hostPath = this.resolvePathOrPartial(client, path + ':' + file);
                        if (!hostPath.exists()) {
                            var5_5 = "Cannot get info on " + path + ':' + file + " because that file or directory does not exist.";
                            var8_7 = null;
                            break block10;
                        }
                        var6_15 = null;
                        break block11;
                    }
                    catch (IOException e) {
                        var6_16 = e.toString();
                        var8_9 = null;
                        try {
                            if (hostPath == null) return var6_16;
                            hostPath.close();
                            return var6_16;
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                        return var6_16;
                    }
                }
                catch (Throwable var7_17) {
                    var8_10 = null;
                    try {}
                    catch (IOException e) {
                        throw var7_17;
                    }
                    if (hostPath == null) throw var7_17;
                    hostPath.close();
                    throw var7_17;
                }
            }
            ** try [egrp 2[TRYBLOCK] [2 : 116->129)] { 
lbl35:
            // 1 sources

            if (hostPath == null) return var5_5;
            hostPath.close();
            return var5_5;
lbl38:
            // 1 sources

            catch (IOException e) {
                // empty catch block
            }
            return var5_5;
        }
        var8_8 = null;
        ** try [egrp 2[TRYBLOCK] [2 : 116->129)] { 
lbl44:
        // 1 sources

        if (hostPath == null) return var6_15;
        hostPath.close();
        return var6_15;
lbl47:
        // 1 sources

        catch (IOException e) {
            // empty catch block
        }
        return var6_15;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String approveFileSetInfo(HLServerDispatcher client, String path, String file, String newName, String newComment) {
        block32: {
            block31: {
                block30: {
                    block29: {
                        block28: {
                            block27: {
                                block26: {
                                    block25: {
                                        hostPath = null;
                                        try {
                                            try {
                                                hostPath = this.resolvePathOrPartial(client, path + ':' + file);
                                                if (!hostPath.exists()) {
                                                    var7_7 = "Cannot set info on " + file + " because that file or directory does not exist.";
                                                    var11_9 = null;
                                                    break block25;
                                                }
                                                if (hostPath.isDirectory()) {
                                                    if (newName != null && (client.privileges & 1L) != 1L) {
                                                        var8_29 = "You are not allowed to rename folders.";
                                                        break block26;
                                                    }
                                                    if (newComment != null && (client.privileges & 0x4000000L) != 0x4000000L) {
                                                        var9_34 = "You are not allowed to comment folders.";
                                                        break block27;
                                                    }
                                                } else {
                                                    if (newName != null && (client.privileges & 16L) != 16L) {
                                                        var8_30 = "You are not allowed to rename files.";
                                                        break block28;
                                                    }
                                                    if (newComment != null && (client.privileges & 0x8000000L) != 0x8000000L) {
                                                        var9_35 = "You are not allowed to comment files.";
                                                        break block29;
                                                    }
                                                }
                                                if (newName != null) {
                                                    if (newName.endsWith(".hpf")) {
                                                        var8_31 = "You are not allowed to create files with the .hpf extension .hpf.";
                                                        break block30;
                                                    }
                                                    if (newName.startsWith(".") && (newName.endsWith(".info") || newName.endsWith(".rsrc"))) {
                                                        var9_36 = "You are not allowed to create files with the .info and .rsrc extensions.";
                                                        break block31;
                                                    }
                                                }
                                                var8_32 = null;
                                                break block32;
                                            }
                                            catch (IOException e) {
                                                var8_33 = e.toString();
                                                var11_17 = null;
                                                try {
                                                    if (hostPath == null) return var8_33;
                                                    hostPath.close();
                                                    return var8_33;
                                                }
                                                catch (IOException e) {
                                                    // empty catch block
                                                }
                                                return var8_33;
                                            }
                                        }
                                        catch (Throwable var10_37) {
                                            var11_18 = null;
                                            try {}
                                            catch (IOException e) {
                                                throw var10_37;
                                            }
                                            if (hostPath == null) throw var10_37;
                                            hostPath.close();
                                            throw var10_37;
                                        }
                                    }
                                    ** try [egrp 2[TRYBLOCK] [2 : 296->309)] { 
lbl62:
                                    // 1 sources

                                    if (hostPath == null) return var7_7;
                                    hostPath.close();
                                    return var7_7;
lbl65:
                                    // 1 sources

                                    catch (IOException e) {
                                        // empty catch block
                                    }
                                    return var7_7;
                                }
                                var11_10 = null;
                                ** try [egrp 2[TRYBLOCK] [2 : 296->309)] { 
lbl71:
                                // 1 sources

                                if (hostPath == null) return var8_29;
                                hostPath.close();
                                return var8_29;
lbl74:
                                // 1 sources

                                catch (IOException e) {
                                    // empty catch block
                                }
                                return var8_29;
                            }
                            var11_11 = null;
                            ** try [egrp 2[TRYBLOCK] [2 : 296->309)] { 
lbl80:
                            // 1 sources

                            if (hostPath == null) return var9_34;
                            hostPath.close();
                            return var9_34;
lbl83:
                            // 1 sources

                            catch (IOException e) {
                                // empty catch block
                            }
                            return var9_34;
                        }
                        var11_12 = null;
                        ** try [egrp 2[TRYBLOCK] [2 : 296->309)] { 
lbl89:
                        // 1 sources

                        if (hostPath == null) return var8_30;
                        hostPath.close();
                        return var8_30;
lbl92:
                        // 1 sources

                        catch (IOException e) {
                            // empty catch block
                        }
                        return var8_30;
                    }
                    var11_13 = null;
                    ** try [egrp 2[TRYBLOCK] [2 : 296->309)] { 
lbl98:
                    // 1 sources

                    if (hostPath == null) return var9_35;
                    hostPath.close();
                    return var9_35;
lbl101:
                    // 1 sources

                    catch (IOException e) {
                        // empty catch block
                    }
                    return var9_35;
                }
                var11_14 = null;
                ** try [egrp 2[TRYBLOCK] [2 : 296->309)] { 
lbl107:
                // 1 sources

                if (hostPath == null) return var8_31;
                hostPath.close();
                return var8_31;
lbl110:
                // 1 sources

                catch (IOException e) {
                    // empty catch block
                }
                return var8_31;
            }
            var11_15 = null;
            ** try [egrp 2[TRYBLOCK] [2 : 296->309)] { 
lbl116:
            // 1 sources

            if (hostPath == null) return var9_36;
            hostPath.close();
            return var9_36;
lbl119:
            // 1 sources

            catch (IOException e) {
                // empty catch block
            }
            return var9_36;
        }
        var11_16 = null;
        ** try [egrp 2[TRYBLOCK] [2 : 296->309)] { 
lbl125:
        // 1 sources

        if (hostPath == null) return var8_32;
        hostPath.close();
        return var8_32;
lbl128:
        // 1 sources

        catch (IOException e) {
            // empty catch block
        }
        return var8_32;
    }

    public String approvePrivateChatCreate(HLServerDispatcher client, int sock) {
        return null;
    }

    public String approvePrivateChatJoin(HLServerDispatcher client, Object refObject) {
        return null;
    }

    public String approvePrivateChatInvite(HLServerDispatcher client, Object refObject, int sock) {
        return null;
    }

    public String approvePrivateChatSubject(HLServerDispatcher client, Object refObject, String subject) {
        return null;
    }

    public String approveUserGetInfo(HLServerDispatcher client, int sock) {
        DebuggerOutput.debug("approveUserGetInfo: client.privileges = " + client.privileges + ", HLProtocol.AccountInfo.CAN_GET_USER_INFO = " + 0x80000000L + ", client.privileges & HLProtocol.AccountInfo.CAN_GET_USER_INFO = " + (client.privileges & 0x80000000L));
        if ((client.privileges & 0x80000000L) == 0x80000000L) {
            return null;
        }
        return "You are not allowed to get user info.";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public HLProtocol.FileInfo obtainFileInfo(HLServerDispatcher client, String path, String file) throws IOException {
        HLProtocol.FileInfo fileInfo;
        MacFile hostPath = null;
        try {
            hostPath = this.resolvePathOrPartial(client, path + ':' + file);
            HLProtocol.FileInfo fileInfo2 = HLServer.hlp.new HLProtocol.FileInfo();
            fileInfo2.name = hostPath.getFile().getName();
            fileInfo2.comment = hostPath.getComment();
            fileInfo2.icon = hostPath.getType();
            fileInfo2.size = hostPath.length();
            fileInfo2.creator = hostPath.getCreator();
            fileInfo2.type = hostPath.getType();
            fileInfo2.created = hostPath.getCreationDate();
            fileInfo2.modified = hostPath.getModificationDate();
            fileInfo = fileInfo2;
            Object var8_7 = null;
            if (hostPath == null) return fileInfo;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            if (hostPath == null) throw throwable;
            try {
                hostPath.close();
                throw throwable;
            }
            catch (IOException e) {}
            throw throwable;
        }
        try {
            hostPath.close();
            return fileInfo;
        }
        catch (IOException e) {
            // empty catch block
        }
        return fileInfo;
    }

    /*
     * Loose catch block
     */
    public HLProtocol.FileListComponent[] obtainDirectoryListing(HLServerDispatcher client, String path) throws IOException {
        Sortable[] list;
        block30: {
            list = new HLProtocol.FileListComponent[]{};
            MacFile hostPath = null;
            hostPath = this.resolvePath(client, path);
            String[] hostList = hostPath.list();
            list = new HLProtocol.FileListComponent[hostList.length];
            int i = 0;
            while (i < hostList.length) {
                block29: {
                    DebuggerOutput.debug("obtainDirectoryListing: creating MacFile for " + hostList[i]);
                    MacFile f = null;
                    f = new SplitMacFile(new File(hostPath.getFile(), hostList[i]), new Integer(MacFile.READ_PERM));
                    String ft = f.getType();
                    String fc = f.getCreator();
                    int fs = 0;
                    if (f.isDirectory()) {
                        ft = new String("fldr");
                        fc = new String("\u0000\u0000\u0000\u0000");
                        String[] ftl = f.list();
                        fs = ftl.length;
                    } else {
                        fs = (int)f.length();
                        if (fs < 0) {
                            fs = 0;
                        }
                        if (f.getFile().getName().endsWith(".hpf")) {
                            hostList[i] = hostList[i].substring(0, hostList[i].length() - 4);
                        }
                    }
                    if (fc.length() != 4) {
                        this.hls.log("File creator for '" + hostList[i] + "' is bogus (" + fc + "), substituting ????.");
                        fc = "????";
                    }
                    if (ft.length() != 4) {
                        this.hls.log("File type for '" + hostList[i] + "' is bogus (" + ft + "), substituting ????.");
                        ft = "????";
                    }
                    HLProtocol.FileListComponent dh = HLServer.hlp.new HLProtocol.FileListComponent(hostList[i], ft, fc, fs, 0);
                    list[i] = dh;
                    Object var13_14 = null;
                    try {
                        if (f != null) {
                            f.close();
                        }
                        break block29;
                    }
                    catch (IOException e2) {}
                    break block29;
                    {
                        catch (IllegalArgumentException e) {
                            DebuggerOutput.stackTrace(e);
                            var13_14 = null;
                            try {
                                if (f != null) {
                                    f.close();
                                }
                                break block29;
                            }
                            catch (IOException e2) {}
                        }
                    }
                    catch (Throwable throwable) {
                        var13_14 = null;
                        try {
                            if (f != null) {
                                f.close();
                            }
                        }
                        catch (IOException e2) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                }
                ++i;
            }
            Object var16_17 = null;
            try {
                if (hostPath != null) {
                    hostPath.close();
                }
                break block30;
            }
            catch (IOException e3) {}
            break block30;
            {
                catch (IOException e) {
                    e.printStackTrace();
                    Object var16_18 = null;
                    try {
                        if (hostPath != null) {
                            hostPath.close();
                        }
                        break block30;
                    }
                    catch (IOException e3) {}
                }
            }
            catch (Throwable throwable) {
                Object var16_19 = null;
                try {
                    if (hostPath != null) {
                        hostPath.close();
                    }
                }
                catch (IOException e3) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        QuickSort.sort(list, 0, list.length - 1);
        return list;
    }

    public static String formatChat(HLServerDispatcher client, String chat, boolean isAction) {
        if (isAction) {
            return "\r *** " + new String(client.getUser().nick) + " " + chat;
        }
        String nick = TextUtils.prepad(new String(client.getUser().nick), 12);
        return "\r" + nick.substring(0, nick.length() > 13 ? 13 : nick.length()) + ":  " + chat;
    }

    public String formatFlatnewsPost(HLServerDispatcher client, String newPost) {
        return "---------- " + TimeFormat.formatCurrentDateTime(1, 2) + " [" + new String(client.getUser().nick) + "]" + " ----------\r \r" + newPost + "\r \r";
    }

    public MacFile resolvePath(HLServerDispatcher client, String path) throws IOException {
        return this.resolvePath(client, path, false);
    }

    public MacFile resolvePath(HLServerDispatcher client, String path, boolean writable) throws IOException {
        Integer perm = new Integer(writable ? MacFile.READ_PERM | MacFile.WRITE_PERM : MacFile.READ_PERM);
        path = TextUtils.findAndReplace(path, ":..", "");
        SplitMacFile hostPath = new SplitMacFile(new File(client.homeDirectory, TextUtils.findAndReplace(path, ":", System.getProperty("file.separator"))), perm);
        DebuggerOutput.debug("Hotline path '" + path + "' for client " + client + " resolves to host path '" + hostPath.toString() + "'.");
        return hostPath;
    }

    public MacFile resolvePathOrPartial(HLServerDispatcher client, String path) throws IOException {
        MacFile hostPath = this.resolvePath(client, path);
        if (!hostPath.exists()) {
            hostPath.close();
            hostPath = this.resolvePath(client, path + ".hpf");
            return hostPath;
        }
        return hostPath;
    }

    String authenticate(HLServerDispatcher client) {
        String authenticated = "Authentication failed.";
        try {
            HLServerAccountsTable accountsTable = this.hls.getAccountsTable();
            accountsTable.lock();
            DebuggerOutput.debug("Got login   : " + client.login);
            DebuggerOutput.debug("Got password: " + client.password);
            if (accountsTable.exists(client.login)) {
                String storedPassword = accountsTable.get((String)client.login).password;
                String salt = storedPassword.length() > 1 ? storedPassword.substring(0, 2) : "aa";
                DebuggerOutput.debug("Stored password: " + storedPassword);
                DebuggerOutput.debug("Got    password: " + UnixCrypt.crypt(salt, client.password));
                if (storedPassword.equals(UnixCrypt.crypt(salt, client.password))) {
                    ((DefaultPolicyObject)client.policyObject).isAuthenticated = true;
                    authenticated = null;
                    client.privileges = accountsTable.get((String)client.login).privileges;
                    if ((client.privileges & 0x20000L) == 131072L) {
                        client.color = (short)(client.color | 2);
                    }
                    if ((client.privileges & 0x20000000L) != 0x20000000L) {
                        client.nick = accountsTable.get((String)client.login).nick;
                    }
                    client.homeDirectory = accountsTable.get((String)client.login).homeDirectory;
                    if (client.homeDirectory == null) {
                        client.homeDirectory = this.hls.getHomeDirectory().getPath();
                    }
                }
            }
            accountsTable.unlock();
        }
        catch (InterruptedException _e) {
            this.hls.log(client.client.getInetAddress(), "[internal error] Disconnecting client because of a failure to acquire the account lock.");
            client.disconnect();
        }
        return authenticated;
    }
}

