/*
 * Decompiled with CFR 0.152.
 */
package redlight.hotline;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.Socket;
import redlight.hotline.HLProtocol;

public class HLTracker {
    InetAddress host;
    int port;

    public HLTracker(String server) throws IOException {
        this(InetAddress.getByName(server), 5498);
    }

    public HLTracker(InetAddress host) throws IOException {
        this(host, 5498);
    }

    public HLTracker(String server, int port) throws IOException {
        this(InetAddress.getByName(server), port);
    }

    public HLTracker(InetAddress h, int p) throws IOException {
        this.host = h;
        this.port = p;
    }

    /*
     * Unable to fully structure code
     */
    public HLProtocol.ServerInfo[] getServerList() throws IOException {
        hlp = new HLProtocol();
        socket = new Socket(this.host, this.port);
        output = new DataOutputStream(socket.getOutputStream());
        input = new DataInputStream(socket.getInputStream());
        output.writeBytes("HTRK\u0000\u0001");
        magic = new byte[6];
        input.read(magic, 0, 6);
        if (!new String(magic).equals("HTRK\u0000\u0001")) {
            throw new IOException("Bad magic, probably not a tracker.");
        }
        th = hlp.new HLProtocol.TrackerPacketHeader(input);
        servers = new HLProtocol.ServerInfo[th.nservers];
        nservers = th.nservers;
        i = 0;
        total = pack = th.pack;
        ** GOTO lbl25
        {
            servers[i++] = hlp.new HLProtocol.ServerInfo(input);
            nservers = (short)(nservers - 1);
            do {
                if (i < total && i < th.nservers) continue block0;
                if (nservers != 0) {
                    th = hlp.new HLProtocol.TrackerPacketHeader(input);
                    pack = th.pack;
                }
                total += pack;
lbl25:
                // 2 sources

            } while (nservers > 0);
        }
        socket.close();
        return servers;
    }

    public void sendServerInfo(int serverPort, String name, String description, short nusers, String password) throws IOException {
        if (name == null || description == null) {
            throw new IllegalArgumentException("null argument");
        }
        if (name.length() > 255) {
            name = name.substring(0, 255);
        }
        if (description.length() > 255) {
            description = description.substring(0, 255);
        }
        if (password != null && password.length() > 255) {
            password = password.substring(0, 255);
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream(500);
        DataOutputStream output = new DataOutputStream(bos);
        output.writeShort(1);
        output.writeShort((char)serverPort);
        output.writeShort(nusers);
        output.writeShort(0);
        output.writeInt(-270250752);
        output.writeByte(name.length());
        output.writeBytes(name);
        output.writeByte(description.length());
        output.writeBytes(description);
        if (password != null) {
            output.writeByte(password.length());
            output.writeBytes(password);
        } else {
            output.writeByte(0);
        }
        byte[] data = bos.toByteArray();
        DatagramSocket ds = new DatagramSocket();
        ds.send(new DatagramPacket(data, data.length, this.host, this.port));
        ds.close();
    }

    public InetAddress getInetAddress() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }
}

