/*
 * Decompiled with CFR 0.152.
 */
package redlight.macfiles;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.Calendar;
import redlight.macfiles.MacFile;
import redlight.macfiles.SplitFork;
import redlight.utils.DebuggerOutput;
import redlight.utils.TextUtils;

public class SplitMacFile
extends MacFile
implements FilenameFilter {
    File infoFile;

    public SplitMacFile(File f, Integer perms) throws IOException {
        super(f, perms);
        this.dataFork = new SplitFork(this, this.permissions, "data", "");
        this.resourceFork = new SplitFork(this, this.permissions, "rsrc", ".rsrc");
        this.infoFile = new File(this.getFile().getParent(), "." + this.getFile().getName() + ".info");
        this.readHeader();
    }

    public void readHeader() throws IOException {
        block27: {
            this.comment = "";
            if (!this.infoFile.exists()) {
                return;
            }
            try {
                LineNumberReader lr = new LineNumberReader(new FileReader(this.infoFile));
                boolean readComment = false;
                boolean readType = false;
                boolean readCreator = false;
                boolean readSection = false;
                boolean readFinderflags = false;
                boolean skipSection = false;
                String line = lr.readLine();
                while (line != null) {
                    if (line.startsWith("[")) {
                        skipSection = false;
                        readComment = false;
                        readType = false;
                        readCreator = false;
                        readFinderflags = false;
                        if (line.trim().toLowerCase().equals("[comment]")) {
                            readComment = true;
                        } else if (line.trim().toLowerCase().equals("[type]")) {
                            readType = true;
                        } else if (line.trim().toLowerCase().equals("[creator]")) {
                            readCreator = true;
                        } else if (line.trim().toLowerCase().equals("[finderflags]")) {
                            readFinderflags = true;
                        } else {
                            DebuggerOutput.debug("SplitMacFile.readHeader: warning: " + this.infoFile + ": Skipping unknown section '" + line + "'");
                            skipSection = true;
                        }
                    } else if (!skipSection) {
                        if (readComment) {
                            this.comment = this.comment + line + "\r";
                        } else if (readFinderflags) {
                            try {
                                this.finderFlags = Integer.parseInt(line);
                            }
                            catch (NumberFormatException e) {
                                DebuggerOutput.debug("SplitMacFile.readHeader: warning: section '" + this.finderFlags + "' contains garbage");
                            }
                            readFinderflags = false;
                        } else if (readType || readCreator) {
                            if (line.length() == 4) {
                                if (readType) {
                                    this.type = line;
                                } else if (readCreator) {
                                    this.creator = line;
                                }
                            } else {
                                DebuggerOutput.debug("SplitMacFile.readHeader: warning: " + this.infoFile + ": Type or creator has wrong size (must be 4 bytes)");
                                skipSection = true;
                            }
                            readType = false;
                            readCreator = false;
                        }
                    }
                    line = lr.readLine();
                }
                lr.close();
            }
            catch (IOException e) {
                if (!DebuggerOutput.on) break block27;
                e.printStackTrace();
            }
        }
    }

    public void writeHeader(String name, String type, String creator, String comments, Calendar created, Calendar modifed, int finderFlags) throws IOException {
        if (!(comments != null && !comments.trim().equals("") || type != null && !type.trim().equals("") || creator != null && !creator.trim().equals("") || finderFlags != 0)) {
            return;
        }
        FileWriter fw = new FileWriter(this.infoFile);
        DebuggerOutput.debug("SplitMacFile.writeHeader: fileWriter: " + fw);
        if (this.comment != null && !this.comment.trim().equals("")) {
            fw.write("[Comment]" + System.getProperty("line.separator"));
            fw.write(TextUtils.findAndReplace(comments, "\r", System.getProperty("line.separator")) + System.getProperty("line.separator"));
        }
        if (type != null && !type.trim().equals("")) {
            fw.write("[Type]" + System.getProperty("line.separator"));
            fw.write(type + System.getProperty("line.separator"));
        }
        if (creator != null && !creator.trim().equals("")) {
            fw.write("[Creator]" + System.getProperty("line.separator"));
            fw.write(creator + System.getProperty("line.separator"));
        }
        if (finderFlags != 0) {
            fw.write("[Finderflags]" + System.getProperty("line.separator"));
            fw.write(finderFlags + System.getProperty("line.separator"));
        }
        fw.close();
        this.comment = comments;
    }

    public void cleanup() throws IOException {
    }

    public void close() throws IOException {
        if (this.file.exists() && this.file.isDirectory()) {
            return;
        }
        this.resourceFork.close();
        this.dataFork.close();
    }

    public boolean exists() {
        if (this.file.exists() && this.file.isDirectory()) {
            return true;
        }
        return this.resourceFork.exists() | this.dataFork.exists();
    }

    public boolean delete() {
        return this.resourceFork.delete() | this.dataFork.delete();
    }

    public boolean renameTo(File f) {
        super.renameTo(f);
        this.infoFile.renameTo(new File(f.getParent(), "." + f.getName() + ".info"));
        this.infoFile = new File(f.getParent(), "." + f.getName() + ".info");
        if (this.file.exists() && this.file.isDirectory()) {
            if (this.file.renameTo(f)) {
                this.file = f;
                return true;
            }
            return false;
        }
        ((SplitFork)this.dataFork).renameTo(f);
        ((SplitFork)this.resourceFork).renameTo(new File(f.getParent(), "." + f.getName() + ".rsrc"));
        this.file = f;
        return true;
    }

    public long getDataSize() {
        return this.dataFork.size();
    }

    public long getResourceSize() {
        return this.resourceFork.size();
    }

    public String[] list() {
        String[] list = this.file.list(this);
        if (list != null) {
            int i = 0;
            while (i < list.length) {
                if (list[i].startsWith(".") && list[i].endsWith(".rsrc")) {
                    list[i] = list[i].substring(1, list[i].length() - 5);
                }
                ++i;
            }
        } else {
            list = new String[]{};
        }
        return list;
    }

    public boolean accept(File dir, String name) {
        File f = new File(dir, name);
        DebuggerOutput.debug("SplitMacFile.accept: accepting (default = deny): " + f);
        if (name.equals("..rsrc") || name.equals("..info")) {
            return false;
        }
        if (name.startsWith(".") && name.endsWith(".rsrc") && new File(dir, name.substring(1, name.length() - 5)).exists()) {
            return false;
        }
        if (name.startsWith(".") && name.endsWith(".info")) {
            return false;
        }
        if (!f.isDirectory() && f.length() == 0L) {
            return false;
        }
        DebuggerOutput.debug("SplitMacFile.accept: accepted " + f);
        return true;
    }
}

