/*
 * Decompiled with CFR 0.152.
 */
package redlight.rltools;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import redlight.hotline.HLException;
import redlight.rltools.Test2Thread;
import redlight.rltools.TestThread;
import redlight.utils.DebuggerOutput;

public class rltest {
    public static boolean verbose = false;
    static int numberOfThreads = 5;
    static int ONLINE_TIME_MAX = 10000;
    static int OFFLINE_TIME_MAX = 5000;
    static int numberOfLoops = 0;
    static int port = 5500;
    static int mode = 0;

    static void printUsage() {
        System.out.println("Usage: rltest [-v] [--debug] [-n nthreads] [-ut secs] [-dt secs] [-l numberOfLoops] [-p port] [-m mode] REMOTE");
        System.out.println("-v     verbose output");
        System.out.println("-n     number of threads");
        System.out.println("-ut    max uptime per thread");
        System.out.println("-dt    max downtime per thread");
        System.out.println("-p     port (default 5500)");
        System.out.println("-m     test mode (0 or 1)");
        System.out.println("-l     number of loops (0 = practically forever)");
        System.out.println("Examples:");
        System.out.println("rltest 24.132.4.80");
    }

    static InetAddress parseArg(String arg) throws IllegalArgumentException {
        DebuggerOutput.debug("parseArg: arg = " + arg);
        try {
            return InetAddress.getByName(arg);
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException("Unknown host: " + e.getMessage());
        }
    }

    static InetAddress[] parseArgs(String[] args, int offset) {
        InetAddress[] fl = new InetAddress[args.length - offset];
        int i = offset;
        while (i < args.length) {
            fl[i - offset] = rltest.parseArg(args[i]);
            ++i;
        }
        return fl;
    }

    static int parseOptions(String[] args) {
        int offset = 0;
        int maxOptions = 14;
        int i = 0;
        while (i < maxOptions && i < args.length) {
            if (args[i].equals("--debug")) {
                DebuggerOutput.setEnabled(true);
                ++offset;
            } else if (args[i].equals("-v")) {
                verbose = true;
                ++offset;
            } else if (args[i].equals("-p")) {
                port = Integer.parseInt(args[i + 1]);
                offset += 2;
            } else if (args[i].equals("-ut")) {
                ONLINE_TIME_MAX = Integer.parseInt(args[i + 1]) * 1000;
                offset += 2;
            } else if (args[i].equals("-dt")) {
                OFFLINE_TIME_MAX = Integer.parseInt(args[i + 1]) * 1000;
                offset += 2;
            } else if (args[i].equals("-n")) {
                numberOfThreads = Integer.parseInt(args[i + 1]);
                offset += 2;
            } else if (args[i].equals("-m")) {
                mode = Integer.parseInt(args[i + 1]);
                offset += 2;
            } else if (args[i].equals("-l")) {
                numberOfLoops = Integer.parseInt(args[i + 1]);
                offset += 2;
            }
            ++i;
        }
        return offset;
    }

    public static void main(String[] args) throws IOException, HLException, InterruptedException {
        block6: {
            ThreadGroup testers;
            InetAddress[] hosts;
            block5: {
                if (args.length < 1 || args.length > 15) {
                    rltest.printUsage();
                    System.exit(1);
                }
                int offset = rltest.parseOptions(args);
                hosts = null;
                try {
                    hosts = rltest.parseArgs(args, offset);
                }
                catch (IllegalArgumentException e) {
                    System.out.println("rltest: illegal argument: " + e.getMessage());
                    System.exit(1);
                }
                rltest.verboseln("no. threads = " + numberOfThreads);
                Thread[] threads = new Thread[numberOfThreads];
                testers = new ThreadGroup("Testers");
                if (mode != 0) break block5;
                int i = 0;
                while (i < numberOfThreads) {
                    threads[i] = new TestThread(testers, i, hosts[0], port, numberOfLoops);
                    ++i;
                }
                break block6;
            }
            if (mode != 1) break block6;
            int i = 0;
            while (i < numberOfThreads) {
                threads[i] = new Test2Thread(testers, i, hosts[0], port, numberOfLoops, i * ONLINE_TIME_MAX, numberOfThreads * OFFLINE_TIME_MAX - i * OFFLINE_TIME_MAX);
                ++i;
            }
        }
    }

    static void verbose(String s) {
        if (verbose) {
            System.out.print(s);
        }
    }

    static void verboseln(String s) {
        if (verbose) {
            System.out.println(s);
        }
    }

    static void verboseln() {
        if (verbose) {
            System.out.println();
        }
    }
}

