/*
 * Decompiled with CFR 0.152.
 */
package redlight.server;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import redlight.hotline.HLServer;
import redlight.hotline.HLServerFlatnews;
import redlight.server.Main;
import redlight.utils.DebuggerOutput;

public class Flatnews
extends HLServerFlatnews {
    File flatnewsFile;
    long lastModified;

    public Flatnews(HLServer h, File file) {
        super(h);
        this.flatnewsFile = file;
    }

    public void hasChanged() {
        this.write();
    }

    public void checkModified() {
        if (this.flatnewsFile.lastModified() != this.lastModified) {
            Main.logLine("Flat news file " + this.flatnewsFile.toString() + " changed, reloading.");
            this.load();
        }
    }

    public void load() {
        this.load(this.flatnewsFile);
        this.lastModified = this.flatnewsFile.lastModified();
    }

    public void load(InputStream in) {
        LineNumberReader lr = null;
        String n = "";
        try {
            lr = new LineNumberReader(new InputStreamReader(in));
            String line = lr.readLine();
            while (line != null) {
                if (line != null) {
                    n = n + line + "\r";
                }
                line = lr.readLine();
            }
        }
        catch (Exception e) {
            n = null;
            String error = "Error reading flat news file " + this.flatnewsFile.toString();
            if (lr != null) {
                error = error + " at line " + lr.getLineNumber();
            }
            error = error + " (" + e.toString() + ").";
            Main.logLine(error);
        }
        if (n != null) {
            this.news = n;
        }
    }

    public void write() {
        this.write(this.flatnewsFile);
    }

    public void write(OutputStream os) {
        DebuggerOutput.debug("Writing flatnews file, data = " + this.news);
        try {
            os.write(this.news.getBytes());
        }
        catch (IOException e) {
            Main.logLine("Could not write flat news file " + this.flatnewsFile.toString() + " (" + e.toString() + ").");
        }
    }
}

