/*
 * Decompiled with CFR 0.152.
 */
package redlight.server;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import redlight.crypto.UnixCrypt;
import redlight.hotline.HLProtocol;
import redlight.hotline.HLServer;
import redlight.server.AccountsTable;
import redlight.server.Agreement;
import redlight.server.BanTable;
import redlight.server.Console;
import redlight.server.Flatnews;
import redlight.server.Listener;
import redlight.server.Policy;
import redlight.server.SymbolTable;
import redlight.server.TrackerTable;
import redlight.utils.DebuggerOutput;
import redlight.utils.TimeFormat;

public class Main {
    static InetAddress address = null;
    static int port = 5500;
    static File accountsFile;
    static File logFile;
    static File flatnewsFile;
    static File agreementFile;
    static File banTableFile;
    static File trackerTableFile;
    static File homeDirectory;
    static File trashDirectory;
    static File serverRoot;
    static File initFile;
    static Agreement agreement;
    static AccountsTable accountsTable;
    static Flatnews flatnews;
    static BanTable banTable;
    static TrackerTable trackerTable;
    static Listener isl;
    static Policy isp;
    static Console console;
    static boolean shutdownInitiated;
    static HLServer hls;
    static HLProtocol hlp;
    static FileWriter logWriter;
    static String lSep;
    static SymbolTable symbolTable;
    static String copyright;
    static boolean DebugOutputEnabled;
    static final int EXIT_ARG_INVALID = 1;
    static final int EXIT_ACCOUNTS_INVALID = 2;
    static final int EXIT_LOGFILE_ACCESS = 3;

    static void parseArgs(String[] argv) {
        int i = 0;
        try {
            i = 0;
            while (i < argv.length) {
                if (argv[i].equals("-v") || argv[i].equals("--version")) {
                    Main.printVersion();
                    System.exit(0);
                } else if (argv[i].equals("-h") || argv[i].equals("--help")) {
                    Main.printUsage();
                    System.exit(0);
                } else if (argv[i].equals("-n") || argv[i].equals("--name")) {
                    symbolTable.internalPut("server.name", argv[i + 1]);
                    ++i;
                } else if (argv[i].equals("-d") || argv[i].equals("--description")) {
                    symbolTable.internalPut("server.description", argv[i + 1]);
                    ++i;
                } else if (argv[i].equals("-p") || argv[i].equals("--port")) {
                    port = Integer.parseInt(argv[i + 1]);
                    if (port < 0 || port > 65535) {
                        throw new IllegalArgumentException(argv[i] + " requires a number: 0 ... 65535");
                    }
                    ++i;
                } else if (argv[i].equals("--maxusers")) {
                    int maximumUsers = Integer.parseInt(argv[i + 1]);
                    if (!(maximumUsers >= 1 && maximumUsers <= 31999 || maximumUsers >= 0 && maximumUsers <= 65535)) {
                        throw new IllegalArgumentException(argv[i] + " requires a number: 1 ... 31999");
                    }
                    symbolTable.internalPut("server.maxusers", argv[i + 1]);
                    ++i;
                } else if (argv[i].equals("--maxul")) {
                    int maxUploads = Integer.parseInt(argv[i + 1]);
                    symbolTable.internalPut("server.maxul", argv[i + 1]);
                    ++i;
                } else if (argv[i].equals("--maxulperuser")) {
                    int maxUploadsPerUser = Integer.parseInt(argv[i + 1]);
                    symbolTable.internalPut("server.maxulperuser", argv[i + 1]);
                    ++i;
                } else if (argv[i].equals("--maxulqueue")) {
                    int maxULQueue = Integer.parseInt(argv[i + 1]);
                    symbolTable.internalPut("server.maxulqueue", argv[i + 1]);
                    ++i;
                } else if (argv[i].equals("--maxdl")) {
                    int maxDownloads = Integer.parseInt(argv[i + 1]);
                    symbolTable.internalPut("server.maxdl", argv[i + 1]);
                    ++i;
                } else if (argv[i].equals("--maxdlperuser")) {
                    int maxDownloadsPerUser = Integer.parseInt(argv[i + 1]);
                    symbolTable.internalPut("server.maxdlperuser", argv[i + 1]);
                    ++i;
                } else if (argv[i].equals("--maxdlqueue")) {
                    int maxDLQueue = Integer.parseInt(argv[i + 1]);
                    symbolTable.internalPut("server.maxdlqueue", argv[i + 1]);
                    ++i;
                } else if (argv[i].equals("-a") || argv[i].equals("--address")) {
                    address = InetAddress.getByName(argv[i + 1]);
                    ++i;
                } else if (argv[i].equals("--debug")) {
                    DebugOutputEnabled = true;
                    DebuggerOutput.setEnabled(true);
                } else if (argv[i].equals("--trackertablefile")) {
                    trackerTableFile = new File(argv[i + 1]);
                    ++i;
                } else if (argv[i].equals("--bantablefile")) {
                    banTableFile = new File(argv[i + 1]);
                    ++i;
                } else if (argv[i].equals("--agreementfile")) {
                    agreementFile = new File(argv[i + 1]);
                    ++i;
                } else if (argv[i].equals("--flatnewsfile")) {
                    flatnewsFile = new File(argv[i + 1]);
                    ++i;
                } else if (argv[i].equals("--accountsfile")) {
                    accountsFile = new File(argv[i + 1]);
                    ++i;
                } else if (argv[i].equals("--logfile")) {
                    logFile = new File(argv[i + 1]);
                    ++i;
                } else if (argv[i].equals("--homedir")) {
                    homeDirectory = new File(argv[i + 1]);
                    ++i;
                } else if (argv[i].equals("--trashdir")) {
                    trashDirectory = new File(argv[i + 1]);
                    ++i;
                } else if (argv[i].equals("--rootdir")) {
                    serverRoot = new File(argv[i + 1]);
                    ++i;
                } else if (argv[i].equals("--crypt")) {
                    System.out.println(UnixCrypt.crypt("aa", argv[i + 1]));
                    System.exit(0);
                    ++i;
                } else {
                    Main.printUsage();
                    System.exit(1);
                }
                ++i;
            }
        }
        catch (UnknownHostException e) {
            System.out.println("Invalid address: " + e.getMessage() + ".  Try --help.");
            System.exit(1);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            System.out.println(argv[i] + " requires parameter.  Try --help.");
            System.exit(1);
        }
        catch (Exception e) {
            System.out.println(e.getMessage() + ".  Try --help.");
            System.exit(1);
        }
    }

    static void printUsage() {
        Main.printVersion();
        String s = copyright + "Usage: rld [options]" + lSep + lSep + "Options:" + lSep + lSep + " -v, --version                display version information and exit" + lSep + " -h, --help                   show this message and exit" + lSep + " -n, --name NAME              set server name to NAME" + lSep + " -d, --description DESC       set server description to DESC" + lSep + " -p, --port PORT              listen on port PORT (0 ... 65535)" + lSep + " -a, --address ADDR           listen on address ADDR" + lSep + "     --maxusers NUM           maximum allowed users (1 ... 31999)" + lSep + "     --maxul NUM              maximum simultaneous uploads" + lSep + "     --maxdl NUM              maximum simultaneous downloads" + lSep + "     --maxulperuser NUM       maximum simultaneous uploads per user" + lSep + "     --maxdlperuser NUM       maximum simultaneous downloads per user" + lSep + "     --maxulqueue NUM         maximum uploads in queue" + lSep + "     --maxdlqueue NUM         maximum downloads in queue" + lSep + "     --rootdir DIR            use DIR as the server root" + lSep + "                              (default: " + serverRoot + ")" + lSep + "     --homedir DIR            use DIR as default home directory" + lSep + "                              (default: " + serverRoot + System.getProperty("file.separator") + "files)" + lSep + "     --trashdir DIR           use DIR as trash directory" + lSep + "                              (default: " + serverRoot + System.getProperty("file.separator") + "trash)" + lSep + "     --agreementfile FILE     use FILE as agreement file" + lSep + "     --flatnewsfile FILE      use FILE as flat news file" + lSep + "     --accountsfile FILE      use FILE as accounts database" + lSep + "     --bantablefile FILE      use FILE as bantable file" + lSep + "     --trackertablefile FILE  use FILE as trackertable file" + lSep + "     --logfile FILE           use FILE as logfile" + lSep + "     --crypt PWD              encrypt PWD for use in accounts file and exit" + lSep + "     --debug                  output lots of debugging information" + lSep;
        System.out.print(s);
    }

    static void printVersion() {
        System.out.print(Main.getVersionString());
    }

    static String getVersionString() {
        return "rld (experimental) / 25 october 2001" + lSep + "Options: " + "purejava 1.3 nosound" + lSep;
    }

    static void openLogFile() {
        try {
            logWriter = new FileWriter(logFile.toString(), true);
            logWriter.write(System.getProperty("line.separator"));
        }
        catch (IOException e) {
            System.out.println("Cannot open logfile for writing (" + logFile.toString() + ")");
            System.exit(3);
        }
    }

    static void logLine(String line) {
        String msg = TimeFormat.formatCurrentDateTime(3, 2) + ": " + line + lSep;
        if (logWriter == null) {
            System.out.println(msg);
        } else {
            try {
                logWriter.write(msg);
                FileWriter fileWriter = logWriter;
                synchronized (fileWriter) {
                    logWriter.flush();
                }
            }
            catch (NullPointerException e) {
                System.out.println(msg);
            }
            catch (IOException e) {
                e.printStackTrace();
                System.out.println("Fatal: cannot write to logfile.  Shutting down. Last message that could not be written:" + lSep + lSep + msg);
                logWriter = null;
                hls.shutdown("Fatal error: cannot write logfile.");
            }
        }
    }

    public static void init(String[] args) {
        symbolTable = new SymbolTable(hls);
        DebuggerOutput.setEnabled(false);
        serverRoot = new File(System.getProperty("user.home"), ".redlight");
        Main.parseArgs(args);
        if (!serverRoot.exists() && !serverRoot.mkdirs()) {
            System.out.println("Cannot create server root '" + serverRoot + "', exiting." + System.getProperty("line.separator") + "Check the access privileges for the directory, or use" + System.getProperty("line.separator") + "the --rootdir option to specify an alternative server root," + System.getProperty("line.separator") + "or try --help.");
        }
        String fSep = System.getProperty("file.separator");
        symbolTable.internalPut("server.rootdir", serverRoot.toString());
        symbolTable.internalPut("server.initfile", serverRoot.toString() + fSep + "rld.conf");
        symbolTable.internalPut("server.agreementfile", serverRoot.toString() + fSep + "agreement");
        symbolTable.internalPut("server.flatnewsfile", serverRoot.toString() + fSep + "flatnews");
        symbolTable.internalPut("server.accountsfile", serverRoot.toString() + fSep + "accounts");
        symbolTable.internalPut("server.logfile", serverRoot.toString() + fSep + "rld.log");
        symbolTable.internalPut("server.bantablefile", serverRoot.toString() + fSep + "bantable");
        symbolTable.internalPut("server.trackertablefile", serverRoot.toString() + fSep + "trackertable");
        symbolTable.internalPut("server.homedir", serverRoot.toString() + fSep + "files");
        symbolTable.internalPut("server.trashdir", serverRoot.toString() + fSep + "trash");
        if (initFile != null) {
            symbolTable.internalPut("server.initfile", initFile.toString());
        }
        if (agreementFile != null) {
            symbolTable.internalPut("server.agreementfile", agreementFile.toString());
        }
        if (flatnewsFile != null) {
            symbolTable.internalPut("server.flatnewsfile", flatnewsFile.toString());
        }
        if (accountsFile != null) {
            symbolTable.internalPut("server.accountsfile", accountsFile.toString());
        }
        if (logFile != null) {
            symbolTable.internalPut("server.logfile", logFile.toString());
        }
        if (banTableFile != null) {
            symbolTable.internalPut("server.bantablefile", banTableFile.toString());
        }
        if (trackerTableFile != null) {
            symbolTable.internalPut("server.trackertablefile", trackerTableFile.toString());
        }
        if (homeDirectory != null) {
            symbolTable.internalPut("server.homedir", homeDirectory.toString());
        }
        if (trashDirectory != null) {
            symbolTable.internalPut("server.trashdir", trashDirectory.toString());
        }
        initFile = new File(symbolTable.get("server.initfile"));
        agreementFile = new File(symbolTable.get("server.agreementfile"));
        flatnewsFile = new File(symbolTable.get("server.flatnewsfile"));
        accountsFile = new File(symbolTable.get("server.accountsfile"));
        logFile = new File(symbolTable.get("server.logfile"));
        banTableFile = new File(symbolTable.get("server.bantablefile"));
        trackerTableFile = new File(symbolTable.get("server.trackertablefile"));
        homeDirectory = new File(symbolTable.get("server.homedir"));
        trashDirectory = new File(symbolTable.get("server.trashdir"));
        if (!homeDirectory.exists() && !homeDirectory.mkdirs()) {
            System.out.println("Cannot create home directory '" + homeDirectory + "', exiting." + System.getProperty("line.separator") + "Check the access privileges for the directory, or use" + System.getProperty("line.separator") + "the --homedir option to specify an alternative home directory," + System.getProperty("line.separator") + "or try --help.");
        }
        if (!trashDirectory.exists() && !trashDirectory.mkdirs()) {
            System.out.println("Cannot create trash directory '" + trashDirectory + "', exiting." + System.getProperty("line.separator") + "Check the access privileges for the directory, or use" + System.getProperty("line.separator") + "the --trashdir option to specify an alternative trash directory," + System.getProperty("line.separator") + "or try --help.");
        }
        Main.openLogFile();
        hlp = new HLProtocol();
        isl = new Listener(hls);
        isp = new Policy(hls);
        accountsTable = new AccountsTable(hls, accountsFile);
        flatnews = new Flatnews(hls, flatnewsFile);
        agreement = new Agreement(hls, agreementFile);
        banTable = new BanTable(hls, banTableFile);
        trackerTable = new TrackerTable(hls, trackerTableFile);
        accountsTable.load();
        flatnews.load();
        agreement.load();
        banTable.load();
        trackerTable.load();
        Main.logLine("rld (experimental) / 25 october 2001.");
        Main.logLine("Bug reports to <groomed@users.sourceforge.net>.");
        Main.logLine("rld server root is " + serverRoot);
    }

    /*
     * Loose catch block
     */
    public static void main(String[] args) {
        block17: {
            block15: {
                hls = new HLServer();
                Main.init(args);
                hls.setHLServerPolicy(isp);
                hls.setHLServerListener(isl);
                hls.setAccountsTable(accountsTable);
                hls.setTrackerTable(trackerTable);
                hls.setBanTable(banTable);
                hls.setFlatnews(flatnews);
                hls.setAgreement(agreement);
                hls.setHomeDirectory(homeDirectory);
                hls.setTrashDirectory(trashDirectory);
                hls.setAddress(address);
                hls.setPort(port);
                hls.setServerName(symbolTable.get("server.name"));
                hls.setServerDescription(symbolTable.get("server.description"));
                hls.setBanSeconds(Integer.parseInt(symbolTable.get("server.maxbanseconds")));
                hls.setMaximumUsers(Integer.parseInt(symbolTable.get("server.maxusers")));
                hls.setMaximumUploads(Integer.parseInt(symbolTable.get("server.maxul")));
                hls.setMaximumUploadsPerUser(Integer.parseInt(symbolTable.get("server.maxulperuser")));
                hls.setMaximumUploadQueueSpots(Integer.parseInt(symbolTable.get("server.maxulqueue")));
                hls.setMaximumDownloads(Integer.parseInt(symbolTable.get("server.maxdl")));
                hls.setMaximumDownloadsPerUser(Integer.parseInt(symbolTable.get("server.maxdlperuser")));
                hls.setMaximumDownloadQueueSpots(Integer.parseInt(symbolTable.get("server.maxdlqueue")));
                hls.listen();
                Object var4_1 = null;
                if (console == null) break block15;
                console.interrupt();
                try {
                    console.join();
                }
                catch (InterruptedException _e) {
                    // empty catch block
                }
            }
            try {
                Thread.currentThread();
                Thread.sleep(1000L);
            }
            catch (InterruptedException e2) {
                // empty catch block
            }
            System.exit(0);
            {
                break block17;
                catch (Exception e) {
                    String reason = e.toString();
                    if (e.getMessage() != null) {
                        reason = e.getMessage();
                    }
                    Main.logLine("Server shut down: " + reason);
                    System.out.println("Server shut down (" + reason + ")");
                    DebuggerOutput.stackTrace(e);
                    Object var4_2 = null;
                    if (console != null) {
                        console.interrupt();
                        try {
                            console.join();
                        }
                        catch (InterruptedException _e) {
                            // empty catch block
                        }
                    }
                    try {
                        Thread.currentThread();
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e2) {
                        // empty catch block
                    }
                    System.exit(0);
                }
            }
            catch (Throwable throwable) {
                Object var4_3 = null;
                if (console != null) {
                    console.interrupt();
                    try {
                        console.join();
                    }
                    catch (InterruptedException _e) {
                        // empty catch block
                    }
                }
                try {
                    Thread.currentThread();
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e2) {
                    // empty catch block
                }
                System.exit(0);
                throw throwable;
            }
        }
    }

    static {
        console = null;
        shutdownInitiated = false;
        hls = null;
        logWriter = null;
        lSep = System.getProperty("line.separator");
        copyright = lSep + "rld (C) 1998 - 2001 Pascal Haakmat <groomed@users.sourceforge.net>" + lSep + "rld is free software, covered by the GNU General Public License." + lSep + "Modification and redistribution are encouraged. No warranty." + lSep + lSep;
        DebugOutputEnabled = false;
    }
}

