/*
 * Decompiled with CFR 0.152.
 */
package redlight.utils;

import java.text.NumberFormat;

public class BytesFormat {
    static long KB = 1024L;
    static long MB = 1024L * KB;
    static long GB = 1024L * MB;

    public static long parse(String size) {
        if (size.startsWith("<")) {
            size = size.substring(1);
        }
        byte[] s = size.getBytes();
        String number = size.substring(0, size.length() - 1);
        if (s[s.length - 1] == 71) {
            return (int)(new Float(number).floatValue() * (float)GB);
        }
        if (s[s.length - 1] == 77) {
            return (int)(new Float(number).floatValue() * (float)MB);
        }
        if (s[s.length - 1] == 75) {
            return (int)(new Float(number).floatValue() * (float)KB);
        }
        return Long.parseLong(size);
    }

    public static String format(long bytes) {
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMaximumFractionDigits(2);
        if (bytes / 0x40000000L >= 1L) {
            return nf.format((double)bytes / (double)GB) + "G";
        }
        if (bytes / 0x100000L >= 1L) {
            return nf.format((double)bytes / (double)MB) + "M";
        }
        if (bytes / 1024L >= 1L) {
            return nf.format((double)bytes / (double)KB) + "K";
        }
        if (bytes < 1024L) {
            return "<1K";
        }
        return new String(new Long(bytes).toString());
    }
}

