/*
 * Decompiled with CFR 0.152.
 */
package redlight.utils;

import redlight.utils.DebuggerException;
import redlight.utils.TextUtils;

public class DebuggerOutput {
    public static boolean on = false;

    public static void setEnabled(boolean enable) {
        on = enable;
        if (on) {
            DebuggerOutput.debug("Debugging output turned on");
        }
    }

    public static final void debug(String s) {
        if (on) {
            System.out.println(s);
        }
    }

    public static final void stackTrace(Exception e) {
        if (on) {
            e.printStackTrace();
        }
    }

    public static final void tell(String s) {
        if (on) {
            try {
                throw new DebuggerException(s);
            }
            catch (DebuggerException e) {
                e.printStackTrace();
            }
        }
    }

    public static final void dumpBytes(byte[] b, int cols) {
        if (on) {
            int i = 0;
            while (i < b.length / cols + 1) {
                int offset = cols;
                int j = 0;
                while (j < cols && j + i * cols < b.length) {
                    System.out.print(TextUtils.prepad(Integer.toHexString(b[j + i * cols] & 0xFF), 1) + " ");
                    --offset;
                    ++j;
                }
                if (offset > 0) {
                    while (offset > 0) {
                        System.out.print("   ");
                        --offset;
                    }
                }
                System.out.print(" ");
                int j2 = 0;
                while (j2 < cols && j2 + i * cols < b.length) {
                    if (!Character.isISOControl((char)b[j2 + i * cols])) {
                        System.out.print((char)b[j2 + i * cols]);
                    } else {
                        System.out.print(".");
                    }
                    ++j2;
                }
                System.out.println();
                ++i;
            }
        }
    }
}

