/*
 * Decompiled with CFR 0.152.
 */
package redlight.utils;

import java.util.Vector;
import redlight.utils.Queueable;

public class QueueThread {
    Vector queue;
    Thread thread;
    boolean elementWaiting = true;
    Queueable monitor = null;
    Integer monitorLock;
    public int sleepTime = 0;
    Runnable runner = new Runnable(){

        public synchronized void run() {
            while (!QueueThread.this.thread.isInterrupted()) {
                Integer n = QueueThread.this.monitorLock;
                synchronized (n) {
                    if (!QueueThread.this.thread.isInterrupted() && QueueThread.this.monitor == null) {
                        Vector vector = QueueThread.this.queue;
                        synchronized (vector) {
                            QueueThread.this.monitor = QueueThread.this.queue.size() > 0 ? (Queueable)QueueThread.this.queue.elementAt(0) : null;
                        }
                        if (QueueThread.this.monitor != null) {
                            QueueThread.this.monitor.granted();
                            if (QueueThread.this.sleepTime > 0) {
                                try {
                                    Thread.currentThread();
                                    Thread.sleep(QueueThread.this.sleepTime);
                                }
                                catch (InterruptedException interruptedException) {
                                    // empty catch block
                                }
                            }
                        }
                    }
                }
                try {
                    this.wait(3000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    };

    public QueueThread() {
        this.monitorLock = new Integer(1);
        this.queue = new Vector();
        this.thread = new Thread(this.runner, "QueueThread");
        this.start();
    }

    public synchronized boolean add(Queueable ft) {
        boolean queued = true;
        Vector vector = this.queue;
        synchronized (vector) {
            queued = this.queue.size() > 0;
            this.queue.addElement(ft);
        }
        this.notify();
        return queued;
    }

    public synchronized void remove(Queueable ft) {
        Integer n = this.monitorLock;
        synchronized (n) {
            if (ft == this.monitor) {
                this.monitor = null;
            }
        }
        Vector vector = this.queue;
        synchronized (vector) {
            this.queue.removeElement(ft);
        }
        this.notify();
    }

    public Queueable getMonitor() {
        return this.monitor;
    }

    public void start() {
        if (!this.thread.isAlive()) {
            this.thread.start();
        }
    }

    public synchronized void stop() {
        this.thread.interrupt();
        this.notify();
        this.queue.removeAllElements();
    }
}

