#!/usr/bin/perl -w

# A little utility to create Q&A type HTML documents.
# It expects input structured like:
#
# Q1: question 1
# A: answer 1
# -
# Q2: question 2
# A: answer 2
#
# etcetera. The 1 & 2 in the example can be
# any label that's allowed as a HTML ANCHOR name.

$expectQuestion = 1;

while(<>) {

    $l = $_;

    if($l =~ /^$/) {

        next;

    }

    $l =~ /^Q(.*):\s*(.*)/ && do {

        if($expectQuestion == 0) {

            die("didn't expect question at line $l");

        }

        $expectAnswer = 1;
        $expectQuestion = 0;
        $isQuestion = 1;
        $current = $1;
        $l = $2;

    };

    $l =~ /^A:\s*(.*)/ && do {

        if($expectAnswer == 0) {

            die("didn't expect answer at line $l");

        }

        $expectAnswer = 0;
        $expectQuestion = 1;
        $isQuestion = 0;
        $expectQuestion = 1;
        $l = $1;

    };

    $l =~ /^-\s*$/ && do {

        $isQuestion = 0;
        $expectQuestion = 1;
        $expectAnswer = 0;
        next;

    };

    $l =~ /^\s*(.*?)\s*$/;
    $l = "$1 ";

    if($isQuestion == 1) {

        $questions{$current} .= "$l\n";

    } else {

        $answers{$current} .= "$l\n";

    }

}

print "<ul>\n";

$index = 1;
foreach(sort (keys(%questions))) {

    $p = $questions{$_};
    chomp($p);
    print "<li>$index. <a href='#$_'>$p</a></li>\n";
    $index++;
}

print "</ul>\n";

$index = 1;
foreach(sort (keys(%questions))) {

    $q = $questions{$_};
    chomp($q);
    print "<a name='$_'><h3>$index. $q</h3></a><p>\n";
    $a = $answers{$_};
    $a =~ s/_Q(.*)_/<a href='#$1'>$questions{$1}<\/a>/g;
    chomp($a);
    print "$a";
    print "<p>\n\n";
    $index++;

}

