/**
 * $Id: AgreementInterface.java,v 1.2 2001/09/21 02:48:24 groomed Exp $
 *
 * Copyright (C) 1998-2001 groomed <groomed@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package redlight.client;
 
import java.io.IOException;
import java.awt.Font;
import javax.swing.*;
import java.lang.reflect.InvocationTargetException;

import redlight.utils.TextUtils;

public class AgreementInterface {

    static boolean agreed = false;

    static synchronized public boolean handleAgreement(final Machine machine, final String agreement) {

        try {

            SwingUtilities.invokeAndWait(new Runnable() {
                    
                    public void run() {

                        JTextArea text = new JTextArea(TextUtils.findAndReplace(agreement, "\r", "\n"), 20, 60);
                        text.setBackground(machine.getSchemeColor("background"));
                        text.setForeground(machine.getSchemeColor("foreground"));
                        text.setLineWrap(true);
                        text.setWrapStyleWord(true);
                        text.setFont((Font) Main.rlo.getProperty("Font.text"));
                        text.setEditable(false);
                        text.setFont((Font) Main.rlo.getProperty("Font.text"));
                        int reply = JOptionPane.showConfirmDialog(null, new JScrollPane(text), "Agreement (" + machine.getServerName() + ")", JOptionPane.YES_NO_OPTION);
                        
                        if(reply != JOptionPane.YES_OPTION)
                            agreed = false;
        
                        agreed = true;

                    }

                });

        } catch(InterruptedException e) {

        } catch(InvocationTargetException e) {

        }

        return agreed;

    }

}
