/**
 * $Id: DirOpener.java,v 1.1.1.1 2001/07/22 02:44:30 groomed Exp $
 *
 * Copyright (C) 1998-2001 groomed <groomed@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package redlight.client;
 
import java.util.Hashtable;

/**
 * This is a static class that keeps track of what
 * directories are already open; opening directories
 * goes through this class, so that a directory is
 * never openend twice.
 */
public class DirOpener {
    static Hashtable servers = new Hashtable();

    public static void open(Machine m, String p) {
	Hashtable files;
	synchronized(servers) {
	    if(servers.containsKey(m)) {
		files = (Hashtable) servers.get(m);
		if(files.containsKey(p))
		    ((FilesInterface) files.get(p)).show();
		else 
		    files.put(p, new FilesInterface(m, p, false));
	    } else {
		files = new Hashtable();
		servers.put(m, files);
		files.put(p, new FilesInterface(m, p, false));
	    }
	}
    }

    public static void close(Machine m, String p) {
	synchronized(servers) {
	    if(servers.containsKey(m)) {
		Hashtable files = (Hashtable) servers.get(m);
		if(files.containsKey(p))
		    files.remove(p);
	    }
	}
    }
	
    public static void remove(Machine m) {
	if(servers.containsKey(m)) {
	    Hashtable files = (Hashtable) servers.get(m);
	    files.clear();
	    servers.remove(m);
	}
    }
}
