/**
 * $Id: PrivChatInviteInterface.java,v 1.1.1.1 2001/07/22 02:44:35 groomed Exp $
 *
 * Copyright (C) 1998-2001 groomed <groomed@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package redlight.client;

import java.io.IOException; 
import java.awt.*;
import java.awt.event.*;
import java.lang.reflect.InvocationTargetException;
import javax.swing.*;

import redlight.hotline.*;
import redlight.utils.TextUtils;

public class PrivChatInviteInterface {
    int pcref;
    int sock;
    String nick;

    public PrivChatInviteInterface(final Machine machine, 
                                       int ref, 
                                       int s, 
                                       String n) {
	pcref = ref;
	sock = s;
	nick = n;

        int reply = JOptionPane.showConfirmDialog(null, TextUtils.wordWrap(n + " is inviting you to a private chat. Do you accept?", 40), "Private chat (" + machine.getServerName() + ")", JOptionPane.YES_NO_OPTION, JOptionPane.QUESTION_MESSAGE);

        if(machine != null && machine.getHLC() != null) {

            if(reply == JOptionPane.CLOSED_OPTION)
                reply = JOptionPane.CANCEL_OPTION;
            
            if(reply != JOptionPane.CANCEL_OPTION) {

                try {

                    if(reply == JOptionPane.NO_OPTION) {
                        
                        machine.getHLC().sendPrivateChatDecline(pcref);
                        
                    } else if(reply == JOptionPane.YES_OPTION) {
                        
                        /* We block processing of incoming packets until
                           the private chat interface is ready to receive
                           incoming events. */
                        
                        machine.getHLC().setBlocked(true);
                        final int id = machine.getHLC().requestPrivateChatJoin(pcref);
                        
                        machine.createDomain(new Integer(pcref));
                        
                        try {
                            
                            SwingUtilities.invokeAndWait(new Runnable() {
                                    
                                    public void run() {
                                        
                                        new PrivChatInterface(machine, 
                                                                  pcref, 
                                                                  sock, 
                                                                  nick, 
                                                                  id);
                                        machine.getHLC().setBlocked(false);
                                        
                                    }
                                    
                            });
                            
                        } catch(InterruptedException e) {
                        } catch(InvocationTargetException e) {}
                        
                    }
                     
                } catch(IOException e) {}

            }
            
        }
        
    }
    
}

