/**
 * $Id: HostTimedOutException.java,v 1.1.1.1 2001/07/22 02:44:45 groomed Exp $
 *
 * Copyright (C) 1998-2001 groomed <groomed@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
 
package redlight.hotline;

import redlight.hotline.HLException;

/**
 * This exception is thrown when no messages are received from
 * a host within a certain time interval.
 */
public class HostTimedOutException extends HLException {
    long timeout;

    /**
     * Creates a HostTimedOutException with specified string and timeout
     * value.
     * @param s a descriptive string
     * @param t the timeout (in milliseconds) at which this exception 
     * was thrown
     */
    public HostTimedOutException(String s, long t) {
	super(s);
	setTimeoutMillis(t);
    }

    /**
     * Returns the number of milliseconds at which the host timed out.
     * @return timeout value
     */
    public long getTimeoutMillis() {
	return timeout;
    }

    /**
     * Sets the number of milliseconds at which the host timed out.
     * @param t timeout value
     */
    public void setTimeoutMillis(long t) {
	timeout = t;
    }

}
