/**
 * $Id: NativeResourceFork.java,v 1.2 2001/09/21 02:48:24 groomed Exp $
 *
 * Copyright (C) 1998-2001 groomed <groomed@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package redlight.macfiles;

import java.io.*;

import redlight.utils.DebuggerOutput;
import redlight.utils.FilenameUtils;

public class NativeResourceFork extends Fork {
    InputStream input;
    OutputStream output;
    DataInputStream d_i;
    DataOutputStream d_o;
    ResourceFork resourceFork;

    public NativeResourceFork(MacFile parent, 
                              Integer perms) throws IOException {

	super(parent);

	DebuggerOutput.debug("NativeResourceFork: trying to open resource fork for IO");
	resourceFork = new ResourceFork(parent.getFile(), perms);
	input = resourceFork.getInputStream();
	output = resourceFork.getOutputStream();
	d_i = new DataInputStream(input);
	d_o = new DataOutputStream(output);	
	DebuggerOutput.debug("NativeResourceFork: created");

    }

    public long size() {

	return resourceFork.length();

    }

    public long seek(long s) throws IOException {

	resourceFork.seek((int) s);
	DebuggerOutput.debug("NativeResourceFork: seek ("+s+")");
	return s;

    }

    public DataOutput getDataOutput() {

	return d_o;

    }

    public DataInput getDataInput() {

	return d_i;

    }

    public void close() throws IOException {

        if(!isClosed) {

            resourceFork.close();
            isClosed = true;

        }

    }

    public boolean exists() {

	return true;

    }

}
