/**
 * $Id: BytesFormat.java,v 1.1.1.1 2001/07/22 02:44:49 groomed Exp $
 *
 * Copyright (C) 1998-2001 groomed <groomed@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package redlight.utils;

import redlight.utils.DebuggerOutput;
import java.text.NumberFormat;

/**
 * BytesFormat translates a number of bytes into
 * a human-readable form and vice-versa.
 */
public class BytesFormat {
	
    static long KB = 1024;
    static long MB = 1024 * KB;
    static long GB = 1024 * MB;
    
    /**
     * Parses a size indication of the form "485GB", 
     * "10.53M", "758K" and returns the corresponding integer.
     * @param size String the string to parse
     * @return an integer
     */
    public static long parse(String size) {
	if(size.startsWith("<")) size = size.substring(1);
	byte[] s = size.getBytes();
	String number = size.substring(0, size.length()-1);
	if(s[s.length-1] == 'G')
	    return (int) (new Float(number).floatValue() * GB);
	if(s[s.length-1] == 'M')
	    return (int) (new Float(number).floatValue() * MB);
	else if(s[s.length-1] == 'K')
	    return (int) (new Float(number).floatValue() * KB);
	return Long.parseLong(size);
    }
	
    /**
     * Converts an integer into a string of the form "485GB", 
     * "10.53M", "758K" and returns it.
     * @return String the string to parse
     * @param bytes a number of bytes
     */
    public static String format(long bytes) {
	NumberFormat nf = NumberFormat.getInstance();
	nf.setMaximumFractionDigits(2);
	if(bytes / (1024 * 1024 * 1024) >= 1) 
	    return(nf.format((double) bytes / GB) + "G");
	else if(bytes / (1024 * 1024) >= 1) 
	    return(nf.format((double) bytes / MB) + "M");
	else if(bytes / 1024 >= 1) 
	    return(nf.format((double) bytes / KB) + "K");
	else if(bytes < 1024) 
	    return "<1K";
	else return new String(new Long(bytes).toString());
    }
}
