/**
 * $Id: DebuggerOutput.java,v 1.1.1.1 2001/07/22 02:44:49 groomed Exp $
 *
 * Copyright (C) 1998-2001 groomed <groomed@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
 
package redlight.utils;
 
/**
 * Some stuff for debugging.
 */
public class DebuggerOutput {

    public static boolean on = false;

    /**
     * Enables or disables output from the methods in this class.
     * @param enable true to enable output.
     */
    public static void setEnabled(boolean enable) {

        on = enable;

        if(on)
            debug("Debugging output turned on");

    }

    /**
     * Conditionally writes the specified string to standard output.
     * @param s a message.
     */
    public static final void debug(String s) {

	if(on)
	    System.out.println(s);

    }

    /**
     * Conditionally dumps stack trace for the specified exception.
     * @param e the exception.
     */
    public static final void stackTrace(Exception e) {

	if(on)
	    e.printStackTrace();

    }

    /**
     * Conditionally dumps a stack trace to standard output.
     * @param s a message.
     */
    public static final void tell(String s) {

	if(on) {

	    try {

 		throw new DebuggerException(s);

	    } catch(DebuggerException e) {

		e.printStackTrace();

	    }

	}

    }

    /**
     * Conditionally produces a hexdump of the specified byte array 
     * on standard output. The cols variable controls
     * the number of horizontal columns.
     * @param b the byte array to dump.
     * @param cols the number of horizontal columns.
     */
    public static final void dumpBytes(byte[] b, int cols) {

        if(on) {

            for(int i=0; i < (b.length / cols) + 1; i++) {
                
                int offset = cols;
                
                for(int j=0; j<cols && j+(i*cols) < b.length; offset--, j++)
                    System.out.print(TextUtils.prepad(Integer.toHexString(b[j+(i*cols)] & 0xff), 1) + " ");
                
                if(offset > 0)
                    for(;offset > 0; offset--)
                        System.out.print("   ");

                System.out.print(" ");

                for(int j=0; j<cols && j+(i*cols) < b.length; j++) {
                    
                    if(!Character.isISOControl((char) b[j+(i*cols)])) 
                        System.out.print((char) b[j+(i*cols)]);
                    
                    else
                        
                        System.out.print(".");
                    
                }
                
                System.out.println();
                
            }

        }

    }

}

/**
 * Thrown by DebuggerOutput.tell.
 */
class DebuggerException extends Exception {

    DebuggerException(String s) {

	super(s);

    }

}
