/**
 * $Id: AppAudioClip.java,v 1.1.1.1 2001/07/22 02:44:50 groomed Exp $
 *
 * JDK 1.1 compatible audio support.
 *
 * Copyright (C) 1998-2001 groomed <groomed@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package redlight.utils;

import java.applet.AudioClip;
import java.io.*;
import sun.audio.*;
import java.net.URL;

public class AppAudioClip extends LegacyAudioClip {
    protected AudioData data;
    protected InputStream stream;

    public AppAudioClip(URL clip) {

        this.clip = clip;
        InputStream in = null;
      
        try {

            try {

                in = new BufferedInputStream(clip.openStream());
                data = new AudioStream(in).getData();

            } finally {

                if(in != null) 
                    in.close();
 
            }

        } catch (IOException e) {

            data = null;

        }

    }

    public synchronized void play() {

        stop();

        if(data != null) {
            
            stream = new AudioDataStream(data);
            AudioPlayer.player.start(stream);

        }

    }

    public synchronized void loop() {

        stop();

        if(data != null) {

            stream = new ContinuousAudioDataStream(data);
            AudioPlayer.player.start(stream);

        }
    }

    public synchronized void stop() {

        if(stream != null) {

            AudioPlayer.player.stop(stream);

            try {
                stream.close();
            } catch (IOException e) {
            }

        }

    }
    
    public static boolean isAudioSupported() {

        return true;

    }

    public String toString() {

        return getClass().toString() + "[" + clip + "]";

    }

}
