/*
 * Decompiled with CFR 0.152.
 */
package org.sdg.xdman.core.common;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import org.sdg.xdman.core.common.ChunkFileInfo;
import org.sdg.xdman.util.XDMUtil;

public class Assembler {
    public static boolean stop = false;

    private static void assemble(OutputStream out, ArrayList<ChunkFileInfo> fileList) throws Exception {
        FileInputStream in = null;
        int count = 0;
        int i = 0;
        while (i < fileList.size()) {
            int r;
            ChunkFileInfo info = fileList.get(i);
            System.out.println("Reading..." + info.file);
            in = new FileInputStream(info.file);
            long rem = info.len;
            byte[] buf = new byte[65536];
            do {
                int x = (int)(rem > (long)buf.length ? (long)buf.length : rem);
                r = ((InputStream)in).read(buf, 0, x);
                if (stop) {
                    throw new InterruptedException();
                }
                if (r == -1) break;
                out.write(buf, 0, r);
                count += r;
            } while ((rem -= (long)r) != 0L);
            ((InputStream)in).close();
            ++i;
        }
        out.close();
    }

    public static synchronized boolean forceAssemble(String tempdir, String destdir, String filename) {
        stop = false;
        try {
            File statefile = new File(tempdir, ".state");
            ObjectInputStream in = new ObjectInputStream(new FileInputStream(statefile));
            in.readUTF();
            in.readObject();
            in.readUTF();
            in.readUTF();
            in.readUTF();
            in.readLong();
            in.readLong();
            int sz = in.readInt();
            ArrayList<ChunkFileInfo> fileList = new ArrayList<ChunkFileInfo>();
            int i = 0;
            while (i < sz) {
                fileList.add((ChunkFileInfo)in.readObject());
                ++i;
            }
            Collections.sort(fileList, new ChunkFileInfo());
            File outDir = new File(destdir);
            if (!outDir.exists()) {
                outDir.mkdirs();
            }
            String finalFileName = XDMUtil.getUniqueFileName(destdir, filename);
            File outFile = new File(destdir, finalFileName);
            FileOutputStream out = new FileOutputStream(outFile);
            try {
                Assembler.assemble(out, fileList);
            }
            catch (Exception e) {
                try {
                    ((OutputStream)out).close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                outFile.delete();
                throw e;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }
}

