/*
 * Decompiled with CFR 0.152.
 */
package org.sdg.xdman.core.common.http;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.zip.GZIPInputStream;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import jcifs.util.Base64;
import org.sdg.xdman.core.common.AuthenticationException;
import org.sdg.xdman.core.common.XDMConfig;
import org.sdg.xdman.core.common.http.NTLMAutheticator;
import org.sdg.xdman.core.common.http.io.ChunkedInputStream;
import org.sdg.xdman.util.HTTPUtil;
import org.sdg.xdman.util.Logger;

public class XDMHttpClient2 {
    public HashMap<String, String> requestHeaders = new HashMap();
    public HashMap<String, String> resposeHeaders = new HashMap();
    private ArrayList<String> cookies = new ArrayList();
    private ArrayList<String> setCookies = new ArrayList();
    private SSLContext context;
    public boolean connected = false;
    public boolean sendGet = false;
    public Socket sock;
    public URL url;
    public String host;
    public String path;
    public String protocol;
    public String query;
    public String referer;
    public String ua;
    int port;
    public OutputStream out;
    public InputStream in;
    public String statusLine;
    final int HTTP_PROXY = 10;
    final int HTTPS_PROXY = 20;
    final int NONE = 30;
    int proxyType = 30;
    XDMConfig config;
    long len;
    public static final int NTLM = 10;
    public static final int BASIC = 20;
    public static final int NO_AUTH = 0;
    static boolean flag = false;
    public String user;
    public String pass;

    public void addCookies(ArrayList<String> cookieList) {
        if (cookieList != null) {
            this.cookies.addAll(cookieList);
        }
    }

    public XDMHttpClient2(XDMConfig config) {
        this.config = config;
    }

    public void addRequestHeaders(String key, String value) {
        if (key == null || value == null) {
            return;
        }
        this.requestHeaders.put(key, value);
    }

    public String getResponseHeader(String key) {
        return this.resposeHeaders.get(key);
    }

    public void addCookie(String cookie) {
        if (cookie != null) {
            this.cookies.add(cookie);
        }
    }

    public ArrayList<String> getCookies() {
        return this.setCookies;
    }

    private void doConnect() throws IOException, AuthenticationException {
        if (this.protocol.equalsIgnoreCase("http")) {
            this.sock = new Socket();
            this.sock.setTcpNoDelay(true);
            this.sock.setReceiveBufferSize(this.config.tcpBuf * 1024);
            this.sock.setSoTimeout(this.config.timeout * 1000);
            if (this.config.useHttpProxy) {
                this.proxyType = 10;
                String proxyHost = this.config.httpProxyHost;
                int proxyPort = this.config.httpProxyPort;
                this.sock.connect(new InetSocketAddress(proxyHost, proxyPort));
            } else {
                this.proxyType = 30;
                this.sock.connect(new InetSocketAddress(this.host, this.port));
            }
        } else if (this.protocol.equalsIgnoreCase("https")) {
            if (this.config.useHttpsProxy) {
                this.proxyType = 20;
                this.sock = new Socket();
                this.doTunneling(this.config.httpsProxyHost, this.config.httpsProxyPort);
            } else {
                this.proxyType = 30;
                this.acceptAllCerts();
                this.sock = this.context.getSocketFactory().createSocket();
                this.sock.setTcpNoDelay(true);
                this.sock.setSoTimeout(this.config.timeout * 1000);
                this.sock.setReceiveBufferSize(this.config.tcpBuf * 1024);
                this.sock.connect(new InetSocketAddress(this.host, this.port));
            }
        } else {
            throw new IOException("Protocol " + this.protocol + " is not supported");
        }
        this.sock.setTcpNoDelay(true);
        this.in = this.sock.getInputStream();
        this.out = this.sock.getOutputStream();
        this.sock.setKeepAlive(true);
        this.connected = true;
    }

    private void doTunnelConnect(String host, int port) throws IOException {
        this.sock = new Socket();
        this.sock.setTcpNoDelay(true);
        this.sock.setSoTimeout(this.config.timeout * 1000);
        this.sock.setReceiveBufferSize(this.config.tcpBuf * 1024);
        this.sock.connect(new InetSocketAddress(host, port));
        this.in = this.sock.getInputStream();
        this.out = this.sock.getOutputStream();
    }

    private void initConnection(String uri) throws IOException, URISyntaxException {
        String oldHost = this.host;
        int oldPort = this.port;
        uri = uri.trim();
        this.url = new URL(uri);
        this.host = this.url.getHost();
        this.port = this.url.getPort();
        this.protocol = this.url.getProtocol();
        this.path = this.url.getPath();
        this.query = this.url.getQuery();
        if (this.path == null) {
            this.path = "/";
        }
        if (!this.path.startsWith("/")) {
            this.path = "/" + this.path;
        }
        if (this.query != null) {
            this.path = String.valueOf(this.path) + "?" + this.query;
        }
        if (this.port < 0) {
            if (this.protocol.equals("http")) {
                this.port = 80;
            }
            if (this.protocol.equals("https")) {
                this.port = 443;
            }
        }
        if (!(oldHost == null || this.host.equals(oldHost) && this.port == oldPort)) {
            throw new IOException("ReUse Error: Remote address is incompatiable: New Host: " + this.host + " Old Host: " + oldHost);
        }
    }

    private void parseResponse() throws IOException {
        String ln;
        if (flag) {
            this.in = this.sock.getInputStream();
            System.out.println("***AVAIL: " + this.in.available());
            int i = 0;
            while (i < 100) {
                int x = this.in.read();
                if (x == 13) {
                    System.out.println("'\\r'");
                } else if (x == 10) {
                    System.out.println("'\\n'");
                } else {
                    System.out.println((char)x);
                }
                ++i;
            }
        }
        this.statusLine = HTTPUtil.readLine(this.in);
        System.out.println("Status: " + this.statusLine + " " + this.statusLine.length());
        Logger.log(this.statusLine);
        this.resposeHeaders.clear();
        while ((ln = HTTPUtil.readLine(this.in)).length() >= 1) {
            Logger.log(ln);
            System.out.println("RESP: " + ln);
            int index = ln.indexOf(":");
            String key = ln.substring(0, index).trim().toLowerCase();
            String value = ln.substring(index + 1).trim();
            if (key.equals("proxy-authenticate")) {
                if (value.toLowerCase().indexOf("ntlm") == -1 && value.toLowerCase().indexOf("basic") == -1 || this.resposeHeaders.get(key) != null) continue;
                this.resposeHeaders.put(key, value);
                continue;
            }
            if (key.equals("www-authenticate")) {
                if (value.toLowerCase().indexOf("ntlm") == -1 && value.toLowerCase().indexOf("basic") == -1 || this.resposeHeaders.get(key) != null) continue;
                this.resposeHeaders.put(key, value);
                continue;
            }
            if (key.equals("set-cookie")) {
                this.setCookies.add(value);
                continue;
            }
            this.resposeHeaders.put(key, value);
        }
        String tenc = this.resposeHeaders.get("transfer-encoding");
        InputStream in2 = this.in;
        if (tenc != null) {
            if (tenc.equalsIgnoreCase("chunked")) {
                in2 = new ChunkedInputStream(this.in);
            } else {
                throw new IOException("Transfer Encoding not supported: " + tenc);
            }
        }
        String enc = this.resposeHeaders.get("content-encoding");
        InputStream in3 = in2;
        if (enc != null) {
            if (enc.equalsIgnoreCase("gzip")) {
                in3 = new GZIPInputStream(in2);
            } else if (enc.equalsIgnoreCase("none") || enc.equalsIgnoreCase("identity")) {
                in3 = in2;
            } else {
                throw new IOException("Content Encoding not supported: " + enc);
            }
        }
        this.in = in3;
    }

    private String parseProxyResponse(HashMap<String, String> proxyResponse) throws IOException {
        String ln;
        String stat = HTTPUtil.readLine(this.in);
        Logger.log(stat);
        proxyResponse.clear();
        while ((ln = HTTPUtil.readLine(this.in)).length() >= 1) {
            Logger.log(ln);
            System.out.println(ln);
            int index = ln.indexOf(":");
            String key = ln.substring(0, index).trim().toLowerCase();
            String value = ln.substring(index + 1).trim();
            if (key.equals("proxy-authenticate")) {
                if (value.toLowerCase().indexOf("ntlm") == -1 && value.toLowerCase().indexOf("basic") == -1 || proxyResponse.get(key) != null) continue;
                proxyResponse.put(key, value);
                continue;
            }
            if (key.equals("www-authenticate")) {
                if (value.toLowerCase().indexOf("ntlm") == -1 && value.toLowerCase().indexOf("basic") == -1 || proxyResponse.get(key) != null) continue;
                proxyResponse.put(key, value);
                continue;
            }
            proxyResponse.put(key, value);
        }
        String tenc = proxyResponse.get("transfer-encoding");
        InputStream in2 = this.in;
        if (tenc != null) {
            if (tenc.equalsIgnoreCase("chunked")) {
                in2 = new ChunkedInputStream(this.in);
            } else {
                throw new IOException("Transfer Encoding not supported: " + tenc);
            }
        }
        String enc = proxyResponse.get("content-encoding");
        InputStream in3 = in2;
        if (enc != null) {
            if (enc.equalsIgnoreCase("gzip")) {
                in3 = new GZIPInputStream(in2);
            } else if (enc.equalsIgnoreCase("none")) {
                in3 = in2;
            } else {
                throw new IOException("Content Encoding not supported: " + enc);
            }
        }
        this.in = in3;
        return stat;
    }

    public void reConnect(String uri) throws UnknownHostException, IOException, URISyntaxException, AuthenticationException {
        this.initConnection(uri);
        this.connected = true;
    }

    public void connect(String uri) throws UnknownHostException, IOException, URISyntaxException, AuthenticationException {
        if (this.connected) {
            return;
        }
        this.initConnection(uri);
        this.doConnect();
        this.connected = true;
    }

    public void close() {
        try {
            this.in.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.out.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.sock.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getHostString() {
        return String.valueOf(this.host) + ":" + this.port;
    }

    private int getAuthenticationMethod(String auth) throws IOException {
        if (auth != null) {
            if ((auth = auth.toLowerCase()).indexOf("basic") != -1) {
                return 20;
            }
            if (auth.indexOf("ntlm") != -1) {
                return 10;
            }
            throw new IOException("Authentication method not supported");
        }
        return 0;
    }

    private String getNTChallage(String value) {
        if (value == null) {
            return null;
        }
        int index = value.indexOf(32);
        if (index < 0) {
            return null;
        }
        return value.substring(index + 1).trim();
    }

    public void sendRequest() throws IOException, AuthenticationException {
        this.requestHeaders.put("accept-encoding", "gzip");
        int proxyAuthMethod = 0;
        int httpAuthMethod = 0;
        int proxyNtlmStage = -1;
        int ntlmStage = -1;
        int basicHttpStage = -1;
        int basicProxyStage = -1;
        int prevResponse = 0;
        NTLMAutheticator ntAuth = null;
        NTLMAutheticator proxyNtAuth = null;
        if (this.proxyType == 10) {
            this.path = this.url.toString();
        }
        do {
            String authString;
            String auth;
            if (prevResponse == 401 && (this.user == null || this.user.length() < 1)) {
                throw new AuthenticationException("Authentication required!");
            }
            httpAuthMethod = this.getAuthenticationMethod(this.resposeHeaders.get("www-authenticate"));
            proxyAuthMethod = this.getAuthenticationMethod(this.resposeHeaders.get("proxy-authenticate"));
            if (httpAuthMethod == 10) {
                if (ntlmStage > 0) {
                    throw new AuthenticationException("Authentication Failed!");
                }
                if (ntAuth == null) {
                    String u = this.getUser(this.user);
                    String d = this.getDomain(this.user);
                    ntAuth = new NTLMAutheticator(d, u, this.pass);
                }
                auth = this.resposeHeaders.get("www-authenticate");
                ++ntlmStage;
                this.requestHeaders.put("authorization", "NTLM " + ntAuth.getNTLMString(this.getNTChallage(auth)));
            } else if (httpAuthMethod == 20) {
                if (basicHttpStage > -1) {
                    throw new AuthenticationException("Authentication Failed!");
                }
                authString = "Basic " + Base64.encode((String.valueOf(this.user) + ":" + this.pass).getBytes());
                this.requestHeaders.put("authorization", authString);
                ++basicHttpStage;
            } else if (httpAuthMethod != 0) {
                throw new IOException("Authentication method not supported");
            }
            if (proxyAuthMethod == 10) {
                if (proxyNtlmStage > 1) {
                    throw new AuthenticationException("Proxy Authentication Failed!");
                }
                if (proxyNtAuth == null) {
                    proxyNtAuth = new NTLMAutheticator(System.getenv("USERDOMAIN"), this.config.httpUser, this.config.httpPass);
                }
                auth = this.resposeHeaders.get("proxy-authenticate");
                ++proxyNtlmStage;
                this.requestHeaders.put("proxy-authorization", "NTLM " + proxyNtAuth.getNTLMString(this.getNTChallage(auth)));
            } else if (proxyAuthMethod == 20) {
                if (basicProxyStage > -1) {
                    throw new AuthenticationException("Proxy Authentication Failed!");
                }
                authString = "Basic " + Base64.encode((String.valueOf(this.config.httpUser) + ":" + this.config.httpPass).getBytes());
                this.requestHeaders.put("proxy-authorization", authString);
                ++basicProxyStage;
            } else if (proxyAuthMethod != 0) {
                throw new IOException("Proxy Authentication method not supported");
            }
            StringBuffer requestBuffer = new StringBuffer();
            this.appendHeaders(requestBuffer, this.requestHeaders, false);
            requestBuffer.append("\r\n");
            if (!this.sock.isConnected()) {
                this.doConnect();
            } else if (this.sock.isClosed()) {
                this.doConnect();
            }
            this.out = this.sock.getOutputStream();
            this.in = this.sock.getInputStream();
            this.out.write(requestBuffer.toString().getBytes());
            this.out.flush();
            System.out.println(requestBuffer);
            this.parseResponse();
            prevResponse = this.getResponseCode();
            System.out.println("SERVER_RESP: " + prevResponse + " " + this.statusLine);
            if (prevResponse != 407 && prevResponse != 401) continue;
            String tenc = this.resposeHeaders.get("transfer-encoding");
            this.skipRemainingStream("chunked".equalsIgnoreCase(tenc), this.resposeHeaders);
            if (!"Close".equalsIgnoreCase(this.resposeHeaders.get("connection")) && !"Close".equalsIgnoreCase(this.resposeHeaders.get("proxy-connection"))) continue;
            this.close();
        } while (prevResponse == 407 || prevResponse == 401);
        this.sendGet = true;
    }

    private void appendHeaders(StringBuffer requestBuffer, HashMap<String, String> requestHeaders, boolean tunnel) {
        if (tunnel) {
            requestBuffer.append("CONNECT " + this.host + ":" + this.port + " HTTP/1.1\r\nHost: " + this.host + ":" + this.port + "\r\n");
        } else {
            String shost = this.host;
            if (this.port != 80) {
                shost = String.valueOf(shost) + ":" + this.port;
            }
            requestBuffer.append("GET " + this.path + " HTTP/1.1\r\nHost: " + shost + "\r\n");
        }
        for (String key : requestHeaders.keySet()) {
            String value = requestHeaders.get(key);
            requestBuffer.append(String.valueOf(key) + ": " + value + "\r\n");
        }
        if (this.cookies != null) {
            int i = 0;
            while (i < this.cookies.size()) {
                requestBuffer.append("cookie: " + this.cookies.get(i) + "\r\n");
                ++i;
            }
        }
        Logger.log(requestBuffer);
    }

    private String getDomain(String userdom) {
        int idx = userdom.lastIndexOf(64);
        if (idx < 0) {
            return null;
        }
        return userdom.substring(idx + 1);
    }

    private String getUser(String userdom) {
        int idx = userdom.lastIndexOf(64);
        if (idx < 0) {
            return userdom;
        }
        return userdom.substring(0, idx);
    }

    public void doTunneling(String host, int port) throws IOException, AuthenticationException {
        int authMethod = 0;
        int prevResponse = 0;
        int proxyNtlmStage = -1;
        int basicProxyStage = -1;
        NTLMAutheticator ntAuth = null;
        HashMap<String, String> proxyResponse = new HashMap<String, String>();
        HashMap<String, String> proxyRequest = new HashMap<String, String>();
        do {
            if ((authMethod = this.getAuthenticationMethod((String)proxyResponse.get("proxy-authenticate"))) == 10) {
                if (proxyNtlmStage > 1) {
                    throw new AuthenticationException("Proxy Authentication Failed!");
                }
                if (ntAuth == null) {
                    ntAuth = new NTLMAutheticator(System.getenv("USERDOMAIN"), this.config.httpsUser, this.config.httpsPass);
                }
                String auth = (String)proxyResponse.get("proxy-authenticate");
                ++proxyNtlmStage;
                proxyRequest.put("proxy-authorization", "NTLM " + ntAuth.getNTLMString(this.getNTChallage(auth)));
            } else if (authMethod == 20) {
                if (basicProxyStage > -1) {
                    throw new AuthenticationException("Proxy Authentication Failed!");
                }
                String authString = "Basic " + Base64.encode((String.valueOf(this.config.httpsUser) + ":" + this.config.httpsPass).getBytes());
                proxyRequest.put("proxy-authorization", authString);
                ++basicProxyStage;
            } else if (authMethod != 0) {
                throw new IOException("Proxy Authentication method not supported");
            }
            StringBuffer requestBuffer = new StringBuffer();
            this.appendHeaders(requestBuffer, proxyRequest, true);
            if (!this.sock.isConnected()) {
                this.doTunnelConnect(host, port);
            } else if (this.sock.isClosed()) {
                this.doTunnelConnect(host, port);
            }
            requestBuffer.append("\r\n");
            this.out.write(requestBuffer.toString().getBytes());
            this.out.flush();
            String statusLine = this.parseProxyResponse(proxyResponse);
            System.out.println(statusLine);
            prevResponse = HTTPUtil.getResponseCode(statusLine);
            if (prevResponse == 407 || prevResponse == 401) {
                String tenc = proxyResponse.get("transfer-encoding");
                this.skipRemainingStream("chunked".equalsIgnoreCase(tenc), proxyResponse);
            }
            if (!"close".equalsIgnoreCase(proxyResponse.get("proxy-connection"))) continue;
            this.close();
        } while (prevResponse == 407 || prevResponse == 401);
        if (prevResponse != 200) {
            System.out.println(prevResponse);
            throw new IOException("Proxy tunnelling failed!");
        }
        this.acceptAllCerts();
        SSLSocket sock2 = (SSLSocket)this.context.getSocketFactory().createSocket(this.sock, this.host, this.port, true);
        sock2.startHandshake();
        this.sock = sock2;
    }

    private void skipRemainingStream(boolean isChunked, HashMap<String, String> map) throws IOException {
        long cLen = HTTPUtil.getContentLength(map);
        byte[] buf = new byte[8192];
        if (cLen > 0L) {
            while (cLen > 0L) {
                int r = (int)(cLen > (long)buf.length ? (long)buf.length : cLen);
                int x = this.in.read(buf, 0, r);
                if (x != -1) {
                    cLen -= (long)x;
                    continue;
                }
                break;
            }
        } else if (isChunked) {
            int x;
            while ((x = this.in.read(buf)) != -1) {
            }
        } else {
            int x;
            while ((x = this.in.available()) > 0) {
                if (x > buf.length) {
                    x = buf.length;
                }
                if (this.in.read(buf, 0, x) >= 1) continue;
            }
        }
    }

    public long getContentLength() {
        return HTTPUtil.getContentLength(this.resposeHeaders);
    }

    public int getResponseCode() {
        return HTTPUtil.getResponseCode(this.statusLine);
    }

    public String getContentName() {
        block5: {
            int index;
            String fm;
            block6: {
                String cd;
                block4: {
                    cd = this.resposeHeaders.get("content-disposition");
                    if (cd != null) break block4;
                    return null;
                }
                cd = cd.toLowerCase();
                if (!cd.startsWith("attachment")) break block5;
                fm = cd.split(";")[1].trim();
                index = fm.indexOf("=");
                if (index >= 0) break block6;
                return null;
            }
            try {
                return fm.substring(index + 1).trim();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private void acceptAllCerts() {
        try {
            try {
                this.context = SSLContext.getInstance("TLS");
            }
            catch (Exception e) {
                this.context = SSLContext.getInstance("SSL");
            }
            TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return new X509Certificate[0];
                }

                @Override
                public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                }
            }};
            this.context.init(null, trustAllCerts, null);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (KeyManagementException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void finishStream() throws IOException {
        String ts = this.resposeHeaders.get("transfer-encoding");
        if (ts != null && ts.equalsIgnoreCase("chunked")) {
            this.in.close();
        }
    }

    public static void main(String[] args) throws Exception {
        int a;
        XDMConfig conf = XDMConfig.load(new File(""));
        conf.useHttpsProxy = true;
        conf.useHttpProxy = true;
        conf.httpsPass = "May@2013";
        conf.httpsUser = "SD00109548";
        conf.httpUser = "SD00109548";
        conf.httpPass = "May@2013";
        conf.httpsProxyHost = "10.254.40.57";
        conf.httpsProxyPort = 80;
        conf.httpProxyHost = "10.254.40.57";
        conf.httpProxyPort = 80;
        XDMHttpClient2 client = new XDMHttpClient2(conf);
        client.user = "Techmahindra\\sd00109548";
        client.pass = "May@2013";
        client.requestHeaders.put("proxy-connection", "keep-alive");
        client.requestHeaders.put("user-agent", "Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/35.0.1916.114 Safari/537.36");
        client.connect("http://10.254.40.54:15871/cgi-bin/blockpage.cgi?ws-session=3171572021");
        client.sendRequest();
        InputStream in = client.in;
        while ((a = in.read()) >= 0) {
            System.out.print((char)a);
        }
        client.finishStream();
        System.out.println("AVAILLLL: " + client.sock.getInputStream().available());
        System.exit(0);
        in = client.sock.getInputStream();
        in.skip(in.available());
        System.out.println("=================");
        client.requestHeaders.clear();
        client.requestHeaders.put("user-agent", "Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/35.0.1916.114 Safari/537.36");
        client.reConnect("http://xdman.sourceforge.net/xdmanlogo.png");
        client.sendRequest();
        in = client.in;
        while ((a = in.read()) >= 0) {
            System.out.print((char)a);
        }
    }
}

