/*
 * Decompiled with CFR 0.152.
 */
package helliker.id3;

import helliker.id3.BinaryParser;
import helliker.id3.CorruptHeaderException;
import java.io.IOException;
import java.io.RandomAccessFile;

public class XingVBRHeader {
    private final String HEAD_START;
    private final int HEAD_SIZE;
    private final int FLAGS_SIZE;
    private final int TOC_SIZE;
    private final double[] TIMEPERFRAME_TABLE = new double[]{-1.0, 1152.0, 1152.0, 384.0};
    private int numFrames = -1;
    private int numBytes = -1;
    private int vbrScale = -1;
    private byte[] toc;
    private int avgBitrate = -1;
    private int playingTime = -1;
    private int length = -1;
    private boolean exists = false;

    private final boolean checkHeader(RandomAccessFile randomAccessFile, long l, int n, int n2) throws IOException {
        boolean bl = false;
        byte[] byArray = new byte[4];
        if (n2 == 3) {
            if (n == 3) {
                randomAccessFile.seek(l + 21L);
            } else {
                randomAccessFile.seek(l + 36L);
            }
        } else if (n == 3) {
            randomAccessFile.seek(l + 23L);
        } else {
            randomAccessFile.seek(l + 21L);
        }
        if (randomAccessFile.read(byArray) == byArray.length) {
            bl = "Xing".equals(new String(byArray));
        }
        return bl;
    }

    private final void readHeader(RandomAccessFile randomAccessFile) throws IOException, CorruptHeaderException {
        this.length = 4;
        byte[] byArray = new byte[4];
        if (randomAccessFile.read(byArray) != byArray.length) {
            throw new CorruptHeaderException("XingVBRHeader.readHeader: Unexpected end-of-file encountered");
        }
        this.length += byArray.length;
        if (BinaryParser.bitSet(byArray[3], 0)) {
            this.numFrames = randomAccessFile.readInt();
            this.length += 4;
        }
        if (BinaryParser.bitSet(byArray[3], 1)) {
            this.numBytes = randomAccessFile.readInt();
            this.length += 4;
        }
        if (BinaryParser.bitSet(byArray[3], 2)) {
            this.toc = new byte[100];
            if (randomAccessFile.read(this.toc) != this.toc.length) {
                throw new CorruptHeaderException("XingVBRHeader.readHeader: Unexpected end-of-file encountered");
            }
            this.length += 100;
        }
        if (BinaryParser.bitSet(byArray[3], 3)) {
            this.vbrScale = randomAccessFile.readInt();
            this.length += 4;
        }
        if (this.numBytes == -1 || this.numBytes == 0) {
            this.numBytes = (int)randomAccessFile.length();
        }
    }

    private final void calcValues(int n, int n2, int n3) {
        double d = this.TIMEPERFRAME_TABLE[n] / (double)n3;
        if (n2 == 2 || n2 == 0) {
            d /= 2.0;
        }
        this.playingTime = (int)(d * (double)this.numFrames);
        this.avgBitrate = (int)((double)(this.numBytes * 8) / (d * (double)this.numFrames * 1000.0));
    }

    public boolean headerExists() {
        return this.exists;
    }

    public int getNumFrames() {
        return this.numFrames;
    }

    public int getNumBytes() {
        return this.numBytes;
    }

    public int getVBRScale() {
        return this.vbrScale;
    }

    public byte[] getTOC() {
        return this.toc;
    }

    public int getAvgBitrate() {
        return this.avgBitrate;
    }

    public int getPlayingTime() {
        return this.playingTime;
    }

    public String toString() {
        return "NumFrames:\t\t\t" + this.getNumFrames() + "\nNumBytes:\t\t\t" + this.getNumBytes() + " bytes\nVBRScale:\t\t\t" + this.getVBRScale() + "\nLength:\t\t\t\t" + this.getLength() + " bytes";
    }

    public int getLength() {
        return this.length;
    }

    public XingVBRHeader(RandomAccessFile randomAccessFile, long l, int n, int n2, int n3, int n4) throws IOException, CorruptHeaderException {
        this.HEAD_START = "Xing";
        this.HEAD_SIZE = 4;
        this.FLAGS_SIZE = 4;
        this.TOC_SIZE = 100;
        this.exists = this.checkHeader(randomAccessFile, l, n4, n2);
        if (this.exists) {
            this.readHeader(randomAccessFile);
            this.calcValues(n, n2, n3);
        }
    }
}

