/*
 * Decompiled with CFR 0.152.
 */
package xnap.cmdl;

import java.util.Hashtable;
import xnap.cmdl.AbstractCommand;
import xnap.cmdl.CommandLineSupport;
import xnap.cmdl.Completer;
import xnap.cmdl.Console;
import xnap.cmdl.ParameterException;
import xnap.cmdl.SyntaxException;
import xnap.util.QuotedStringTokenizer;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Executer
implements CommandLineSupport {
    private static Executer singleton = new Executer();
    private static Console console = Console.getInstance();
    private AbstractCommand[] commands;
    private Hashtable cmdHandlers;
    private Completer fallbackCompleter;

    public AbstractCommand[] getCommands() {
        return this.commands;
    }

    public static Completer getCompleter() {
        Completer completer = console.getCompleter();
        return completer != null ? completer : Executer.singleton.fallbackCompleter;
    }

    public static synchronized void addCommand(AbstractCommand abstractCommand) {
        String[] stringArray = abstractCommand.getCommands();
        int n = 0;
        while (n < stringArray.length) {
            Executer.singleton.cmdHandlers.put(stringArray[n], abstractCommand);
            if (n == 0) {
                Executer.getCompleter().add(stringArray[n]);
            }
            ++n;
        }
    }

    public static synchronized void removeCommand(AbstractCommand abstractCommand) {
        String[] stringArray = abstractCommand.getCommands();
        int n = 0;
        while (n < stringArray.length) {
            if (Executer.singleton.cmdHandlers.get(stringArray[n]) == abstractCommand) {
                Executer.singleton.cmdHandlers.remove(stringArray[n]);
                if (n == 0) {
                    Executer.getCompleter().remove(stringArray[n]);
                }
            }
            ++n;
        }
    }

    public static void installHandler(CommandLineSupport commandLineSupport) {
        AbstractCommand[] abstractCommandArray = commandLineSupport.getCommands();
        int n = 0;
        while (n < abstractCommandArray.length) {
            Executer.addCommand(abstractCommandArray[n]);
            ++n;
        }
    }

    public static void removeHandler(CommandLineSupport commandLineSupport) {
        AbstractCommand[] abstractCommandArray = commandLineSupport.getCommands();
        int n = 0;
        while (n < abstractCommandArray.length) {
            Executer.removeCommand(abstractCommandArray[n]);
            ++n;
        }
    }

    public static synchronized boolean parseCommand(String string) {
        QuotedStringTokenizer quotedStringTokenizer;
        String[] stringArray;
        AbstractCommand abstractCommand;
        if (string == null) {
            return false;
        }
        if ((string = string.trim()).startsWith("/")) {
            string = string.substring(1);
        }
        if (string.length() == 0) {
            return true;
        }
        if (!console.isEchoing()) {
            console.println("XNap> " + string);
        }
        if ((abstractCommand = singleton.getHandler((stringArray = (quotedStringTokenizer = new QuotedStringTokenizer(string)).getTokens())[0])) != null) {
            try {
                if (!abstractCommand.execute(stringArray)) {
                    throw new SyntaxException();
                }
            }
            catch (SyntaxException syntaxException) {
                console.println("Usage: " + stringArray[0] + ' ' + abstractCommand.getParameter());
            }
            catch (ParameterException parameterException) {
                console.println(parameterException.getMessage());
            }
        } else {
            console.println("unknown command (h for help)");
        }
        return true;
    }

    protected AbstractCommand getHandler(String string) {
        return (AbstractCommand)this.cmdHandlers.get(string);
    }

    private final /* synthetic */ void this() {
        this.commands = new AbstractCommand[]{new HelpCmd(), new LicenseCmd(), new ReadmeCmd()};
        this.cmdHandlers = new Hashtable();
        this.fallbackCompleter = new Completer();
    }

    private Executer() {
        this.this();
    }

    static {
        Executer.installHandler(singleton);
    }

    protected class HelpCmd
    extends AbstractCommand {
        public boolean execute(String[] stringArray) {
            if (stringArray.length == 1) {
                String[] stringArray2 = Executer.getCompleter().getCompletions();
                int n = 0;
                while (n < stringArray2.length) {
                    AbstractCommand abstractCommand = singleton.getHandler(stringArray2[n]);
                    if (abstractCommand != null) {
                        console.println(stringArray2[n] + " - " + abstractCommand.getShortHelp());
                    }
                    ++n;
                }
            } else if (stringArray.length == 2) {
                AbstractCommand abstractCommand = singleton.getHandler(stringArray[1]);
                if (abstractCommand != null) {
                    String[] stringArray3 = abstractCommand.getCommands();
                    console.println("Command: " + stringArray3[0] + ' ' + abstractCommand.getParameter());
                    StringBuffer stringBuffer = new StringBuffer();
                    int n = 1;
                    while (n < stringArray3.length) {
                        stringBuffer.append(" ");
                        stringBuffer.append(stringArray3[n]);
                        ++n;
                    }
                    console.println("Aliases:" + stringBuffer.toString());
                    console.println("Help: " + abstractCommand.getLongHelp());
                } else {
                    console.println("Command not found.");
                }
            } else {
                return false;
            }
            return true;
        }

        public HelpCmd() {
            this.putValue("cmd", new String[]{"help", "h", "?"});
            this.putValue("parameter", "[command]");
            this.putValue("shortHelp", "Shows help about command.");
        }
    }

    protected class LicenseCmd
    extends AbstractCommand {
        public boolean execute(String[] stringArray) {
            console.printFile("COPYING");
            return true;
        }

        public LicenseCmd() {
            this.putValue("cmd", new String[]{"license"});
            this.putValue("shortHelp", "Print license.");
        }
    }

    protected class ReadmeCmd
    extends AbstractCommand {
        public boolean execute(String[] stringArray) {
            console.printFile("README");
            return true;
        }

        public ReadmeCmd() {
            this.putValue("cmd", new String[]{"readme"});
            this.putValue("shortHelp", "Print readme.");
        }
    }
}

