/*
 * Decompiled with CFR 0.152.
 */
package xnap.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JTabbedPane;
import xnap.XNap;
import xnap.cmdl.Completer;
import xnap.cmdl.IConsole;
import xnap.gui.ConsolePane;
import xnap.gui.DebugPanel;
import xnap.gui.DefaultDialog;
import xnap.util.Debug;

public class ConsoleDialog
extends DefaultDialog
implements IConsole {
    private static ConsoleDialog me = new ConsoleDialog();
    private JTabbedPane jtp;
    private ConsolePane cpConsole;
    private ConsolePane cpError;
    private DebugPanel jpDebug;

    public static ConsoleDialog getInstance() {
        return me;
    }

    public void apply() {
        this.jpDebug.apply();
    }

    public boolean isEchoing() {
        return false;
    }

    public static void showDialog(Component component, boolean bl) {
        if (component != null) {
            me.setLocationRelativeTo(component);
        }
        me.updateErrorLog();
        if (bl) {
            ConsoleDialog.me.jtp.setSelectedComponent(ConsoleDialog.me.cpError);
        }
        me.setVisible(true);
    }

    public static void showDialog(Component component) {
        ConsoleDialog.showDialog(component, false);
    }

    public void printLine(String string) {
        this.cpConsole.appendLater(string);
    }

    public String readLine(String string) {
        return null;
    }

    public Completer getCompleter() {
        return null;
    }

    public void updateErrorLog() {
        File file = Debug.getErrorFile();
        if (file == null) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            while (bufferedReader.ready()) {
                stringBuffer.append(bufferedReader.readLine() + '\n');
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.cpError.setText(stringBuffer.toString());
    }

    private ConsoleDialog() {
        super(BUTTON_APPLY);
        this.setTitle(XNap.tr("XNap Console"));
        this.setModal(false);
        this.jtp = new JTabbedPane();
        this.getMainPanel().setLayout(new BorderLayout());
        this.getMainPanel().add((Component)this.jtp, "Center");
        this.cpConsole = new ConsolePane();
        this.jtp.addTab(XNap.tr("Console"), this.cpConsole);
        this.jpDebug = new DebugPanel();
        this.jtp.addTab(XNap.tr("Debug"), this.jpDebug);
        this.cpError = new ConsolePane(false);
        this.jtp.addTab("error.log", this.cpError);
        JButton jButton = new JButton(new HideAction());
        this.getButtonPanel().add(jButton);
        this.setSize(600, 400);
    }

    private class HideAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            ConsoleDialog.this.setVisible(false);
        }

        public HideAction() {
            this.putValue("Name", XNap.tr("Hide"));
            this.putValue("ShortDescription", XNap.tr("Hides this dialog."));
        }
    }
}

