/*
 * Decompiled with CFR 0.152.
 */
package xnap.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.io.IOException;
import java.io.OutputStream;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.WriterAppender;
import xnap.XNap;
import xnap.gui.ConsolePane;
import xnap.gui.Dialogs;
import xnap.gui.EnableAction;
import xnap.gui.FilePanel;
import xnap.gui.GridBagHelper;
import xnap.util.Preferences;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class DebugPanel
extends JPanel {
    public static final int BUFFER_SIZE = 512;
    private static Preferences prefs = Preferences.getInstance();
    private JTextField jtfLayout;
    private JComboBox jcbLevel;
    private JCheckBox jcbLogToFile;
    private FilePanel fpFilename;
    private JCheckBox jcbLogToConsole;
    private ConsolePane cpDebug;
    private FileAppender apFile;
    private WriterAppender apConsole;
    private PatternLayout layout;
    private Level[] levels;

    public void apply() {
        boolean bl = this.layout.getConversionPattern().equals(this.jtfLayout.getText()) ^ true;
        Logger.getRootLogger().setLevel((Level)this.jcbLevel.getSelectedItem());
        this.layout.setConversionPattern(this.jtfLayout.getText());
        if (this.jcbLogToFile.isSelected()) {
            if (this.apFile == null || this.apFile.getFile() != this.fpFilename.getFilename()) {
                this.close(this.apFile);
                try {
                    this.apFile = new FileAppender(this.layout, this.fpFilename.getFilename(), false, true, 512);
                    Logger.getRootLogger().addAppender(this.apFile);
                }
                catch (IOException iOException) {
                    Dialogs.error(this, iOException.getLocalizedMessage());
                }
            }
        } else if (this.apFile != null) {
            this.close(this.apFile);
            this.apFile = null;
        }
        if (this.jcbLogToConsole.isSelected()) {
            if (this.apConsole == null || bl) {
                this.close(this.apConsole);
                this.apConsole = new WriterAppender((Layout)this.layout, new ConsoleOutputStream());
                this.apConsole.setLayout(this.layout);
                Logger.getRootLogger().addAppender(this.apConsole);
            }
        } else if (this.apConsole != null) {
            this.close(this.apConsole);
            this.apConsole = null;
        }
    }

    private final void close(WriterAppender writerAppender) {
        if (writerAppender != null) {
            writerAppender.close();
            Logger.getRootLogger().removeAppender(writerAppender);
        }
    }

    private final /* synthetic */ void this() {
        this.layout = new PatternLayout();
        this.levels = new Level[]{Level.ALL, Level.DEBUG, Level.INFO, Level.WARN, Level.ERROR};
    }

    public DebugPanel() {
        this.this();
        this.setLayout(new GridBagLayout());
        GridBagHelper.addLabel(this, XNap.tr("Level"));
        this.jcbLevel = new JComboBox<Level>(this.levels);
        GridBagHelper.add(this, this.jcbLevel, false);
        GridBagHelper.addLabel(this, XNap.tr("Layout"));
        this.jtfLayout = new JTextField("[%-15c{1}] [%-20.20t] %m%n");
        GridBagHelper.add((Container)this, this.jtfLayout);
        this.jcbLogToFile = new JCheckBox(XNap.tr("Log To File"));
        GridBagHelper.addComponent(this, this.jcbLogToFile);
        this.fpFilename = new FilePanel(prefs.getDebugLogFile(), 20);
        GridBagHelper.add((Container)this, this.fpFilename);
        EnableAction enableAction = new EnableAction(new Component[]{this.fpFilename}, this.jcbLogToFile);
        this.jcbLogToConsole = new JCheckBox(XNap.tr("Log To Console"));
        GridBagHelper.add((Container)this, this.jcbLogToConsole);
        this.cpDebug = new ConsolePane(false);
        this.cpDebug.setBorder(new TitledBorder(XNap.tr("Debug Console")));
        GridBagHelper.addPanel(this, this.cpDebug);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class ConsoleOutputStream
    extends OutputStream {
        private StringBuffer buffer;

        public void flush() {
            DebugPanel.this.cpDebug.appendLater(this.buffer.toString());
            this.buffer.setLength(0);
        }

        public void write(int n) {
            this.buffer.append((char)n);
            if (n == 10) {
                this.flush();
            }
        }

        private final /* synthetic */ void this() {
            this.buffer = new StringBuffer();
        }

        private ConsoleOutputStream() {
            this.this();
        }
    }
}

