/*
 * Decompiled with CFR 0.152.
 */
package xnap.gui.prefs;

import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import xnap.XNap;
import xnap.gui.AbstractPreferencesPanel;
import xnap.gui.GridBagHelper;
import xnap.gui.XNapFrame;
import xnap.util.Updater;
import xnap.util.audio.AudioSupport;
import xnap.util.audio.JMFPlayer;
import xnap.util.launcher.LauncherSupport;

public class ProgramsPrefsPanel
extends AbstractPreferencesPanel
implements ActionListener {
    public static final int ACTION_CMD = 0;
    public static final int TEXT = 1;
    public static final int OPT_VALUE = 2;
    private ButtonGroup bgMP3PlayerType;
    private JTextField jteMP3PlayerCmd;
    private ButtonGroup bgFileLauncher;
    private JTextField jtfFileLauncherCmd;

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() instanceof AbstractButton) {
            ButtonModel buttonModel = ((AbstractButton)actionEvent.getSource()).getModel();
            if (this.bgMP3PlayerType.isSelected(buttonModel)) {
                this.setText(this.jteMP3PlayerCmd, this.bgMP3PlayerType, actionEvent.getActionCommand(), AudioSupport.PLAYERS);
            } else if (this.bgFileLauncher.isSelected(buttonModel)) {
                this.setText(this.jtfFileLauncherCmd, this.bgFileLauncher, actionEvent.getActionCommand(), LauncherSupport.LAUNCHERS);
            }
        }
    }

    public void apply() {
        prefs.setMP3PlayerType(this.bgMP3PlayerType.getSelection().getActionCommand());
        prefs.setMP3PlayerCmd(this.jteMP3PlayerCmd.getText());
        prefs.setFileLauncherType(this.bgFileLauncher.getSelection().getActionCommand());
        prefs.setFileLauncherCmd(this.jtfFileLauncherCmd.getText());
    }

    public Icon getIcon() {
        return XNapFrame.getSmallIcon("folder.png");
    }

    public String getTitle() {
        return XNap.tr("Programs");
    }

    public void installButtonGroup(JPanel jPanel, ButtonGroup buttonGroup, String[][] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            JRadioButton jRadioButton = new JRadioButton(stringArray[n][1]);
            jRadioButton.setActionCommand(stringArray[n][0]);
            jRadioButton.addActionListener(this);
            buttonGroup.add(jRadioButton);
            jPanel.add(jRadioButton);
            if (stringArray[n][0].equals("jmf")) {
                jRadioButton.setEnabled(JMFPlayer.isAvailable());
            } else if (stringArray[n][0].equals("ziga.dll")) {
                jRadioButton.setEnabled(Updater.isZigaDllLoaded());
            }
            ++n;
        }
    }

    public void setSelected(ButtonGroup buttonGroup, String string) {
        AbstractButton abstractButton = null;
        Enumeration<AbstractButton> enumeration = buttonGroup.getElements();
        while (enumeration.hasMoreElements()) {
            abstractButton = enumeration.nextElement();
            if (!abstractButton.isEnabled() || !abstractButton.getActionCommand().equals(string)) continue;
            abstractButton.setSelected(true);
            return;
        }
        if (abstractButton != null) {
            abstractButton.setSelected(true);
        }
    }

    public void setText(JTextField jTextField, ButtonGroup buttonGroup, String string, String[][] stringArray) {
        int n = 0;
        Enumeration<AbstractButton> enumeration = buttonGroup.getElements();
        while (enumeration.hasMoreElements()) {
            AbstractButton abstractButton = enumeration.nextElement();
            if (abstractButton.getActionCommand().equals(string)) {
                jTextField.setEnabled(stringArray[n][0].equals("other"));
                jTextField.setText(stringArray[n][2]);
                if (jTextField.isEnabled()) {
                    jTextField.requestFocus();
                }
                return;
            }
            ++n;
        }
    }

    public void setOpt(String[][] stringArray, String string) {
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n][0].equals("other")) {
                stringArray[n][2] = string;
                break;
            }
            ++n;
        }
    }

    public ProgramsPrefsPanel() {
        this.setLayout(new GridBagLayout());
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(new TitledBorder(XNap.tr("Mp3 Player", 1)));
        GridBagHelper.add((Container)this, jPanel);
        this.bgMP3PlayerType = new ButtonGroup();
        JPanel jPanel2 = new JPanel(new GridLayout(0, 2));
        this.installButtonGroup(jPanel2, this.bgMP3PlayerType, AudioSupport.PLAYERS);
        this.setSelected(this.bgMP3PlayerType, prefs.getMP3PlayerType());
        GridBagHelper.add((Container)jPanel, jPanel2);
        GridBagHelper.addLabel(jPanel, XNap.tr("Command"));
        this.jteMP3PlayerCmd = new JTextField(20);
        this.setOpt(AudioSupport.PLAYERS, prefs.getMP3PlayerType().equals("other") ? prefs.getMP3PlayerCmd() : "");
        this.setText(this.jteMP3PlayerCmd, this.bgMP3PlayerType, prefs.getMP3PlayerType(), AudioSupport.PLAYERS);
        GridBagHelper.add((Container)jPanel, this.jteMP3PlayerCmd);
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        jPanel3.setBorder(new TitledBorder(XNap.tr("File Launcher", 1)));
        GridBagHelper.add((Container)this, jPanel3);
        this.bgFileLauncher = new ButtonGroup();
        JPanel jPanel4 = new JPanel(new GridLayout(0, 2));
        this.installButtonGroup(jPanel4, this.bgFileLauncher, LauncherSupport.LAUNCHERS);
        this.setSelected(this.bgFileLauncher, prefs.getFileLauncherType());
        GridBagHelper.add((Container)jPanel3, jPanel4);
        GridBagHelper.addLabel(jPanel3, XNap.tr("Command"));
        this.jtfFileLauncherCmd = new JTextField(20);
        this.setOpt(LauncherSupport.LAUNCHERS, prefs.getFileLauncherType().equals("other") ? prefs.getFileLauncherCmd() : "");
        this.setText(this.jtfFileLauncherCmd, this.bgFileLauncher, prefs.getFileLauncherType(), LauncherSupport.LAUNCHERS);
        GridBagHelper.add((Container)jPanel3, this.jtfFileLauncherCmd);
        GridBagHelper.addVerticalSpacer(this);
    }
}

