/*
 * Decompiled with CFR 0.152.
 */
package xnap.gui.table;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import javax.swing.JMenu;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumnModel;
import xnap.gui.menu.TableColumnsMenu;
import xnap.gui.table.AbstractSortableTableModel;
import xnap.gui.table.Column;
import xnap.gui.table.TableHeaderListener;
import xnap.util.TablePreferencesSupport;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class AbstractDynamicTableModel
extends AbstractSortableTableModel
implements PropertyChangeListener {
    protected Column[] columns;
    protected JTable jta;
    protected String table;
    protected TablePreferencesSupport tps;

    public JTable createJTable() {
        if (this.jta == null) {
            DefaultTableColumnModel defaultTableColumnModel = new DefaultTableColumnModel();
            this.setModel(defaultTableColumnModel);
            if (this.tps != null) {
                defaultTableColumnModel.addColumnModelListener(new ColumnListener());
                this.jta = new JTable(this, defaultTableColumnModel);
                this.setVisible(this.tps.getTableColumnsArray(this.table), this.jta);
                this.setMaintainSortOrder(this.tps.getTableMaintainSortOrder(this.table));
                TableColumnsMenu tableColumnsMenu = new TableColumnsMenu(this.table, this.getColumnNames(), this.tps);
                TableHeaderListener.install(this.jta, tableColumnsMenu.getPopupMenu());
            } else {
                this.jta = new JTable(this);
                TableHeaderListener.install(this.jta);
            }
        }
        return this.jta;
    }

    public JMenu createJMenu() {
        return new TableColumnsMenu(this);
    }

    public Class getColumnClass(int n) {
        return this.columns[n].getDataType();
    }

    public int getColumnCount() {
        return this.columns.length;
    }

    public String getColumnName(int n) {
        return this.columns[n].getName();
    }

    public String[] getColumnNames() {
        String[] stringArray = new String[this.columns.length];
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = this.columns[n].getName();
            ++n;
        }
        return stringArray;
    }

    public Column[] getColumns() {
        return this.columns;
    }

    public TablePreferencesSupport getPreferencesSupport() {
        return this.tps;
    }

    public String getTableIdentifier() {
        return this.table;
    }

    public abstract String getTableName();

    public void setColumns(Column[] columnArray) {
        this.columns = columnArray;
        if (this.tps != null) {
            int[] nArray = this.tps.getTableColumnWidths(this.table);
            int n = 0;
            while (n < nArray.length && n < columnArray.length) {
                columnArray[n].setPreferredWidth(nArray[n]);
                columnArray[n].setWidth(nArray[n]);
                ++n;
            }
            n = this.tps.getTableSortedColumn(this.table);
            if (n != 0) {
                boolean bl = false;
                if (n > 0) {
                    bl = true;
                }
                this.setSortedAscending(bl);
                this.sortByColumn(Math.abs(n) - 1, false);
            }
        }
    }

    public void setModel(TableColumnModel tableColumnModel) {
        int n = 0;
        while (n < this.columns.length) {
            this.columns[n].setModel(tableColumnModel);
            this.columns[n].setModelIndex(n);
            ++n;
        }
    }

    public void setVisible(int[] nArray, JTable jTable) {
        int n;
        boolean[] blArray = new boolean[this.columns.length];
        Arrays.fill(blArray, false);
        int n2 = 0;
        while (n2 < nArray.length) {
            n = nArray[n2];
            if (n >= 0 && n < this.columns.length) {
                blArray[n] = true;
            }
            ++n2;
        }
        n2 = 0;
        n = 0;
        while (n < this.columns.length) {
            n2 |= blArray[n];
            this.columns[n].setVisible(blArray[n]);
            ++n;
        }
        if (n2 == 0 && this.columns.length > 0) {
            this.columns[0].setVisible(true);
        }
    }

    public void setVisible(int[] nArray) {
        this.setVisible(nArray, null);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (this.tps != null) {
            this.setVisible(this.tps.getTableColumnsArray(this.table), this.jta);
            this.setMaintainSortOrder(this.tps.getTableMaintainSortOrder(this.table));
        }
    }

    public void saveColumnWidths() {
        if (this.tps != null) {
            int[] nArray = new int[this.columns.length];
            int n = 0;
            while (n < nArray.length) {
                nArray[n] = this.columns[n].getWidth();
                ++n;
            }
            this.tps.setTableColumnWidths(this.table, nArray);
        }
    }

    public void saveSortedColumn() {
        if (this.tps != null) {
            int n = this.getLastSortedColumn();
            n = n == -1 ? 0 : (this.isSortedAscending() ? n : -(++n));
            this.tps.setTableSortedColumn(this.table, n);
        }
    }

    private final /* synthetic */ void this() {
        this.columns = new Column[0];
        this.jta = null;
    }

    public AbstractDynamicTableModel(String string, TablePreferencesSupport tablePreferencesSupport) {
        this.this();
        this.table = string;
        this.tps = tablePreferencesSupport;
        if (tablePreferencesSupport != null) {
            this.setMaintainSortOrder(tablePreferencesSupport.getTableMaintainSortOrder(string));
            tablePreferencesSupport.addTableListener(string, this);
        }
    }

    public AbstractDynamicTableModel() {
        this.this();
    }

    protected class ColumnListener
    implements TableColumnModelListener {
        public void columnAdded(TableColumnModelEvent tableColumnModelEvent) {
        }

        public void columnMarginChanged(ChangeEvent changeEvent) {
        }

        public void columnMoved(TableColumnModelEvent tableColumnModelEvent) {
            if (AbstractDynamicTableModel.this.tps != null) {
                TableColumnModel tableColumnModel = (TableColumnModel)tableColumnModelEvent.getSource();
                int[] nArray = new int[tableColumnModel.getColumnCount()];
                int n = 0;
                while (n < nArray.length) {
                    nArray[n] = tableColumnModel.getColumn(n).getModelIndex();
                    ++n;
                }
                AbstractDynamicTableModel.this.tps.setTableColumns(AbstractDynamicTableModel.this.table, nArray);
            }
        }

        public void columnRemoved(TableColumnModelEvent tableColumnModelEvent) {
        }

        public void columnSelectionChanged(ListSelectionEvent listSelectionEvent) {
        }

        protected ColumnListener() {
        }
    }
}

