/*
 * Decompiled with CFR 0.152.
 */
package xnap.net;

import java.io.File;
import xnap.net.AutoDownload;
import xnap.net.IDownload;
import xnap.net.ISearchResult;
import xnap.net.IUser;
import xnap.plugin.INetworkPlugin;
import xnap.util.DownloadQueue;
import xnap.util.SearchFilter;

public abstract class AbstractSearchResult
implements ISearchResult {
    protected String filename;
    protected IUser user;
    protected String hash;
    protected int length;
    protected int bitrate;
    protected int frequency;
    protected INetworkPlugin plugin;
    protected int score;
    protected long size;

    public boolean equals(Object object) {
        if (object instanceof AbstractSearchResult) {
            AbstractSearchResult abstractSearchResult = (AbstractSearchResult)object;
            boolean bl = false;
            if (this.getBitrate() == abstractSearchResult.getBitrate() && this.getFilename().equals(abstractSearchResult.getFilename()) && this.getFilesize() == abstractSearchResult.getFilesize() && this.getFrequency() == abstractSearchResult.getFrequency() && this.getHash().equals(abstractSearchResult.getHash()) && this.getLength() == abstractSearchResult.getLength() && this.getUser().equals(abstractSearchResult.getUser())) {
                bl = true;
            }
            return bl;
        }
        return false;
    }

    public int getBitrate() {
        return this.bitrate;
    }

    public boolean canGroup() {
        return true;
    }

    public abstract IDownload getDownload();

    public boolean download(SearchFilter searchFilter, File file) {
        AutoDownload autoDownload = new AutoDownload(new ISearchResult[]{this}, searchFilter, file);
        return DownloadQueue.getInstance().add(autoDownload);
    }

    public String getFilename() {
        return this.filename;
    }

    public long getFilesize() {
        return this.size;
    }

    public int getFrequency() {
        return this.frequency;
    }

    public String getHash() {
        return this.hash;
    }

    public int getLength() {
        return this.length;
    }

    public String[] getPath() {
        return null;
    }

    public INetworkPlugin getPlugin() {
        return this.plugin;
    }

    public int getScore() {
        return this.score;
    }

    public ISearchResult[] getSearchResults() {
        return new ISearchResult[]{this};
    }

    public abstract String getShortFilename();

    public String toString() {
        return this.getShortFilename() + ", " + this.getUser();
    }

    public IUser getUser() {
        return this.user;
    }

    protected AbstractSearchResult(long l, int n, int n2, int n3, IUser iUser, String string, String string2, INetworkPlugin iNetworkPlugin) {
        this.size = l;
        this.filename = string;
        this.user = iUser;
        this.hash = string2;
        this.length = n3;
        this.bitrate = n;
        this.frequency = n2;
        this.plugin = iNetworkPlugin;
        this.score = 1;
    }
}

