/*
 * Decompiled with CFR 0.152.
 */
package xnap.plugin.nap;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import xnap.gui.AbstractPreferencesPanel;
import xnap.gui.StatusPanel;
import xnap.gui.UserActionFactory;
import xnap.gui.UserActionManager;
import xnap.gui.XNapFrame;
import xnap.gui.action.AddToHotlistAction;
import xnap.gui.action.BrowseAction;
import xnap.gui.action.ChatAction;
import xnap.gui.action.EditUserAction;
import xnap.net.IUser;
import xnap.plugin.IGUIPlugin;
import xnap.plugin.nap.Plugin;
import xnap.plugin.nap.gui.ConsolePanel;
import xnap.plugin.nap.gui.NapAdvancedPreferencesPanel;
import xnap.plugin.nap.gui.NapPreferencesPanel;
import xnap.plugin.nap.gui.NapServerPreferencesPanel;
import xnap.plugin.nap.gui.ServerPanel;
import xnap.plugin.nap.gui.WhoisPanel;
import xnap.plugin.nap.gui.WizardPanel;
import xnap.plugin.nap.net.DirectBrowse;
import xnap.plugin.nap.net.GlobalUser;
import xnap.plugin.nap.net.User;
import xnap.plugin.nap.net.msg.MessageHandler;
import xnap.plugin.nap.net.msg.client.WhoisRequestMessage;
import xnap.plugin.nap.util.Connector;
import xnap.user.UserManager;
import xnap.util.Preferences;
import xnap.util.SearchManager;
import xnap.util.event.StatusListener;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class GUIPlugin
extends Plugin
implements IGUIPlugin,
StatusListener {
    private JMenu menu;
    private JTabbedPane napPane;
    private ConsolePanel consolePanel;
    private ServerPanel serverPanel;
    private WhoisPanel whoisPanel;
    private StatusPanel statusPanel;
    private Preferences prefs;
    static /* synthetic */ Class class$xnap$plugin$nap$net$GlobalUser;
    static /* synthetic */ Class class$xnap$plugin$nap$net$User;

    public void start() {
        this.napPane = new JTabbedPane();
        this.napPane.setName("opennap");
        this.serverPanel = new ServerPanel();
        this.napPane.add(Plugin.tr("Server"), this.serverPanel);
        this.whoisPanel = new WhoisPanel();
        this.whoisPanel.setName("whois");
        this.napPane.add(Plugin.tr("Whois"), this.whoisPanel);
        this.consolePanel = new ConsolePanel();
        this.napPane.add(Plugin.tr("Console"), this.consolePanel);
        this.menu = this.getMenu();
        JMenu jMenu = new JMenu(Plugin.tr("Startup"));
        this.menu.add(jMenu);
        jMenu.add(new UseAutoConnectorAction().getCheckBoxMenuItem());
        this.menu.addSeparator();
        this.menu.add(new JMenuItem(new AddUserToHotlistAction()));
        this.menu.addSeparator();
        JMenuItem jMenuItem = new JMenuItem(this.serverPanel.getAskNapigatorAction());
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(78, 2));
        this.menu.add(jMenuItem);
        this.statusPanel = new StatusPanel(this);
        Connector.getInstance().addStatsListener(this);
        UserActionManager userActionManager = UserActionManager.getInstance();
        Class clazz = class$xnap$plugin$nap$net$GlobalUser;
        if (clazz == null) {
            clazz = class$xnap$plugin$nap$net$GlobalUser = GUIPlugin.class$("[Lxnap.plugin.nap.net.GlobalUser;", false);
        }
        userActionManager.install(clazz, new GlobalActionFactory());
        UserActionManager userActionManager2 = UserActionManager.getInstance();
        Class clazz2 = class$xnap$plugin$nap$net$User;
        if (clazz2 == null) {
            clazz2 = class$xnap$plugin$nap$net$User = GUIPlugin.class$("[Lxnap.plugin.nap.net.User;", false);
        }
        userActionManager2.install(clazz2, new ActionFactory());
        super.start();
    }

    public void stop() {
        this.menu.removeAll();
        UserActionManager userActionManager = UserActionManager.getInstance();
        Class clazz = class$xnap$plugin$nap$net$GlobalUser;
        if (clazz == null) {
            clazz = class$xnap$plugin$nap$net$GlobalUser = GUIPlugin.class$("[Lxnap.plugin.nap.net.GlobalUser;", false);
        }
        userActionManager.uninstall(clazz);
        UserActionManager userActionManager2 = UserActionManager.getInstance();
        Class clazz2 = class$xnap$plugin$nap$net$User;
        if (clazz2 == null) {
            clazz2 = class$xnap$plugin$nap$net$User = GUIPlugin.class$("[Lxnap.plugin.nap.net.User;", false);
        }
        userActionManager2.uninstall(clazz2);
        Connector.getInstance().removeStatsListener(this);
        super.stop();
        this.consolePanel.die();
    }

    public Icon getIcon() {
        return XNapFrame.getBigIcon("network_local.png");
    }

    public JMenu getMenu() {
        if (this.menu == null) {
            this.menu = new JMenu("OpenNap");
        }
        return this.menu;
    }

    public JComponent getPanel() {
        return this.napPane;
    }

    public Icon getPreferencesIcon() {
        return XNapFrame.getSmallIcon("network_local.png");
    }

    public AbstractPreferencesPanel[] getPrefsPanels() {
        return new AbstractPreferencesPanel[]{new NapPreferencesPanel(), new NapAdvancedPreferencesPanel(), new NapServerPreferencesPanel()};
    }

    public AbstractPreferencesPanel getWizardPanel() {
        return new WizardPanel();
    }

    public JComponent getStatusPanel() {
        return this.statusPanel;
    }

    public void setStatus(String string) {
        this.statusPanel.update();
    }

    public void setStatusListener(StatusListener statusListener) {
        this.serverPanel.setStatusListener(statusListener);
        this.whoisPanel.setStatusListener(statusListener);
        this.consolePanel.setStatusListener(statusListener);
    }

    static /* synthetic */ Class class$(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.prefs = Preferences.getInstance();
    }

    public GUIPlugin() {
        this.this();
    }

    public class ActionFactory
    implements UserActionFactory {
        public AbstractAction[] create(IUser[] iUserArray) {
            User[] userArray = new User[iUserArray.length];
            System.arraycopy(iUserArray, 0, userArray, 0, userArray.length);
            return new AbstractAction[]{new DirectBrowseAction(userArray), new BrowseAction(iUserArray), new ChatAction(iUserArray), new WhoisAction(userArray), new LookupAction(iUserArray), new AddToHotlistAction(iUserArray), new EditUserAction(iUserArray)};
        }
    }

    public class GlobalActionFactory
    implements UserActionFactory {
        public AbstractAction[] create(IUser[] iUserArray) {
            return new AbstractAction[]{new EditUserAction(iUserArray), new LookupAction(iUserArray), new BrowseAction(iUserArray), new ChatAction(iUserArray)};
        }
    }

    public class AddUserToHotlistAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            String string = JOptionPane.showInputDialog(GUIPlugin.this.napPane, Plugin.tr("Nick"), Plugin.tr("Add User To Hotlist"), 3);
            if (string != null && string.trim().length() > 0) {
                GlobalUser globalUser = User.getParentByName(string.trim());
                globalUser.setCategory(Plugin.tr("Hotlist"));
                globalUser.setTemporary(false);
                UserManager.getInstance().write();
            }
        }

        public AddUserToHotlistAction() {
            this.putValue("Name", Plugin.tr("Add User To Hotlist") + "...");
            this.putValue("ShortDescription", Plugin.tr("Add any user to the hotlist."));
            this.putValue("SmallIcon", XNapFrame.getIcon("edit_add.png"));
        }
    }

    public class DirectBrowseAction
    extends AbstractAction {
        private User[] users;

        public void actionPerformed(ActionEvent actionEvent) {
            boolean bl = false;
            if ((actionEvent.getModifiers() & 2) > 0) {
                bl = true;
            }
            boolean bl2 = bl;
            int n = 0;
            while (n < this.users.length) {
                if (bl2) {
                    XNapFrame.setNextFocusPolicy(GUIPlugin.this.prefs.getFocusOnAllEvents() ^ true);
                }
                SearchManager.getInstance().browse(new DirectBrowse(this.users[n]));
                ++n;
            }
        }

        public DirectBrowseAction(User[] userArray) {
            this.users = userArray;
            this.putValue("Name", Plugin.tr("Direct Browse"));
            this.putValue("ShortDescription", Plugin.tr("Directly browse selected user"));
            this.putValue("SmallIcon", XNapFrame.getIcon("run.png"));
        }
    }

    private class LookupAction
    extends AbstractAction {
        private IUser[] users;

        public void actionPerformed(ActionEvent actionEvent) {
            int n = 0;
            while (n < this.users.length) {
                WhoisRequestMessage whoisRequestMessage = new WhoisRequestMessage(this.users[n].getName());
                MessageHandler.send(whoisRequestMessage);
                ++n;
            }
            if ((actionEvent.getModifiers() & 2) > 0) {
                XNapFrame.setNextFocusPolicy(GUIPlugin.this.prefs.getFocusOnAllEvents() ^ true);
            }
            XNapFrame.setFocusTo("opennap.whois");
        }

        public LookupAction(IUser[] iUserArray) {
            this.users = iUserArray;
            this.putValue("Name", Plugin.tr("Lookup"));
            this.putValue("ShortDescription", Plugin.tr("Do a whois query on all connected servers"));
            this.putValue("SmallIcon", XNapFrame.getIcon("viewmag_plus.png"));
        }
    }

    public class WhoisAction
    extends AbstractAction {
        private User[] users;

        public void actionPerformed(ActionEvent actionEvent) {
            int n = 0;
            while (n < this.users.length) {
                GUIPlugin.this.whoisPanel.addUser(this.users[n]);
                ++n;
            }
            if ((actionEvent.getModifiers() & 2) > 0) {
                XNapFrame.setNextFocusPolicy(GUIPlugin.this.prefs.getFocusOnAllEvents() ^ true);
            }
            XNapFrame.setFocusTo("opennap.whois");
        }

        public WhoisAction(User[] userArray) {
            this.users = userArray;
            this.putValue("Name", Plugin.tr("Whois"));
            this.putValue("ShortDescription", Plugin.tr("Get information about selected user"));
            this.putValue("SmallIcon", XNapFrame.getIcon("viewmag.png"));
        }
    }

    public class UseAutoConnectorAction
    extends AbstractAction
    implements PropertyChangeListener {
        JCheckBoxMenuItem jmi;

        public void actionPerformed(ActionEvent actionEvent) {
            GUIPlugin.this.napPrefs.setUseAutoconnector(this.jmi.isSelected());
        }

        public JCheckBoxMenuItem getCheckBoxMenuItem() {
            return this.jmi;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            this.jmi.setSelected(GUIPlugin.this.napPrefs.getUseAutoconnector());
        }

        public UseAutoConnectorAction() {
            this.putValue("Name", Plugin.tr("Connect automatically"));
            this.jmi = new JCheckBoxMenuItem(this);
            this.jmi.setSelected(GUIPlugin.this.napPrefs.getUseAutoconnector());
            GUIPlugin.this.napPrefs.addPropertyChangeListener("useAutoconnector", this);
        }
    }
}

