/*
 * Decompiled with CFR 0.152.
 */
package xnap.plugin.nap.net.msg.server;

import xnap.plugin.nap.net.Server;
import xnap.plugin.nap.net.msg.server.AcceptFailedMessage;
import xnap.plugin.nap.net.msg.server.AllChannelListEntryMessage;
import xnap.plugin.nap.net.msg.server.AltDownloadAckMessage;
import xnap.plugin.nap.net.msg.server.BlockedFileMessage;
import xnap.plugin.nap.net.msg.server.BrowseResponseMessage;
import xnap.plugin.nap.net.msg.server.ChannelListEntryMessage;
import xnap.plugin.nap.net.msg.server.ChannelTopicMessage;
import xnap.plugin.nap.net.msg.server.ChannelUserListEntryMessage;
import xnap.plugin.nap.net.msg.server.ClientDisconnectMessage;
import xnap.plugin.nap.net.msg.server.ClientStatisticsMessage;
import xnap.plugin.nap.net.msg.server.DirectBrowseAckMessage;
import xnap.plugin.nap.net.msg.server.DirectBrowseErrorMessage;
import xnap.plugin.nap.net.msg.server.DirectBrowseRequestMessage;
import xnap.plugin.nap.net.msg.server.DownloadAckMessage;
import xnap.plugin.nap.net.msg.server.EmoteMessage;
import xnap.plugin.nap.net.msg.server.EndAllChannelListMessage;
import xnap.plugin.nap.net.msg.server.EndBrowseMessage;
import xnap.plugin.nap.net.msg.server.EndChannelListMessage;
import xnap.plugin.nap.net.msg.server.EndChannelUserListMessage;
import xnap.plugin.nap.net.msg.server.EndSearchMessage;
import xnap.plugin.nap.net.msg.server.ErrorMessage;
import xnap.plugin.nap.net.msg.server.GetErrorMessage;
import xnap.plugin.nap.net.msg.server.GlobalMessage;
import xnap.plugin.nap.net.msg.server.HotlistAckMessage;
import xnap.plugin.nap.net.msg.server.HotlistErrorMessage;
import xnap.plugin.nap.net.msg.server.InvalidMessageException;
import xnap.plugin.nap.net.msg.server.InvalidNickMessage;
import xnap.plugin.nap.net.msg.server.JoinAckMessage;
import xnap.plugin.nap.net.msg.server.JoinMessage;
import xnap.plugin.nap.net.msg.server.LoginAckMessage;
import xnap.plugin.nap.net.msg.server.LoginAttemptMessage;
import xnap.plugin.nap.net.msg.server.LoginErrorMessage;
import xnap.plugin.nap.net.msg.server.MotdMessage;
import xnap.plugin.nap.net.msg.server.NickAlreadyRegisteredMessage;
import xnap.plugin.nap.net.msg.server.NickNotRegisteredMessage;
import xnap.plugin.nap.net.msg.server.PartChannelMessage;
import xnap.plugin.nap.net.msg.server.PingMessage;
import xnap.plugin.nap.net.msg.server.PingUserMessage;
import xnap.plugin.nap.net.msg.server.PongUserMessage;
import xnap.plugin.nap.net.msg.server.PrivateMessage;
import xnap.plugin.nap.net.msg.server.PublicMessage;
import xnap.plugin.nap.net.msg.server.QueueLimitMessage;
import xnap.plugin.nap.net.msg.server.RedirectClientMessage;
import xnap.plugin.nap.net.msg.server.SearchResponseMessage;
import xnap.plugin.nap.net.msg.server.ServerLinksMessage;
import xnap.plugin.nap.net.msg.server.ServerMessage;
import xnap.plugin.nap.net.msg.server.ServerStatisticsMessage;
import xnap.plugin.nap.net.msg.server.ServerStatsMessage;
import xnap.plugin.nap.net.msg.server.UnshareAllFilesMessage;
import xnap.plugin.nap.net.msg.server.UploadRequestMessage;
import xnap.plugin.nap.net.msg.server.UserPartedChannelMessage;
import xnap.plugin.nap.net.msg.server.UserSignoffMessage;
import xnap.plugin.nap.net.msg.server.UserSignonMessage;
import xnap.plugin.nap.net.msg.server.WhoisResponseMessage;
import xnap.plugin.nap.net.msg.server.WhowasResponseMessage;

public class MessageFactory {
    public static final int LOGIN_ERROR = 0;
    public static final int LOGIN_ACK = 3;
    public static final int NICK_NOT_REGISTERED = 8;
    public static final int NICK_ALREADY_REGISTERED = 9;
    public static final int INVALID_NICK = 10;
    public static final int UNSHARE_ALL_FILES = 110;
    public static final int SEARCH_RESPONSE = 201;
    public static final int END_SEARCH_RESPONSE = 202;
    public static final int DOWNLOAD_ACK = 204;
    public static final int PRIVATE_MESSAGE = 205;
    public static final int GET_ERROR = 206;
    public static final int USER_SIGNON = 209;
    public static final int USER_SIGNOFF = 210;
    public static final int BROWSE_RESPONSE = 212;
    public static final int END_BROWSE_LIST = 213;
    public static final int SERVER_STATS = 214;
    public static final int RESUME_SEARCH_RESPONSE = 216;
    public static final int END_RESUME_SEARCH = 217;
    public static final int HOTLIST_ACK = 301;
    public static final int HOTLIST_ERROR = 302;
    public static final int CLIENT_DISCONNECT = 316;
    public static final int USER_IGNORE_LIST = 320;
    public static final int USER_IGNORE_LIST_ENTRY = 321;
    public static final int ADD_USER_TO_IGNORE_LIST = 322;
    public static final int USER_NOT_IGNORED = 324;
    public static final int USER_ALREADY_IGNORED = 325;
    public static final int CLEAR_IGNORE_LIST = 326;
    public static final int PART_CHANNEL = 401;
    public static final int PUBLIC_MESSAGE = 403;
    public static final int ERROR_MESSAGE = 404;
    public static final int JOIN_ACK = 405;
    public static final int JOIN_MESSAGE = 406;
    public static final int USER_PARTED_CHANNEL = 407;
    public static final int CHANNEL_USER_LIST_ENTRY = 408;
    public static final int END_CHANNEL_USER_LIST = 409;
    public static final int CHANNEL_BAN_LIST = 420;
    public static final int CHANNEL_BAN_LIST_ENTRY = 421;
    public static final int CHANNEL_MOTD = 425;
    public static final int INVITE_USER = 430;
    public static final int ALTERNATE_DOWNLOAD_ACK = 501;
    public static final int SPEED_RESPONSE = 601;
    public static final int WHOIS_RESPONSE = 604;
    public static final int WHOWAS_RESPONSE = 605;
    public static final int UPLOAD_REQUEST = 607;
    public static final int ACCEPT_FAILED = 609;
    public static final int SET_DATA_PORT = 613;
    public static final int BAN_LIST_ENTRY = 616;
    public static final int LIST_CHANNELS = 617;
    public static final int CHANNEL_LIST_ENTRY = 618;
    public static final int QUEUE_LIMIT = 620;
    public static final int MOTD = 621;
    public static final int DATA_PORT_ERROR = 626;
    public static final int OPERATOR_MESSAGE = 627;
    public static final int GLOBAL_MESSAGE = 628;
    public static final int BANNED_USERS = 629;
    public static final int DIRECT_BROWSE_REQUEST = 640;
    public static final int DIRECT_BROWSE_ACCEPT = 641;
    public static final int DIRECT_BROWSE_ERROR = 642;
    public static final int LOGIN_ATTEMPT = 748;
    public static final int SERVER_PING = 750;
    public static final int PING_USER = 751;
    public static final int PONG_RESPONSE = 752;
    public static final int CYCLE_CLIENT = 822;
    public static final int EMOTE = 824;
    public static final int USER_LIST_ENTRY = 825;
    public static final int END_CHANNEL_LIST = 827;
    public static final int CHANNEL_LIST = 828;
    public static final int END_USER_LIST = 830;
    public static final int CONNECTION_TEST = 900;
    public static final int LISTEN_TEST = 901;
    public static final int BLOCKED_FILE = 931;

    public static ServerMessage create(Server server, int n, String string) throws InvalidMessageException {
        ServerMessage serverMessage;
        switch (n) {
            case 0: {
                serverMessage = new LoginErrorMessage(string);
                break;
            }
            case 3: {
                serverMessage = new LoginAckMessage(string);
                break;
            }
            case 8: {
                serverMessage = new NickNotRegisteredMessage(string);
                break;
            }
            case 9: {
                serverMessage = new NickAlreadyRegisteredMessage(string);
                break;
            }
            case 10: {
                serverMessage = new InvalidNickMessage(string);
                break;
            }
            case 110: {
                serverMessage = new UnshareAllFilesMessage(string);
                break;
            }
            case 201: {
                serverMessage = new SearchResponseMessage(string);
                break;
            }
            case 202: {
                serverMessage = new EndSearchMessage(string);
                break;
            }
            case 204: {
                serverMessage = new DownloadAckMessage(string);
                break;
            }
            case 205: {
                serverMessage = new PrivateMessage(string);
                break;
            }
            case 206: {
                serverMessage = new GetErrorMessage(string);
                break;
            }
            case 209: {
                serverMessage = new UserSignonMessage(string);
                break;
            }
            case 210: {
                serverMessage = new UserSignoffMessage(string);
                break;
            }
            case 212: {
                serverMessage = new BrowseResponseMessage(string);
                break;
            }
            case 213: {
                serverMessage = new EndBrowseMessage(string);
                break;
            }
            case 214: {
                serverMessage = new ServerStatsMessage(string);
                break;
            }
            case 301: {
                serverMessage = new HotlistAckMessage(string);
                break;
            }
            case 302: {
                serverMessage = new HotlistErrorMessage(string);
                break;
            }
            case 316: {
                serverMessage = new ClientDisconnectMessage(string);
                break;
            }
            case 401: {
                serverMessage = new PartChannelMessage(string);
                break;
            }
            case 403: {
                serverMessage = new PublicMessage(string);
                break;
            }
            case 404: {
                serverMessage = new ErrorMessage(string);
                break;
            }
            case 405: {
                serverMessage = new JoinAckMessage(string);
                break;
            }
            case 406: {
                serverMessage = new JoinMessage(string);
                break;
            }
            case 407: {
                serverMessage = new UserPartedChannelMessage(string);
                break;
            }
            case 408: {
                serverMessage = new ChannelUserListEntryMessage(string);
                break;
            }
            case 409: {
                serverMessage = new EndChannelUserListMessage(string);
                break;
            }
            case 410: {
                serverMessage = new ChannelTopicMessage(string);
                break;
            }
            case 501: {
                serverMessage = new AltDownloadAckMessage(string);
                break;
            }
            case 604: {
                serverMessage = new WhoisResponseMessage(string);
                break;
            }
            case 605: {
                serverMessage = new WhowasResponseMessage(string);
                break;
            }
            case 607: {
                serverMessage = new UploadRequestMessage(string);
                break;
            }
            case 609: {
                serverMessage = new AcceptFailedMessage(string);
                break;
            }
            case 617: {
                serverMessage = new EndChannelListMessage(string);
                break;
            }
            case 618: {
                serverMessage = new ChannelListEntryMessage(string);
                break;
            }
            case 620: {
                serverMessage = new QueueLimitMessage(string);
                break;
            }
            case 621: {
                serverMessage = new MotdMessage(string);
                break;
            }
            case 628: {
                serverMessage = new GlobalMessage(string);
                break;
            }
            case 640: {
                serverMessage = new DirectBrowseRequestMessage(string);
                break;
            }
            case 641: {
                serverMessage = new DirectBrowseAckMessage(string);
                break;
            }
            case 642: {
                serverMessage = new DirectBrowseErrorMessage(string);
                break;
            }
            case 748: {
                serverMessage = new LoginAttemptMessage(string);
                break;
            }
            case 750: {
                serverMessage = new PingMessage(string);
                break;
            }
            case 751: {
                serverMessage = new PingUserMessage(string);
                break;
            }
            case 752: {
                serverMessage = new PongUserMessage(string);
                break;
            }
            case 821: {
                serverMessage = new RedirectClientMessage(string);
                break;
            }
            case 824: {
                serverMessage = new EmoteMessage(string);
                break;
            }
            case 827: {
                serverMessage = new EndAllChannelListMessage(string);
                break;
            }
            case 828: {
                serverMessage = new AllChannelListEntryMessage(string);
                break;
            }
            case 931: {
                serverMessage = new BlockedFileMessage(string);
                break;
            }
            case 10112: {
                serverMessage = new ServerLinksMessage(string);
                break;
            }
            case 10115: {
                serverMessage = new ServerStatisticsMessage(string);
                break;
            }
            case 10118: {
                serverMessage = new ClientStatisticsMessage(string);
                break;
            }
            default: {
                throw new InvalidMessageException("Unknown message type: " + n + ' ' + string);
            }
        }
        serverMessage.setServer(server);
        return serverMessage;
    }

    public static String getMessageName(int n) {
        String string;
        switch (n) {
            case 0: {
                string = "Login Error";
                break;
            }
            case 3: {
                string = "LoginAck";
                break;
            }
            case 8: {
                string = "NickNotRegistered";
                break;
            }
            case 9: {
                string = "NickAlreadyRegistered";
                break;
            }
            case 10: {
                string = "InvalidNick";
                break;
            }
            case 110: {
                string = "UnshareAllFiles";
                break;
            }
            case 201: {
                string = "SearchResponse";
                break;
            }
            case 202: {
                string = "EndSearch";
                break;
            }
            case 204: {
                string = "DownloadAck";
                break;
            }
            case 205: {
                string = "Private";
                break;
            }
            case 206: {
                string = "GetError";
                break;
            }
            case 209: {
                string = "UserSignon";
                break;
            }
            case 210: {
                string = "UserSignoff";
                break;
            }
            case 212: {
                string = "BrowseResponse";
                break;
            }
            case 213: {
                string = "EndBrowse";
                break;
            }
            case 214: {
                string = "ServerStats";
                break;
            }
            case 216: {
                string = "ResumeSearchResponse";
                break;
            }
            case 217: {
                string = "EndResumeSearchResponse";
                break;
            }
            case 301: {
                string = "HotlistAck";
                break;
            }
            case 302: {
                string = "HotlistError";
                break;
            }
            case 316: {
                string = "ClientDisconnect";
                break;
            }
            case 320: {
                string = "UserIgnoreList";
                break;
            }
            case 321: {
                string = "UserIgnoreListEntry";
                break;
            }
            case 322: {
                string = "AddUserToIgnoreList";
                break;
            }
            case 324: {
                string = "UserNotIgnored";
                break;
            }
            case 325: {
                string = "UserAlreadyIgnored";
                break;
            }
            case 326: {
                string = "ClearIgnoreList";
                break;
            }
            case 401: {
                string = "PartChannel";
                break;
            }
            case 403: {
                string = "Public";
                break;
            }
            case 404: {
                string = "Error";
                break;
            }
            case 405: {
                string = "JoinAck";
                break;
            }
            case 406: {
                string = "Join";
                break;
            }
            case 407: {
                string = "UserPartedChannel";
                break;
            }
            case 408: {
                string = "ChannelUserListEntry";
                break;
            }
            case 409: {
                string = "EndChannelUserList";
                break;
            }
            case 410: {
                string = "ChannelTopic";
                break;
            }
            case 420: {
                string = "EndChannelBanList";
                break;
            }
            case 421: {
                string = "ChannelBanListEntry";
                break;
            }
            case 425: {
                string = "ChannelMotd";
                break;
            }
            case 430: {
                string = "InviteUser";
                break;
            }
            case 501: {
                string = "AltDownloadAck";
                break;
            }
            case 601: {
                string = "LinkSpeedResponse";
                break;
            }
            case 604: {
                string = "WhoisResponse";
                break;
            }
            case 605: {
                string = "WhowasResponse";
                break;
            }
            case 607: {
                string = "UploadRequest";
                break;
            }
            case 609: {
                string = "AcceptFailed";
                break;
            }
            case 613: {
                string = "SetDataPortForUser";
                break;
            }
            case 616: {
                string = "BanListEntry";
                break;
            }
            case 617: {
                string = "EndChannelList";
                break;
            }
            case 618: {
                string = "ChannelListEntry";
                break;
            }
            case 620: {
                string = "QueueLimit";
                break;
            }
            case 621: {
                string = "Motd";
                break;
            }
            case 626: {
                string = "DataPortError";
                break;
            }
            case 627: {
                string = "Operator";
                break;
            }
            case 628: {
                string = "Global";
                break;
            }
            case 629: {
                string = "BannedUsers";
                break;
            }
            case 640: {
                string = "DirectBrowseRequest";
                break;
            }
            case 641: {
                string = "DirectBrowseAck";
                break;
            }
            case 642: {
                string = "DirectBrowseError";
                break;
            }
            case 748: {
                string = "LoginAttempt";
                break;
            }
            case 750: {
                string = "Ping";
                break;
            }
            case 751: {
                string = "PingUser";
                break;
            }
            case 752: {
                string = "PongUser";
                break;
            }
            case 821: {
                string = "RedirectClient";
                break;
            }
            case 822: {
                string = "CycleClient";
                break;
            }
            case 824: {
                string = "Emote";
                break;
            }
            case 825: {
                string = "UserListEntry";
                break;
            }
            case 827: {
                string = "EndAllChannelList";
                break;
            }
            case 828: {
                string = "AllChannelListEntry";
                break;
            }
            case 830: {
                string = "EndUserList";
                break;
            }
            case 900: {
                string = "ConnectionTest";
                break;
            }
            case 901: {
                string = "ListenTest";
                break;
            }
            case 931: {
                string = "BlockedFile";
                break;
            }
            case 10112: {
                string = "ServerLinks";
                break;
            }
            case 10115: {
                string = "ServerStatistics";
                break;
            }
            case 10118: {
                string = "ClientStatistics";
                break;
            }
            default: {
                string = "UnknownMessage!";
            }
        }
        return string;
    }
}

