/*
 * Decompiled with CFR 0.152.
 */
package xnap.plugin.nap.net.msg.server;

import xnap.plugin.nap.net.User;
import xnap.plugin.nap.net.msg.MessageHandler;
import xnap.plugin.nap.net.msg.server.InvalidMessageException;
import xnap.plugin.nap.net.msg.server.ServerMessage;
import xnap.plugin.nap.util.PrivateChannel;
import xnap.util.Preferences;
import xnap.util.QuotedStringTokenizer;

public class PrivateMessage
extends ServerMessage {
    public static final int TYPE = 205;
    public String nick;
    public String message;

    protected void parse(QuotedStringTokenizer quotedStringTokenizer) {
        this.nick = quotedStringTokenizer.nextToken();
        this.message = quotedStringTokenizer.allNextTokens();
    }

    public void received() {
        Preferences preferences = Preferences.getInstance();
        if (!this.message.trim().equals("//WantQueue")) {
            User user = this.server.getUser(this.nick);
            if (user.isChatIgnored()) {
                if (preferences.getSendChatIgnoreMessage()) {
                    xnap.plugin.nap.net.msg.client.PrivateMessage privateMessage = new xnap.plugin.nap.net.msg.client.PrivateMessage(this.nick, preferences.getChatIgnoreMessage());
                    MessageHandler.send(this.server, privateMessage);
                }
            } else {
                PrivateChannel privateChannel = MessageHandler.createPrivateChannel(user, true);
                privateChannel.messageReceived(this.message);
            }
        }
    }

    public PrivateMessage(String string) throws InvalidMessageException {
        super(205, string, 2);
    }
}

