/*
 * Decompiled with CFR 0.152.
 */
package xnap.plugin.nap.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import xnap.plugin.nap.net.Server;
import xnap.util.QuotedStringTokenizer;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ServerFile {
    private BufferedReader in;
    private BufferedWriter out;
    private String filename;

    public void close() {
        try {
            if (this.in != null) {
                this.in.close();
            }
            if (this.out != null) {
                this.out.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public String getFilename() {
        return this.filename;
    }

    public BufferedReader getIn() {
        return this.in;
    }

    public BufferedWriter getOut() {
        return this.out;
    }

    public void openReader() throws IOException {
        this.in = new BufferedReader(new FileReader(this.getFilename()));
    }

    public void openWriter() throws IOException {
        this.out = new BufferedWriter(new FileWriter(this.getFilename(), false));
    }

    public Server readServer() throws IOException {
        String string;
        while ((string = this.getIn().readLine()) != null) {
            try {
                QuotedStringTokenizer quotedStringTokenizer = new QuotedStringTokenizer(string, " :");
                if (quotedStringTokenizer.countTokens() < 2) continue;
                String string2 = quotedStringTokenizer.nextToken();
                int n = Integer.parseInt(quotedStringTokenizer.nextToken());
                if (n < 1 || n > (char)-1) {
                    throw new NumberFormatException();
                }
                String string3 = quotedStringTokenizer.countTokens() > 0 ? quotedStringTokenizer.nextToken() : "";
                Server server = new Server(string2, n, string3);
                if (quotedStringTokenizer.countTokens() >= 3) {
                    String string4 = quotedStringTokenizer.nextToken();
                    server.setUsername(string4.length() > 0 ? string4 : null);
                    string4 = quotedStringTokenizer.nextToken();
                    server.setPassword(string4.length() > 0 ? string4 : null);
                    string4 = quotedStringTokenizer.nextToken();
                    server.setEmail(string4.length() > 0 ? string4 : null);
                }
                if (quotedStringTokenizer.countTokens() >= 1) {
                    server.setRedirector(quotedStringTokenizer.nextToken().equals("true"));
                }
                if (quotedStringTokenizer.countTokens() >= 1) {
                    quotedStringTokenizer.nextToken();
                }
                return server;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    public void writeServer(Server server) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        ServerFile.append(stringBuffer, server.getHost());
        ServerFile.append(stringBuffer, "" + server.getPort());
        ServerFile.append(stringBuffer, server.getNetwork());
        ServerFile.append(stringBuffer, server.isLoginCustomized() ? server.getUsername() : "");
        ServerFile.append(stringBuffer, server.isLoginCustomized() ? server.getPassword() : "");
        ServerFile.append(stringBuffer, server.isLoginCustomized() ? server.getEmail() : "");
        ServerFile.append(stringBuffer, server.isRedirector() ? "true" : "false");
        ServerFile.append(stringBuffer, "");
        this.out.write(stringBuffer.toString());
        this.out.newLine();
    }

    private static final void append(StringBuffer stringBuffer, String string) {
        stringBuffer.append("\"");
        stringBuffer.append(string);
        stringBuffer.append("\" ");
    }

    private final /* synthetic */ void this() {
        this.in = null;
        this.out = null;
    }

    public ServerFile(String string) {
        this.this();
        this.filename = string;
    }
}

