/*
 * Decompiled with CFR 0.152.
 */
package xnap.plugin.viewer.mp3;

import helliker.id3.MP3File;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.util.StringTokenizer;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import xnap.XNap;
import xnap.gui.GridBagHelper;
import xnap.gui.ViewerPanel;
import xnap.util.FileHelper;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class MP3InfoPanel
extends ViewerPanel {
    JTextField jtTitle;
    JTextField jtArtist;
    JTextField jtAlbum;
    JTextField jtYear;
    JTextField jtComment;
    GuessAction acGuessAction;
    SaveAction acSaveAction;
    ResetAction acResetAction;

    public void clear() {
        this.setStatus(" ");
        this.jtTitle.setText("");
        this.jtAlbum.setText("");
        this.jtArtist.setText("");
        this.jtYear.setText("");
        this.jtComment.setText("");
    }

    public void display() {
        this.clear();
        try {
            MP3File mP3File = new MP3File(this.getFile());
            this.jtAlbum.setText(mP3File.getAlbum());
            this.jtArtist.setText(mP3File.getArtist());
            this.jtTitle.setText(mP3File.getTitle());
            this.jtYear.setText(mP3File.getYear());
            this.jtComment.setText(mP3File.getComment());
            this.setEnabled(this.getFile().canWrite());
        }
        catch (Exception exception) {
            this.setEnabled(false);
            this.setStatus(XNap.tr("Could not read Id Tag") + " (" + exception.getLocalizedMessage() + ')');
        }
        this.finished = true;
    }

    protected void save() {
        try {
            MP3File mP3File = new MP3File(this.getFile());
            mP3File.setTitle(this.jtTitle.getText());
            mP3File.setArtist(this.jtArtist.getText());
            mP3File.setAlbum(this.jtAlbum.getText());
            mP3File.setYear(this.jtYear.getText());
            mP3File.setComment(this.jtComment.getText());
            mP3File.writeTags();
            this.setStatus(XNap.tr("Changes successfully saved."));
        }
        catch (Exception exception) {
            this.setStatus(XNap.tr("Could not write ID Tags to file"));
        }
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.acGuessAction.setEnabled(bl);
        this.acSaveAction.setEnabled(bl);
        this.acResetAction.setEnabled(bl);
        this.jtTitle.setEnabled(bl);
        this.jtArtist.setEnabled(bl);
        this.jtAlbum.setEnabled(bl);
        this.jtYear.setEnabled(bl);
        this.jtComment.setEnabled(bl);
    }

    private final /* synthetic */ void this() {
        this.acGuessAction = new GuessAction();
        this.acSaveAction = new SaveAction();
        this.acResetAction = new ResetAction();
    }

    public MP3InfoPanel() {
        this.this();
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(new TitledBorder(XNap.tr("ID3 Tag", 1)));
        GridBagHelper.addLabel(jPanel, XNap.tr("Title"));
        this.jtTitle = new JTextField();
        GridBagHelper.add((Container)jPanel, this.jtTitle);
        GridBagHelper.addLabel(jPanel, XNap.tr("Artist"));
        this.jtArtist = new JTextField();
        GridBagHelper.add((Container)jPanel, this.jtArtist);
        GridBagHelper.addLabel(jPanel, XNap.tr("Album"));
        this.jtAlbum = new JTextField();
        GridBagHelper.add((Container)jPanel, this.jtAlbum);
        GridBagHelper.addLabel(jPanel, XNap.tr("Year"));
        this.jtYear = new JTextField();
        GridBagHelper.add((Container)jPanel, this.jtYear);
        GridBagHelper.addLabel(jPanel, XNap.tr("Comment"));
        this.jtComment = new JTextField();
        GridBagHelper.add((Container)jPanel, this.jtComment);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(2));
        JButton jButton = new JButton(this.acGuessAction);
        jPanel2.add(jButton);
        JButton jButton2 = new JButton(this.acSaveAction);
        jPanel2.add(jButton2);
        JButton jButton3 = new JButton(this.acResetAction);
        jPanel2.add(jButton3);
        this.setLayout(new BorderLayout());
        this.add((Component)jPanel, "Center");
        this.add((Component)jPanel2, "South");
    }

    protected class GuessAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            String string = FileHelper.name(MP3InfoPanel.this.getFile().getName());
            StringTokenizer stringTokenizer = new StringTokenizer(string, "-");
            if (stringTokenizer.countTokens() == 1) {
                MP3InfoPanel.this.jtTitle.setText(stringTokenizer.nextToken().trim());
            } else if (stringTokenizer.countTokens() == 2) {
                MP3InfoPanel.this.jtArtist.setText(stringTokenizer.nextToken().trim());
                MP3InfoPanel.this.jtTitle.setText(stringTokenizer.nextToken().trim());
            } else if (stringTokenizer.countTokens() == 3) {
                MP3InfoPanel.this.jtArtist.setText(stringTokenizer.nextToken().trim());
                MP3InfoPanel.this.jtAlbum.setText(stringTokenizer.nextToken().trim());
                MP3InfoPanel.this.jtTitle.setText(stringTokenizer.nextToken().trim());
            }
        }

        public GuessAction() {
            this.putValue("Name", XNap.tr("Guess"));
            this.putValue("ShortDescription", XNap.tr("Guess Id Tags from filename"));
            this.putValue("MnemonicKey", new Integer(71));
            this.setEnabled(false);
        }
    }

    protected class ResetAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            MP3InfoPanel.this.display();
        }

        public ResetAction() {
            this.putValue("Name", XNap.tr("Reset"));
            this.putValue("ShortDescription", XNap.tr("Reset Id Tag Changes"));
            this.putValue("MnemonicKey", new Integer(82));
            this.setEnabled(false);
        }
    }

    protected class SaveAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            MP3InfoPanel.this.save();
        }

        public SaveAction() {
            this.putValue("Name", XNap.tr("Save"));
            this.putValue("ShortDescription", XNap.tr("Save new Id Tag"));
            this.putValue("MnemonicKey", new Integer(65));
            this.setEnabled(false);
        }
    }
}

