/*
 * Decompiled with CFR 0.152.
 */
package xnap.util;

import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.log4j.Logger;
import xnap.XNap;
import xnap.net.ISearch;
import xnap.util.FilesizeGrouper;
import xnap.util.Grouper;
import xnap.util.ISearchContainer;
import xnap.util.SearchFilter;
import xnap.util.SearchResultCollector;
import xnap.util.event.StatusListener;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Searcher
implements ISearchContainer,
Runnable {
    protected static Logger logger;
    protected SearchFilter filter;
    protected SearchResultCollector srCollector;
    protected LinkedList searches;
    protected boolean connected;
    protected String errStatus;
    protected int failedCount;
    protected int finishedCount;
    protected StatusListener listener;
    protected Thread runner;
    protected String status;
    protected boolean die;
    static /* synthetic */ Class class$xnap$util$Searcher;

    public void abort() {
        this.die = true;
    }

    public SearchResultCollector getCollector() {
        return this.srCollector;
    }

    public void setCollector(SearchResultCollector searchResultCollector) {
        this.srCollector = searchResultCollector;
    }

    public Grouper getDefaultGrouper() {
        return new FilesizeGrouper();
    }

    public SearchFilter getFilter() {
        return this.filter;
    }

    public int getSize() {
        return this.searches.size() + this.finishedCount + this.failedCount;
    }

    public String getStatus() {
        return this.status;
    }

    public synchronized void setStatusListener(StatusListener statusListener) {
        this.listener = statusListener;
    }

    public synchronized void setStatus(String string) {
        this.status = string;
        if (this.listener != null) {
            this.listener.setStatus(string);
        }
    }

    public void start() {
        this.runner = new Thread((Runnable)this, "Searcher " + this.toString());
        this.runner.start();
        this.updateStatus();
    }

    public void run() {
        Iterator iterator = this.searches.iterator();
        while (!this.die && iterator.hasNext()) {
            try {
                ((ISearch)iterator.next()).connect();
            }
            catch (IOException iOException) {
                iterator.remove();
                this.appendErr(iOException);
                logger.warn("connect failed", iOException);
            }
            this.updateStatus();
        }
        this.connected = true;
        this.updateStatus();
        while (!this.die && this.searches.size() > 0) {
            iterator = this.searches.iterator();
            while (iterator.hasNext()) {
                ISearch iSearch = (ISearch)iterator.next();
                try {
                    int n = iSearch.available();
                    if (n == -1) {
                        iterator.remove();
                        ++this.finishedCount;
                        this.updateStatus();
                        continue;
                    }
                    if (n <= 0) continue;
                    int n2 = 0;
                    while (n2 < n) {
                        this.srCollector.add(iSearch.next());
                        ++n2;
                    }
                }
                catch (IOException iOException) {
                    iterator.remove();
                    this.appendErr(iOException);
                    this.updateStatus();
                    logger.warn("search failed", iOException);
                }
            }
            try {
                Thread.sleep(125L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        iterator = this.searches.iterator();
        while (iterator.hasNext()) {
            ((ISearch)iterator.next()).close();
            iterator.remove();
        }
        this.updateStatus();
    }

    protected void appendErr(Exception exception) {
        ++this.failedCount;
        this.errStatus = this.errStatus + (this.errStatus.length() == 0 ? "" : ", ") + exception.getMessage();
    }

    protected void updateStatus() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.searches.size() > 0) {
            stringBuffer.append(XNap.tr("Searches:", 0, 1));
            stringBuffer.append(this.finishedCount + XNap.tr("succeeded,", 1));
            stringBuffer.append(this.failedCount + XNap.tr("failed,", 1));
            stringBuffer.append(this.searches.size() + XNap.tr("pending", 1));
        } else if (this.finishedCount + this.failedCount == 0) {
            stringBuffer.append(XNap.tr("No search started. Please load one or more plugins"));
        } else {
            stringBuffer.append(XNap.tr("Finished:", 0, 1));
            stringBuffer.append(this.finishedCount + this.failedCount);
            stringBuffer.append(XNap.tr("searches", 1, 0));
            if (this.failedCount > 0) {
                stringBuffer.append(", ");
                stringBuffer.append(this.failedCount);
                stringBuffer.append(XNap.tr("failed,", 1, 0));
            }
        }
        if (this.errStatus.length() > 0) {
            stringBuffer.append(" (");
            stringBuffer.append(this.errStatus);
            stringBuffer.append(")");
        }
        this.setStatus(stringBuffer.toString());
    }

    public String toString() {
        return this.filter != null ? this.filter.toString() : "";
    }

    static /* synthetic */ Class class$(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.connected = false;
        this.errStatus = "";
        this.listener = null;
        this.status = "";
        this.die = false;
    }

    public Searcher(ISearch[] iSearchArray, SearchFilter searchFilter, SearchResultCollector searchResultCollector) {
        this.this();
        this.searches = new LinkedList<ISearch>(Arrays.asList(iSearchArray));
        this.filter = searchFilter;
        this.srCollector = searchResultCollector;
    }

    public Searcher(ISearch[] iSearchArray, SearchFilter searchFilter) {
        this(iSearchArray, searchFilter, null);
    }

    static {
        Class clazz = class$xnap$util$Searcher;
        if (clazz == null) {
            clazz = class$xnap$util$Searcher = Searcher.class$("[Lxnap.util.Searcher;", false);
        }
        logger = Logger.getLogger(clazz);
    }
}

