/*
 * Decompiled with CFR 0.152.
 */
package xnap.util;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import xnap.net.IDownloadContainer;
import xnap.net.ITransferContainer;
import xnap.net.IUser;
import xnap.util.StringHelper;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class TransferLogger {
    public static String[] MONTHES = new String[]{"Jan", "Feb", "Mar", "Apr", "Mai", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
    private BufferedWriter out;
    private String filename;

    public void close() {
        try {
            if (this.out != null) {
                this.out.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void setFilename(String string) throws IOException {
        if (!string.equals(this.filename)) {
            this.filename = string;
            this.close();
            this.out = new BufferedWriter(new FileWriter(string, true));
        }
    }

    public void write(ITransferContainer iTransferContainer) throws IOException {
        IUser iUser = iTransferContainer.getUser();
        StringBuffer stringBuffer = new StringBuffer();
        String string = iUser.getHost();
        stringBuffer.append(string != null && string.length() > 0 ? string : "-");
        stringBuffer.append(" - \"");
        stringBuffer.append(this.mangleUsername(iUser.getName()));
        stringBuffer.append("\" [");
        Date date = new Date();
        stringBuffer.append(new SimpleDateFormat("dd/").format(date));
        stringBuffer.append(MONTHES[Calendar.getInstance().get(2)]);
        stringBuffer.append(new SimpleDateFormat("/yyyy:HH:mm:ss z").format(date));
        stringBuffer.append("] \"");
        stringBuffer.append(iTransferContainer instanceof IDownloadContainer ? "GET " : "PUT ");
        File file = iTransferContainer.getFile();
        stringBuffer.append(file != null ? StringHelper.replaceAll(file.getAbsolutePath(), " ", "%20") : "-");
        stringBuffer.append("\" ");
        stringBuffer.append(iTransferContainer.getStatus() == 6 ? 200 : 400);
        stringBuffer.append(" ");
        stringBuffer.append(file != null ? file.length() : 0L);
        stringBuffer.append(" - ");
        string = iUser.getClientInfo();
        if (string != null) {
            stringBuffer.append("\"");
            stringBuffer.append(string);
            stringBuffer.append("\"");
        } else {
            stringBuffer.append("-");
        }
        this.out.write(stringBuffer.toString());
        this.out.newLine();
        this.out.flush();
    }

    private final String mangleUsername(String string) {
        string = StringHelper.replaceAll(string, "[", "%5B");
        string = StringHelper.replaceAll(string, "]", "%5D");
        return string;
    }

    private final /* synthetic */ void this() {
        this.out = null;
        this.filename = null;
    }

    public TransferLogger(String string) throws IOException {
        this.this();
        this.setFilename(string);
    }
}

