/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.Camera;
import artofillusion.LayoutWindow;
import artofillusion.Scene;
import artofillusion.UndoRecord;
import artofillusion.ViewerCanvas;
import artofillusion.animation.PositionTrack;
import artofillusion.animation.RotationTrack;
import artofillusion.math.CoordinateSystem;
import artofillusion.math.RGBColor;
import artofillusion.math.Vec3;
import artofillusion.object.DirectionalLight;
import artofillusion.object.Light;
import artofillusion.object.ObjectInfo;
import artofillusion.object.PointLight;
import artofillusion.object.SpotLight;
import artofillusion.ui.EditingTool;
import artofillusion.ui.Translate;
import buoy.event.WidgetMouseEvent;
import java.awt.Point;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;

public class CreateLightTool
extends EditingTool {
    static int counter = 2;
    Point clickPoint;
    Point dragPoint;
    boolean controlDown;

    public CreateLightTool(LayoutWindow fr) {
        super(fr);
        this.initButton("light");
    }

    @Override
    public void activate() {
        super.activate();
        this.theWindow.setHelpText(Translate.text("createLightTool.helpText"));
    }

    @Override
    public int whichClicks() {
        return 1;
    }

    @Override
    public String getToolTipText() {
        return Translate.text("createLightTool.tipText");
    }

    @Override
    public void mousePressed(WidgetMouseEvent e, ViewerCanvas view) {
        this.clickPoint = e.getPoint();
        this.dragPoint = null;
        this.controlDown = e.isControlDown();
    }

    @Override
    public void mouseDragged(WidgetMouseEvent e, ViewerCanvas view) {
        this.dragPoint = e.getPoint();
        GeneralPath path = new GeneralPath();
        path.append(new Line2D.Double(this.clickPoint.x, this.clickPoint.y, this.dragPoint.x, this.dragPoint.y), false);
        if (this.controlDown) {
            double dx = this.dragPoint.x - this.clickPoint.x;
            double dy = this.dragPoint.y - this.clickPoint.y;
            double len = Math.sqrt(dx * dx + dy * dy);
            double angle = (int)(Math.atan(50.0 / len) * 360.0 / Math.PI);
            this.theWindow.setHelpText(Translate.text("createLightTool.dragText", (Object)Double.toString(angle)));
            path.append(new Line2D.Double(this.clickPoint.x, this.clickPoint.y, this.dragPoint.x + (int)(dy * 50.0 / len), this.dragPoint.y - (int)(dx * 50.0 / len)), false);
            path.append(new Line2D.Double(this.clickPoint.x, this.clickPoint.y, this.dragPoint.x - (int)(dy * 50.0 / len), this.dragPoint.y + (int)(dx * 50.0 / len)), false);
        }
        view.drawDraggedShape(path);
    }

    @Override
    public void mouseReleased(WidgetMouseEvent e, ViewerCanvas view) {
        Light obj;
        Vec3 zdir;
        Vec3 ydir;
        Scene theScene = ((LayoutWindow)this.theWindow).getScene();
        Camera cam = view.getCamera();
        Vec3 orig = cam.convertScreenToWorld(this.clickPoint, view.getDistToPlane());
        if (this.dragPoint == null) {
            ydir = new Vec3(0.0, 1.0, 0.0);
            zdir = new Vec3(0.0, 0.0, 1.0);
            obj = new PointLight(new RGBColor(1.0f, 1.0f, 1.0f), 1.0f, 0.1);
        } else {
            this.dragPoint = e.getPoint();
            zdir = cam.findDragVector(cam.convertScreenToWorld(this.clickPoint, view.getDistToPlane()), this.dragPoint.x - this.clickPoint.x, this.dragPoint.y - this.clickPoint.y);
            zdir.normalize();
            ydir = cam.getViewToWorld().times(Vec3.vz());
            if (this.controlDown) {
                double dx = this.dragPoint.x - this.clickPoint.x;
                double dy = this.dragPoint.y - this.clickPoint.y;
                double len = Math.sqrt(dx * dx + dy * dy);
                double angle = (int)(Math.atan(50.0 / len) * 360.0 / Math.PI);
                obj = new SpotLight(new RGBColor(1.0f, 1.0f, 1.0f), 1.0f, angle, 0.0, 0.1);
                this.theWindow.setHelpText(Translate.text("createLightTool.helpText"));
            } else {
                obj = new DirectionalLight(new RGBColor(1.0f, 1.0f, 1.0f), 1.0f);
            }
        }
        ObjectInfo info = new ObjectInfo(obj, new CoordinateSystem(orig, zdir, ydir), "Light " + counter++);
        info.addTrack(new PositionTrack(info), 0);
        info.addTrack(new RotationTrack(info), 1);
        UndoRecord undo = new UndoRecord(this.theWindow, false);
        int[] sel = ((LayoutWindow)this.theWindow).getSelectedIndices();
        ((LayoutWindow)this.theWindow).addObject(info, undo);
        undo.addCommand(16, new Object[]{sel});
        this.theWindow.setUndoRecord(undo);
        ((LayoutWindow)this.theWindow).setSelection(theScene.getNumObjects() - 1);
        this.theWindow.updateImage();
    }
}

